/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.model;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.tcf.internal.debug.Activator;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsModel;
import org.eclipse.tcf.protocol.Protocol;

public class TCFBreakpoint
extends Breakpoint {
    public static final String MARKER_TYPE = "org.eclipse.tcf.debug.breakpoint.marker";
    private static long last_id = 0L;

    private static String createNewID() {
        assert (Protocol.isDispatchThread());
        long id = System.currentTimeMillis();
        if (id <= last_id) {
            id = last_id + 1L;
        }
        last_id = id;
        return Long.toHexString(id);
    }

    public static TCFBreakpoint createFromMarkerAttributes(Map<String, Object> attrs) throws CoreException {
        assert (!Protocol.isDispatchThread());
        assert (attrs.get("org.eclipse.tcf.debug.ID") != null);
        TCFBreakpoint bp = new TCFBreakpoint();
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        IMarker marker = resource.createMarker(MARKER_TYPE);
        bp.setMarker(marker);
        marker.setAttributes(attrs);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)bp);
        return bp;
    }

    public static TCFBreakpoint createFromTCFProperties(Map<String, Object> props) {
        assert (Protocol.isDispatchThread());
        if (props.get("ID") == null) {
            props.put("ID", TCFBreakpoint.createNewID());
        }
        TCFBreakpoint bp = new TCFBreakpoint();
        Map<String, Object> m = Activator.getBreakpointsModel().toMarkerAttributes(props);
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        ISchedulingRule rule = bp.getMarkerRule((IResource)resource);
        WorkspaceJob job = new WorkspaceJob("Add Breakpoint", (IResource)resource, bp, m){
            private final /* synthetic */ IResource val$resource;
            private final /* synthetic */ TCFBreakpoint val$bp;
            private final /* synthetic */ Map val$m;
            {
                this.val$resource = iResource;
                this.val$bp = tCFBreakpoint;
                this.val$m = map;
                super($anonymous0);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IMarker marker = this.val$resource.createMarker(TCFBreakpoint.MARKER_TYPE);
                this.val$bp.setMarker(marker);
                marker.setAttributes(this.val$m);
                DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this.val$bp);
                return Status.OK_STATUS;
            }
        };
        job.setRule(rule);
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
        return bp;
    }

    public void setEnabled(boolean b) throws CoreException {
        Activator.getBreakpointsModel();
        if (!TCFBreakpointsModel.isLocal(this.getMarker())) {
            return;
        }
        super.setEnabled(b);
    }

    public String getModelIdentifier() {
        return "org.eclipse.tcf.debug";
    }

    public void notifyStatusChaged() throws CoreException {
        IMarker marker = this.getMarker();
        if (marker == null) {
            return;
        }
        int cnt = 0;
        String status = marker.getAttribute("org.eclipse.tcf.debug.Status", null);
        if (status != null) {
            cnt = Integer.parseInt(status);
        }
        this.setAttribute("org.eclipse.tcf.debug.Status", Integer.toString(cnt + 1));
    }
}

