/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.sections;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.NumberVerifyListener;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PingTimeoutSection
extends AbstractSection
implements IDataExchangeNode {
    Text verbosity;
    Label verbosityLabel;

    public PingTimeoutSection(IManagedForm form, Composite parent) {
        super(form, parent, 0);
        this.createClient(this.getSection(), form.getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.PingTimeoutSection_title);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 1, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        Composite panel = toolkit.createComposite(client);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 1, true, false));
        panel.setBackground(client.getBackground());
        this.verbosityLabel = toolkit.createLabel(panel, Messages.PingTimeoutSection_timeout_label, 256);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        this.verbosityLabel.setLayoutData((Object)layoutData);
        this.verbosityLabel.setBackground(client.getBackground());
        this.verbosity = new Text(panel, 2048);
        toolkit.adapt((Control)this.verbosity, true, true);
        this.verbosity.addVerifyListener((VerifyListener)new NumberVerifyListener(0, -1));
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = SWTControlUtil.convertWidthInCharsToPixels((Control)this.verbosity, (int)5);
        this.verbosity.setLayoutData((Object)layoutData);
    }

    public void initializeWidgets(IPropertiesContainer attributes) {
        Assert.isNotNull((Object)attributes);
        if (this.verbosity != null) {
            int timeout = attributes.getIntProperty("pingTimeout");
            if (timeout >= 0) {
                SWTControlUtil.setText((Control)this.verbosity, (String)String.valueOf(timeout));
            } else {
                SWTControlUtil.setText((Control)this.verbosity, (String)"2");
            }
        }
    }

    public void updateAttributes(IPropertiesContainer attributes) {
        Assert.isNotNull((Object)attributes);
        String value = SWTControlUtil.getText((Control)this.verbosity);
        if (value != null && !"".equals(value)) {
            attributes.setProperty("pingTimeout", (Object)value);
        }
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        SWTControlUtil.setEnabled((Control)this.verbosity, (!readOnly ? 1 : 0) != 0);
    }

    public void setupData(IPropertiesContainer data) {
        this.initializeWidgets(data);
    }

    public void extractData(IPropertiesContainer data) {
        this.updateAttributes(data);
    }
}

