/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.search;

import java.lang.reflect.InvocationTargetException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.ui.interfaces.ISearchMatcher;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.search.AbstractSearcher;

public class BreadthFirstSearcher
extends AbstractSearcher {
    private final Queue<TreePath> queue = new ConcurrentLinkedQueue<TreePath>();

    public BreadthFirstSearcher(TreeViewer viewer, ISearchable searchable) {
        super(viewer, searchable);
    }

    @Override
    public void setStartPath(TreePath path) {
        this.queue.clear();
        Assert.isTrue((boolean)this.queue.offer(path));
    }

    @Override
    public TreePath searchNext(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        TreePath result = null;
        ISearchMatcher matcher = this.fSearchable.getMatcher();
        while (this.queue != null && !this.queue.isEmpty() && result == null && !monitor.isCanceled()) {
            TreePath path = this.queue.poll();
            Object element = path.getLastSegment();
            Object[] children = this.getUpdatedChildren(element, monitor);
            if (children != null && children.length > 0) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    TreePath childPath = path.createChildPath(child);
                    Assert.isTrue((boolean)this.queue.offer(childPath));
                    ++n2;
                }
            }
            String elementText = this.fSearchable.getElementText(element);
            monitor.subTask(elementText);
            if (!matcher.match(element)) continue;
            result = path;
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        return result;
    }
}

