/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.EventObject;
import org.eclipse.remote.core.AbstractRemoteProcess;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessStateChangeEvent;
import org.eclipse.tcf.te.tcf.remote.core.TCFProcessStreams;

public class TCFProcess
extends AbstractRemoteProcess
implements IEventListener {
    private InputStream fStdout;
    private InputStream fStderr;
    private OutputStream fStdin;
    private PipedOutputStream fCombinedOutput;
    private int fReadersDone;
    private final ProcessLauncher fLauncher;
    private int fExitValue;
    private boolean fCompleted;

    public TCFProcess(ProcessLauncher launcher) {
        this.fLauncher = launcher;
        EventManager.getInstance().addEventListener((IEventListener)this, ProcessStateChangeEvent.class);
    }

    public void connectStreams(TCFProcessStreams streams, boolean redirectStderr) throws IOException {
        if (redirectStderr) {
            this.fCombinedOutput = new PipedOutputStream();
            this.fStdout = new PipedInputStream(this.fCombinedOutput);
            this.fStderr = null;
            new Thread(new StreamForwarder(streams.getStdout(), this.fCombinedOutput)).start();
            new Thread(new StreamForwarder(streams.getStderr(), this.fCombinedOutput)).start();
        } else {
            this.fStdout = streams.getStdout();
            this.fStderr = streams.getStderr();
        }
        this.fStdin = streams.getStdin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onProcReaderDone() {
        TCFProcess tCFProcess = this;
        synchronized (tCFProcess) {
            if (++this.fReadersDone == 2) {
                try {
                    this.fCombinedOutput.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        TCFProcess tCFProcess = this;
        synchronized (tCFProcess) {
            if (this.fCompleted) {
                return;
            }
        }
        this.fLauncher.cancel();
        this.fLauncher.terminate();
        tCFProcess = this;
        synchronized (tCFProcess) {
            if (!this.fCompleted) {
                this.fExitValue = -1;
                this.fCompleted = true;
                ((Object)((Object)this)).notifyAll();
            }
        }
        EventManager.getInstance().removeEventListener((IEventListener)this);
    }

    public int exitValue() {
        return this.fExitValue;
    }

    public InputStream getErrorStream() {
        return this.fStderr != null ? this.fStderr : new NullInputStream();
    }

    public InputStream getInputStream() {
        return this.fStdout != null ? this.fStdout : new NullInputStream();
    }

    public OutputStream getOutputStream() {
        return this.fStdin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        TCFProcess tCFProcess = this;
        synchronized (tCFProcess) {
            while (!this.isCompleted()) {
                ((Object)((Object)this)).wait();
            }
        }
        return this.exitValue();
    }

    public boolean isCompleted() {
        return this.fCompleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventFired(EventObject event) {
        IProcesses.ProcessContext context;
        Object source;
        ProcessStateChangeEvent pscEvent;
        if (event instanceof ProcessStateChangeEvent && (pscEvent = (ProcessStateChangeEvent)event).getEventId().equals("terminated") && (source = pscEvent.getSource()) instanceof IProcesses.ProcessContext && (context = (IProcesses.ProcessContext)this.fLauncher.getAdapter(IProcesses.ProcessContext.class)) != null && ((IProcesses.ProcessContext)source).getID().equals(context.getID())) {
            TCFProcess tCFProcess = this;
            synchronized (tCFProcess) {
                this.fExitValue = pscEvent.getExitCode();
                this.fCompleted = true;
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    private static class NullInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }

    private class StreamForwarder
    implements Runnable {
        private static final int BUF_SIZE = 8192;
        private final InputStream fInput;
        private final OutputStream fOutput;

        public StreamForwarder(InputStream input, OutputStream output) {
            this.fInput = input;
            this.fOutput = output;
        }

        @Override
        public void run() {
            byte[] b = new byte[8192];
            try {
                int len;
                while ((len = this.fInput.read(b)) > 0) {
                    this.fOutput.write(b, 0, len);
                }
            }
            catch (IOException iOException) {}
            TCFProcess.this.onProcReaderDone();
        }
    }
}

