/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.tabbed;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.tcf.ui.tabbed.BaseTitledSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class IDSection
extends BaseTitledSection {
    IProcessContextNode node;
    ISysMonitor.SysMonitorContext context;
    private CLabel pidLabel;
    private Text pidText;
    private CLabel ppidLabel;
    private Text ppidText;
    private CLabel ipidLabel;
    private Text ipidText;
    private CLabel ippidLabel;
    private Text ippidText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.pidText = this.createText(null);
        this.pidLabel = this.createLabel((Control)this.pidText, Messages.IDSection_ProcessID);
        this.ppidText = this.createText((Control)this.pidText);
        this.ppidLabel = this.createLabel((Control)this.ppidText, Messages.IDSection_ParentID);
        this.ipidText = this.createText((Control)this.ppidText);
        this.ipidLabel = this.createLabel((Control)this.ipidText, Messages.IDSection_InternalID);
        this.ippidText = this.createText((Control)this.ipidText);
        this.ippidLabel = this.createLabel((Control)this.ippidText, Messages.IDSection_InternalPPID);
    }

    protected void updateInput(IPeerNodeProvider input) {
        IProcessContextNode node;
        Assert.isTrue((boolean)(input instanceof IProcessContextNode));
        this.node = node = (IProcessContextNode)input;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IDSection.this.context = node.getSysMonitorContext();
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    public void refresh() {
        String label;
        IPeerNode peerNode = (IPeerNode)this.node.getAdapter(IPeerNode.class);
        IProcessMonitorUIDelegate delegate = (IProcessMonitorUIDelegate)ServiceUtils.getUIServiceDelegate((Object)peerNode, (Object)peerNode, IProcessMonitorUIDelegate.class);
        String string = label = delegate != null ? delegate.getMessage("IDSection_Title") : null;
        if (label != null && this.section != null && !this.section.isDisposed()) {
            this.section.setText(label);
        }
        String string2 = label = delegate != null ? delegate.getMessage("IDSection_ProcessID") : null;
        if (label != null) {
            SWTControlUtil.setText((Control)this.pidLabel, (String)label);
        }
        String string3 = label = delegate != null ? delegate.getMessage("IDSection_ParentID") : null;
        if (label != null) {
            SWTControlUtil.setText((Control)this.ppidLabel, (String)label);
        }
        String string4 = label = delegate != null ? delegate.getMessage("IDSection_InternalID") : null;
        if (label != null) {
            SWTControlUtil.setText((Control)this.ipidLabel, (String)label);
        }
        String string5 = label = delegate != null ? delegate.getMessage("IDSection_InternalPPID") : null;
        if (label != null) {
            SWTControlUtil.setText((Control)this.ippidLabel, (String)label);
        }
        String value = this.context != null && this.context.getPID() >= 0L ? Long.toString(this.context.getPID()) : "";
        String value2 = delegate != null ? delegate.getText(this.node, "PID", value) : null;
        SWTControlUtil.setText((Control)this.pidText, (String)(value2 != null ? value2 : value));
        value = this.context != null && this.context.getPPID() >= 0L ? Long.toString(this.context.getPPID()) : "";
        value2 = delegate != null ? delegate.getText(this.node, "PPID", value) : null;
        SWTControlUtil.setText((Control)this.ppidText, (String)(value2 != null ? value2 : value));
        SWTControlUtil.setText((Control)this.ipidText, (String)(this.context != null && this.context.getID() != null ? this.context.getID() : ""));
        SWTControlUtil.setText((Control)this.ippidText, (String)(this.context != null && this.context.getParentID() != null ? this.context.getParentID() : ""));
        super.refresh();
    }

    protected String getText() {
        return Messages.IDSection_Title;
    }
}

