/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tcf.debug.ui.ITCFExecContext;
import org.eclipse.tcf.internal.debug.model.TCFBreakpointsModel;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFFunctionRef;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.model.TCFSymFileRef;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.ISymbolOwner;
import org.eclipse.tcf.internal.debug.ui.model.StyledStringBuffer;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenContextQuery;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenHoverExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenLogExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenModules;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenRegisters;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFMemoryBlockRetrieval;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeSymbol;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IWorkbenchPart;

public class TCFNodeExecContext
extends TCFNode
implements ISymbolOwner,
ITCFExecContext {
    private final TCFChildrenExecContext children_exec;
    private final TCFChildrenStackTrace children_stack;
    private final TCFChildrenRegisters children_regs;
    private final TCFChildrenExpressions children_exps;
    private final TCFChildrenHoverExpressions children_hover_exps;
    private final TCFChildrenLogExpressions children_log_exps;
    private final TCFChildrenModules children_modules;
    private final TCFChildrenContextQuery children_query;
    private final TCFNode.TCFData<IMemory.MemoryContext> mem_context;
    private final TCFNode.TCFData<IRunControl.RunControlContext> run_context;
    private final TCFNode.TCFData<MemoryRegion[]> memory_map;
    private final TCFNode.TCFData<IProcesses.ProcessContext> prs_context;
    private final TCFNode.TCFData<TCFContextState> state;
    private final TCFNode.TCFData<BigInteger> address;
    private final TCFNode.TCFData<Collection<Map<String, Object>>> signal_list;
    private final TCFNode.TCFData<SignalMask[]> signal_mask;
    private final TCFNode.TCFData<TCFNodeExecContext> memory_node;
    private final TCFNode.TCFData<TCFNodeExecContext> symbols_node;
    private final TCFNode.TCFData<String> full_name;
    private LinkedHashMap<BigInteger, TCFDataCache<TCFSymFileRef>> syms_info_lookup_cache;
    private LinkedHashMap<BigInteger, TCFDataCache<TCFSourceRef>> line_info_lookup_cache;
    private LinkedHashMap<BigInteger, TCFDataCache<TCFFunctionRef>> func_info_lookup_cache;
    private LookupCacheTimer lookup_cache_timer;
    private int mem_seq_no;
    private int exe_seq_no;
    private static final TCFNode[] empty_node_array = new TCFNode[0];
    private final Map<String, TCFNodeSymbol> symbols = new HashMap<String, TCFNodeSymbol>();
    private int resumed_cnt;
    private boolean resume_pending;
    private boolean resumed_by_action;
    private TCFNode[] last_stack_trace;
    private TCFNode[] last_children_list;
    private String last_label;
    private ImageDescriptor last_image;
    private ChildrenStateInfo last_children_state_info;
    private boolean delayed_children_list_delta;

    TCFNodeExecContext(TCFNode parent, final String id) {
        super(parent, id);
        this.children_exec = new TCFChildrenExecContext(this);
        this.children_stack = new TCFChildrenStackTrace(this);
        this.children_regs = new TCFChildrenRegisters(this);
        this.children_exps = new TCFChildrenExpressions(this);
        this.children_hover_exps = new TCFChildrenHoverExpressions(this);
        this.children_log_exps = new TCFChildrenLogExpressions(this);
        this.children_modules = new TCFChildrenModules(this);
        this.children_query = new TCFChildrenContextQuery(this);
        this.mem_context = new TCFNode.TCFData<IMemory.MemoryContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IMemory mem = (IMemory)TCFNodeExecContext.this.launch.getService(IMemory.class);
                if (mem == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = mem.getContext(id, new IMemory.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IMemory.MemoryContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.run_context = new TCFNode.TCFData<IRunControl.RunControlContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IRunControl run = (IRunControl)TCFNodeExecContext.this.launch.getService(IRunControl.class);
                if (run == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = run.getContext(id, new IRunControl.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext context) {
                        if (context != null) {
                            (this).TCFNodeExecContext.this.model.getContextMap().put(id, context);
                        }
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.prs_context = new TCFNode.TCFData<IProcesses.ProcessContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IProcesses prs = (IProcesses)TCFNodeExecContext.this.launch.getService(IProcesses.class);
                if (prs == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = prs.getContext(id, new IProcesses.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                        this.set(token, error, context);
                    }
                });
                return false;
            }
        };
        this.memory_map = new TCFNode.TCFData<MemoryRegion[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                IMemoryMap mmap = (IMemoryMap)TCFNodeExecContext.this.launch.getService(IMemoryMap.class);
                if (mmap == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = mmap.get(id, new IMemoryMap.DoneGet(){

                    public void doneGet(IToken token, Exception error, IMemoryMap.MemoryRegion[] map) {
                        MemoryRegion[] arr = null;
                        if (map != null) {
                            int i = 0;
                            arr = new MemoryRegion[map.length];
                            IMemoryMap.MemoryRegion[] memoryRegionArray = map;
                            int n = map.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IMemoryMap.MemoryRegion r = memoryRegionArray[n2];
                                arr[i++] = new MemoryRegion(r);
                                ++n2;
                            }
                        }
                        this.set(token, error, arr);
                    }
                });
                return false;
            }
        };
        this.state = new TCFNode.TCFData<TCFContextState>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                if (ctx == null || !ctx.hasState()) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = ctx.getState(new IRunControl.DoneGetState(){

                    public void doneGetState(IToken token, Exception error, boolean suspended, String pc, String reason, Map<String, Object> params) {
                        TCFContextState s = new TCFContextState();
                        s.is_suspended = suspended;
                        s.suspend_pc = pc;
                        s.suspend_reason = reason;
                        s.suspend_params = params;
                        this.set(token, error, s);
                    }
                });
                return false;
            }
        };
        this.address = new TCFNode.TCFData<BigInteger>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                if (ctx == null || !ctx.hasState()) {
                    this.set(null, TCFNodeExecContext.this.run_context.getError(), null);
                    return true;
                }
                if (!TCFNodeExecContext.this.state.validate((Runnable)((Object)this))) {
                    return false;
                }
                TCFContextState s = (TCFContextState)TCFNodeExecContext.this.state.getData();
                if (s == null) {
                    this.set(null, TCFNodeExecContext.this.state.getError(), null);
                    return true;
                }
                if (!s.is_suspended || s.suspend_pc == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.set(null, null, new BigInteger(s.suspend_pc));
                return true;
            }
        };
        this.signal_list = new TCFNode.TCFData<Collection<Map<String, Object>>>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IProcesses prs = (IProcesses)this.channel.getRemoteService(IProcesses.class);
                if (prs == null) {
                    this.set(null, null, null);
                    return true;
                }
                this.command = prs.getSignalList(id, new IProcesses.DoneGetSignalList(){

                    public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                        this.set(token, error, list);
                    }
                });
                return false;
            }
        };
        this.signal_mask = new TCFNode.TCFData<SignalMask[]>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.signal_list.validate((Runnable)((Object)this))) {
                    return false;
                }
                IProcesses prs = (IProcesses)this.channel.getRemoteService(IProcesses.class);
                final Collection sigs = (Collection)TCFNodeExecContext.this.signal_list.getData();
                if (prs == null || sigs == null) {
                    this.set(null, TCFNodeExecContext.this.signal_list.getError(), null);
                    return true;
                }
                this.command = prs.getSignalMask(id, new IProcesses.DoneGetSignalMask(){

                    public void doneGetSignalMask(IToken token, Exception error, int dont_stop, int dont_pass, int pending) {
                        int n = 0;
                        SignalMask[] list = new SignalMask[sigs.size()];
                        for (Map m : sigs) {
                            int n2 = n++;
                            SignalMask signalMask = new SignalMask();
                            list[n2] = signalMask;
                            SignalMask s = signalMask;
                            s.props = m;
                            int mask = 1 << s.getIndex().intValue();
                            s.dont_stop = (dont_stop & mask) != 0;
                            s.dont_pass = (dont_pass & mask) != 0;
                            boolean bl = s.pending = (pending & mask) != 0;
                        }
                        this.set(token, error, list);
                    }
                });
                return false;
            }
        };
        this.memory_node = new TCFNode.TCFData<TCFNodeExecContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IRunControl.RunControlContext ctx;
                String mem_id = null;
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                Throwable err = TCFNodeExecContext.this.run_context.getError();
                if (err == null && (ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData()) != null) {
                    mem_id = ctx.getProcessID();
                }
                if (err != null) {
                    this.set(null, err, null);
                } else if (mem_id == null) {
                    this.set(null, new Exception("Context does not provide memory access"), null);
                } else {
                    if (!TCFNodeExecContext.this.model.createNode(mem_id, (Runnable)((Object)this))) {
                        return false;
                    }
                    if (!this.isValid()) {
                        this.set(null, null, (TCFNodeExecContext)TCFNodeExecContext.this.model.getNode(mem_id));
                    }
                }
                return true;
            }
        };
        this.symbols_node = new TCFNode.TCFData<TCFNodeExecContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                IRunControl.RunControlContext ctx;
                String syms_id = null;
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                Throwable err = TCFNodeExecContext.this.run_context.getError();
                if (err == null && (ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData()) != null && (syms_id = ctx.getSymbolsGroup()) == null) {
                    syms_id = ctx.getProcessID();
                }
                if (err != null) {
                    this.set(null, err, null);
                } else if (syms_id == null) {
                    this.set(null, new Exception("Context does not support symbol groups"), null);
                } else {
                    if (!TCFNodeExecContext.this.model.createNode(syms_id, (Runnable)((Object)this))) {
                        return false;
                    }
                    if (!this.isValid()) {
                        this.set(null, null, (TCFNodeExecContext)TCFNodeExecContext.this.model.getNode(syms_id));
                    }
                }
                return true;
            }
        };
        this.full_name = new TCFNode.TCFData<String>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.run_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                String res = null;
                if (ctx != null) {
                    res = ctx.getName();
                    if (res == null) {
                        res = ctx.getID();
                    } else {
                        String name;
                        TCFNodeExecContext p = TCFNodeExecContext.this;
                        ArrayList<String> lst = new ArrayList<String>();
                        lst.add(res);
                        while (p.parent instanceof TCFNodeExecContext) {
                            p = (TCFNodeExecContext)p.parent;
                            TCFNode.TCFData run_ctx_cache = p.run_context;
                            if (!run_ctx_cache.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            IRunControl.RunControlContext run_ctx_data = (IRunControl.RunControlContext)run_ctx_cache.getData();
                            name = null;
                            if (run_ctx_data != null) {
                                name = run_ctx_data.getName();
                            }
                            if (name == null) {
                                name = "";
                            }
                            lst.add(name);
                        }
                        StringBuffer bf = new StringBuffer();
                        int i = lst.size();
                        while (i > 0) {
                            name = (String)lst.get(i - 1);
                            boolean quote = name.indexOf(47) >= 0;
                            bf.append('/');
                            if (quote) {
                                bf.append('\"');
                            }
                            bf.append(name);
                            if (quote) {
                                bf.append('\"');
                            }
                            --i;
                        }
                        res = bf.toString();
                    }
                }
                this.set(null, null, res);
                return true;
            }
        };
        TCFMemoryBlockRetrieval.onMemoryNodeCreated(this);
        this.updateTerminal();
    }

    @Override
    void dispose() {
        assert (!this.isDisposed());
        ArrayList<TCFNodeSymbol> l = new ArrayList<TCFNodeSymbol>(this.symbols.values());
        for (TCFNodeSymbol s : l) {
            s.dispose();
        }
        assert (this.symbols.size() == 0);
        super.dispose();
    }

    void setMemSeqNo(int no) {
        this.mem_seq_no = no;
    }

    void setExeSeqNo(int no) {
        this.exe_seq_no = no;
    }

    TCFChildren getHoverExpressionCache(String expression) {
        this.children_hover_exps.setExpression(expression);
        return this.children_hover_exps;
    }

    public TCFChildrenLogExpressions getLogExpressionCache() {
        return this.children_log_exps;
    }

    void setRunContext(IRunControl.RunControlContext ctx) {
        this.run_context.reset(ctx);
    }

    void setProcessContext(IProcesses.ProcessContext ctx) {
        this.prs_context.reset(ctx);
    }

    void setMemoryContext(IMemory.MemoryContext ctx) {
        this.mem_context.reset(ctx);
    }

    public TCFDataCache<TCFNodeExecContext> getSymbolsNode() {
        return this.symbols_node;
    }

    public TCFDataCache<TCFNodeExecContext> getMemoryNode() {
        return this.memory_node;
    }

    public TCFDataCache<MemoryRegion[]> getMemoryMap() {
        return this.memory_map;
    }

    public TCFDataCache<Collection<Map<String, Object>>> getSignalList() {
        return this.signal_list;
    }

    public TCFDataCache<SignalMask[]> getSignalMask() {
        return this.signal_mask;
    }

    public TCFDataCache<TCFSymFileRef> getSymFileInfo(final BigInteger addr) {
        TCFNode.TCFData<TCFSymFileRef> ref_cache;
        if (addr == null || this.isDisposed()) {
            return null;
        }
        if (this.syms_info_lookup_cache != null && (ref_cache = this.syms_info_lookup_cache.get(addr)) != null) {
            return ref_cache;
        }
        final ISymbols syms = (ISymbols)this.launch.getService(ISymbols.class);
        if (syms == null) {
            return null;
        }
        if (this.syms_info_lookup_cache == null) {
            this.syms_info_lookup_cache = new LinkedHashMap(11, 0.75f, true);
            if (this.lookup_cache_timer == null) {
                this.lookup_cache_timer = new LookupCacheTimer();
            }
        }
        ref_cache = new TCFNode.TCFData<TCFSymFileRef>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.memory_node.validate((Runnable)((Object)this))) {
                    return false;
                }
                IMemory.MemoryContext mem_data = null;
                TCFNodeExecContext mem = (TCFNodeExecContext)TCFNodeExecContext.this.memory_node.getData();
                if (mem != null) {
                    TCFNode.TCFData mem_cache = mem.mem_context;
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    mem_data = (IMemory.MemoryContext)mem_cache.getData();
                }
                final TCFSymFileRef ref_data = new TCFSymFileRef();
                if (mem_data != null) {
                    ref_data.context_id = mem_data.getID();
                    ref_data.address_size = mem_data.getAddressSize();
                }
                this.command = syms.getSymFileInfo(ref_data.context_id, (Number)addr, new ISymbols.DoneGetSymFileInfo(){

                    public void doneGetSymFileInfo(IToken token, Exception error, Map<String, Object> props) {
                        ref_data.address = addr;
                        ref_data.error = error;
                        ref_data.props = props;
                        this.set(token, null, ref_data);
                    }
                });
                return false;
            }
        };
        this.syms_info_lookup_cache.put(addr, (TCFDataCache<TCFSymFileRef>)ref_cache);
        return ref_cache;
    }

    public TCFDataCache<TCFSourceRef> getLineInfo(final BigInteger addr) {
        TCFNode.TCFData<TCFSourceRef> ref_cache;
        if (this.isDisposed()) {
            return null;
        }
        if (this.line_info_lookup_cache != null && (ref_cache = this.line_info_lookup_cache.get(addr)) != null) {
            return ref_cache;
        }
        final ILineNumbers ln = (ILineNumbers)this.launch.getService(ILineNumbers.class);
        if (ln == null) {
            return null;
        }
        final BigInteger n0 = addr;
        final BigInteger n1 = n0.add(BigInteger.valueOf(1L));
        if (this.line_info_lookup_cache == null) {
            this.line_info_lookup_cache = new LinkedHashMap(11, 0.75f, true);
            if (this.lookup_cache_timer == null) {
                this.lookup_cache_timer = new LookupCacheTimer();
            }
        }
        ref_cache = new TCFNode.TCFData<TCFSourceRef>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.memory_node.validate((Runnable)((Object)this))) {
                    return false;
                }
                IMemory.MemoryContext mem_data = null;
                TCFNodeExecContext mem = (TCFNodeExecContext)TCFNodeExecContext.this.memory_node.getData();
                if (mem != null) {
                    TCFNode.TCFData mem_cache = mem.mem_context;
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    mem_data = (IMemory.MemoryContext)mem_cache.getData();
                }
                final TCFSourceRef ref_data = new TCFSourceRef();
                if (mem_data != null) {
                    ref_data.context_id = mem_data.getID();
                    ref_data.address_size = mem_data.getAddressSize();
                }
                this.command = ln.mapToSource(TCFNodeExecContext.this.id, (Number)n0, (Number)n1, new ILineNumbers.DoneMapToSource(){

                    public void doneMapToSource(IToken token, Exception error, ILineNumbers.CodeArea[] areas) {
                        ref_data.address = addr;
                        if (error == null && areas != null && areas.length > 0) {
                            ILineNumbers.CodeArea[] codeAreaArray = areas;
                            int n = areas.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ILineNumbers.CodeArea area = codeAreaArray[n2];
                                BigInteger a0 = JSON.toBigInteger((Number)area.start_address);
                                BigInteger a1 = JSON.toBigInteger((Number)area.end_address);
                                if (n0.compareTo(a0) >= 0 && n0.compareTo(a1) < 0 && (ref_data.area == null || area.start_line < ref_data.area.start_line)) {
                                    if (area.start_address != a0 || area.end_address != a1) {
                                        area = new ILineNumbers.CodeArea(area.directory, area.file, area.start_line, area.start_column, area.end_line, area.end_column, (Number)a0, (Number)a1, area.isa, area.is_statement, area.basic_block, area.prologue_end, area.epilogue_begin);
                                    }
                                    ref_data.area = area;
                                }
                                ++n2;
                            }
                        }
                        ref_data.error = error;
                        this.set(token, null, ref_data);
                    }
                });
                return false;
            }
        };
        this.line_info_lookup_cache.put(addr, (TCFDataCache<TCFSourceRef>)ref_cache);
        return ref_cache;
    }

    public TCFDataCache<TCFFunctionRef> getFuncInfo(final BigInteger addr) {
        TCFNode.TCFData<TCFFunctionRef> ref_cache;
        if (this.isDisposed()) {
            return null;
        }
        if (this.func_info_lookup_cache != null && (ref_cache = this.func_info_lookup_cache.get(addr)) != null) {
            return ref_cache;
        }
        final ISymbols syms = (ISymbols)this.launch.getService(ISymbols.class);
        if (syms == null) {
            return null;
        }
        if (this.func_info_lookup_cache == null) {
            this.func_info_lookup_cache = new LinkedHashMap(11, 0.75f, true);
            if (this.lookup_cache_timer == null) {
                this.lookup_cache_timer = new LookupCacheTimer();
            }
        }
        ref_cache = new TCFNode.TCFData<TCFFunctionRef>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeExecContext.this.memory_node.validate((Runnable)((Object)this))) {
                    return false;
                }
                IMemory.MemoryContext mem_data = null;
                TCFNodeExecContext mem = (TCFNodeExecContext)TCFNodeExecContext.this.memory_node.getData();
                if (mem != null) {
                    TCFNode.TCFData mem_cache = mem.mem_context;
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    mem_data = (IMemory.MemoryContext)mem_cache.getData();
                }
                final TCFFunctionRef ref_data = new TCFFunctionRef();
                if (mem_data != null) {
                    ref_data.context_id = mem_data.getID();
                    ref_data.address_size = mem_data.getAddressSize();
                }
                ref_data.address = addr;
                this.command = syms.findByAddr(TCFNodeExecContext.this.id, (Number)addr, new ISymbols.DoneFind(){

                    public void doneFind(IToken token, Exception error, String symbol_id) {
                        ref_data.error = error;
                        ref_data.symbol_id = symbol_id;
                        this.set(token, null, ref_data);
                    }
                });
                return false;
            }
        };
        this.func_info_lookup_cache.put(addr, (TCFDataCache<TCFFunctionRef>)ref_cache);
        return ref_cache;
    }

    private void clearLookupCaches() {
        TCFDataCache<TCFSymFileRef> cache;
        Iterator<TCFDataCache<TCFSymFileRef>> i;
        if (this.syms_info_lookup_cache != null) {
            i = this.syms_info_lookup_cache.values().iterator();
            while (i.hasNext()) {
                cache = i.next();
                if (cache.isPending()) continue;
                cache.dispose();
                i.remove();
            }
            if (this.syms_info_lookup_cache.size() == 0) {
                this.syms_info_lookup_cache = null;
            }
        }
        if (this.line_info_lookup_cache != null) {
            i = this.line_info_lookup_cache.values().iterator();
            while (i.hasNext()) {
                cache = i.next();
                if (cache.isPending()) continue;
                cache.dispose();
                i.remove();
            }
            if (this.line_info_lookup_cache.size() == 0) {
                this.line_info_lookup_cache = null;
            }
        }
        if (this.func_info_lookup_cache != null) {
            i = this.func_info_lookup_cache.values().iterator();
            while (i.hasNext()) {
                cache = i.next();
                if (cache.isPending()) continue;
                cache.dispose();
                i.remove();
            }
            if (this.func_info_lookup_cache.size() == 0) {
                this.func_info_lookup_cache = null;
            }
        }
    }

    private void updateTerminal() {
        new Runnable(){

            @Override
            public void run() {
                Map uart;
                if (TCFNodeExecContext.this.isDisposed()) {
                    return;
                }
                if (!TCFNodeExecContext.this.run_context.validate(this)) {
                    return;
                }
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)TCFNodeExecContext.this.run_context.getData();
                if (ctx != null && (uart = (Map)ctx.getProperties().get("UART")) != null) {
                    TCFNodeExecContext.this.launch.openUartStreams(TCFNodeExecContext.this.id, uart);
                }
            }
        }.run();
    }

    @Override
    public TCFNode getParent(IPresentationContext ctx) {
        Set ids;
        assert (Protocol.isDispatchThread());
        if ("org.eclipse.debug.ui.DebugView".equals(ctx.getId()) && (ids = this.launch.getContextFilter()) != null) {
            if (ids.contains(this.id)) {
                return this.model.getRootNode();
            }
            if (this.parent instanceof TCFNodeLaunch) {
                return null;
            }
        }
        return this.parent;
    }

    @Override
    public TCFDataCache<IRunControl.RunControlContext> getRunContext() {
        return this.run_context;
    }

    public TCFDataCache<IProcesses.ProcessContext> getProcessContext() {
        return this.prs_context;
    }

    @Override
    public TCFDataCache<IMemory.MemoryContext> getMemoryContext() {
        return this.mem_context;
    }

    public TCFDataCache<BigInteger> getAddress() {
        return this.address;
    }

    public TCFDataCache<TCFContextState> getState() {
        return this.state;
    }

    @Override
    public TCFChildrenStackTrace getStackTrace() {
        return this.children_stack;
    }

    @Override
    public TCFChildren getRegisters() {
        return this.children_regs;
    }

    public TCFChildren getModules() {
        return this.children_modules;
    }

    @Override
    public TCFChildren getChildren() {
        return this.children_exec;
    }

    public TCFNodeStackFrame getLastTopFrame() {
        if (!this.resume_pending) {
            return null;
        }
        if (this.last_stack_trace == null || this.last_stack_trace.length == 0) {
            return null;
        }
        return (TCFNodeStackFrame)this.last_stack_trace[0];
    }

    public TCFNodeStackFrame getViewBottomFrame() {
        if (this.last_stack_trace == null || this.last_stack_trace.length == 0) {
            return null;
        }
        return (TCFNodeStackFrame)this.last_stack_trace[this.last_stack_trace.length - 1];
    }

    public TCFDataCache<String> getFullName() {
        return this.full_name;
    }

    @Override
    public void addSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == null);
        this.symbols.put(s.id, s);
    }

    @Override
    public void removeSymbol(TCFNodeSymbol s) {
        assert (this.symbols.get(s.id) == s);
        this.symbols.remove(s.id);
    }

    public boolean isNotActive() {
        TCFContextState state_data = (TCFContextState)this.state.getData();
        if (state_data != null) {
            return state_data.isNotActive();
        }
        return false;
    }

    private boolean okToShowLastStack() {
        return this.resume_pending && this.last_stack_trace != null;
    }

    private boolean okToHideStack() {
        TCFContextState state_data = (TCFContextState)this.state.getData();
        if (state_data == null) {
            return true;
        }
        if (!state_data.is_suspended) {
            return true;
        }
        return state_data.isNotActive();
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        TCFChildren children = null;
        String view_id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                if (this.okToShowLastStack()) {
                    result.setChildCount(this.last_stack_trace.length);
                    return true;
                }
                if (!this.state.validate(done)) {
                    return false;
                }
                if (this.okToHideStack()) {
                    this.last_stack_trace = empty_node_array;
                    result.setChildCount(0);
                    return true;
                }
                children = this.children_stack;
            } else {
                if (!this.model.getAutoChildrenListUpdates() && this.last_children_list != null) {
                    result.setChildCount(this.last_children_list.length);
                    return true;
                }
                children = this.children_exec;
            }
        } else if ("org.eclipse.debug.ui.RegisterView".equals(view_id)) {
            children = this.children_regs;
        } else if ("org.eclipse.debug.ui.ExpressionView".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null) {
                children = this.children_exps;
            }
        } else if ("org.eclipse.tcf.debug.ui.expression_hover".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_hover_exps;
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(view_id)) {
            if (!this.mem_context.validate(done)) {
                return false;
            }
            IMemory.MemoryContext ctx = (IMemory.MemoryContext)this.mem_context.getData();
            if (ctx != null) {
                children = this.children_modules;
            }
        } else if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
            if (!this.children_query.setQuery((IViewerUpdate)result, done)) {
                return false;
            }
            children = this.children_query;
        }
        if (children != null) {
            if (!children.validate(done)) {
                return false;
            }
            if (children == this.children_stack) {
                this.last_stack_trace = this.children_stack.toArray();
            }
            if (children == this.children_exec) {
                this.last_children_list = this.children_exec.toArray();
            }
            result.setChildCount(children.size());
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    private void setResultChildren(IChildrenUpdate result, TCFNode[] arr) {
        int offset = 0;
        int r_offset = result.getOffset();
        int r_length = result.getLength();
        TCFNode[] tCFNodeArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            TCFNode n3 = tCFNodeArray[n2];
            if (offset >= r_offset && offset < r_offset + r_length) {
                result.setChild((Object)n3, offset);
            }
            ++offset;
            ++n2;
        }
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        TCFChildren children = null;
        String view_id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                if (this.okToShowLastStack()) {
                    this.setResultChildren(result, this.last_stack_trace);
                    return true;
                }
                if (!this.state.validate(done)) {
                    return false;
                }
                if (this.okToHideStack()) {
                    this.last_stack_trace = empty_node_array;
                    return true;
                }
                if (!this.children_regs.validate(done)) {
                    return false;
                }
                children = this.children_stack;
            } else {
                if (!this.model.getAutoChildrenListUpdates() && this.last_children_list != null) {
                    this.setResultChildren(result, this.last_children_list);
                    return true;
                }
                children = this.children_exec;
            }
        } else if ("org.eclipse.debug.ui.RegisterView".equals(view_id)) {
            children = this.children_regs;
        } else if ("org.eclipse.debug.ui.ExpressionView".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null) {
                children = this.children_exps;
            }
        } else if ("org.eclipse.tcf.debug.ui.expression_hover".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_hover_exps;
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(view_id)) {
            if (!this.mem_context.validate(done)) {
                return false;
            }
            IMemory.MemoryContext ctx = (IMemory.MemoryContext)this.mem_context.getData();
            if (ctx != null) {
                children = this.children_modules;
            }
        } else if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
            if (!this.children_query.setQuery((IViewerUpdate)result, done)) {
                return false;
            }
            children = this.children_query;
        }
        if (children == null) {
            return true;
        }
        if (children == this.children_stack) {
            if (!children.validate(done)) {
                return false;
            }
            this.last_stack_trace = this.children_stack.toArray();
        }
        if (children == this.children_exec) {
            if (!children.validate(done)) {
                return false;
            }
            this.last_children_list = this.children_exec.toArray();
        }
        return children.getData(result, done);
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        TCFChildren children = null;
        String view_id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                if (this.okToShowLastStack()) {
                    result.setHasChilren(this.last_stack_trace.length > 0);
                    return true;
                }
                if (!this.state.validate(done)) {
                    return false;
                }
                if (this.okToHideStack()) {
                    this.last_stack_trace = empty_node_array;
                    result.setHasChilren(false);
                    return true;
                }
                Boolean has_children = this.children_stack.checkHasChildren(done);
                if (has_children == null) {
                    return false;
                }
                result.setHasChilren(has_children.booleanValue());
                return true;
            }
            if (!this.model.getAutoChildrenListUpdates() && this.last_children_list != null) {
                result.setHasChilren(this.last_children_list.length > 0);
                return true;
            }
            children = this.children_exec;
        } else if ("org.eclipse.debug.ui.RegisterView".equals(view_id)) {
            children = this.children_regs;
        } else if ("org.eclipse.debug.ui.ExpressionView".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null) {
                children = this.children_exps;
            }
        } else if ("org.eclipse.tcf.debug.ui.expression_hover".equals(view_id)) {
            if (!this.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)this.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                children = this.children_hover_exps;
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(view_id)) {
            if (!this.mem_context.validate(done)) {
                return false;
            }
            IMemory.MemoryContext ctx = (IMemory.MemoryContext)this.mem_context.getData();
            if (ctx != null) {
                children = this.children_modules;
            }
        } else if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
            if (!this.children_query.setQuery((IViewerUpdate)result, done)) {
                return false;
            }
            children = this.children_query;
        }
        if (children != null) {
            if (!children.validate(done)) {
                return false;
            }
            if (children == this.children_stack) {
                this.last_stack_trace = this.children_stack.toArray();
            }
            if (children == this.children_exec) {
                this.last_children_list = this.children_exec.toArray();
            }
            result.setHasChilren(children.size() > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    private String addStateName(StringBuffer label, TCFContextState state_data) {
        String name;
        String image_name = "icons/thread_not_active";
        assert (!state_data.is_suspended);
        if (state_data.suspend_params != null && (name = (String)state_data.suspend_params.get("StateName")) != null) {
            label.append(" (");
            label.append(name);
            label.append(")");
            return image_name;
        }
        if (state_data.isReversing()) {
            image_name = "icons/thread_reversing";
            label.append(" (Reversing)");
        } else {
            image_name = "icons/full/obj16/thread_obj";
            label.append(" (Running)");
        }
        return image_name;
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        if (!this.run_context.validate(done)) {
            return false;
        }
        String image_name = null;
        boolean suspended_by_bp = false;
        ChildrenStateInfo children_state_info = null;
        StringBuffer label = new StringBuffer();
        Throwable error = this.run_context.getError();
        if (error != null) {
            result.setForeground(ColorCache.rgb_error, 0);
            label.append(this.id);
            label.append(": ");
            label.append(TCFModel.getErrorMessage(error, false));
        } else {
            IRunControl.RunControlContext ctx;
            String view_id = result.getPresentationContext().getId();
            if ("org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
                TCFChildrenContextQuery.Descendants des = TCFChildrenContextQuery.getDescendants(this, (IViewerUpdate)result, done);
                if (des == null) {
                    return false;
                }
                if (des.map != null && des.map.size() > 0) {
                    label.append("(");
                    label.append(des.map.size());
                    label.append(") ");
                }
                if (!des.include_parent) {
                    result.setForeground(ColorCache.rgb_disabled, 0);
                }
            }
            if ((ctx = (IRunControl.RunControlContext)this.run_context.getData()) == null) {
                label.append(this.id);
            } else {
                String prs;
                String nm = ctx.getName();
                if (nm == null && !ctx.hasState() && (prs = ctx.getProcessID()) != null) {
                    if (!this.prs_context.validate(done)) {
                        return false;
                    }
                    IProcesses.ProcessContext pctx = (IProcesses.ProcessContext)this.prs_context.getData();
                    if (pctx != null) {
                        nm = pctx.getName();
                    }
                }
                label.append(nm != null ? nm : this.id);
                Object info = ctx.getProperties().get("AdditionalInfo");
                if (info != null) {
                    label.append(info.toString());
                }
                if ("org.eclipse.tcf.debug.ui.pinned_view".equals(view_id) || "org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) {
                    image_name = ctx.hasState() ? "icons/thread_not_active" : "icons/full/obj16/debugt_obj";
                } else if (ctx.hasState()) {
                    TCFContextState state_data;
                    if (this.resume_pending && this.resumed_by_action || this.model.getActiveAction(this.id) != null) {
                        if (!this.state.validate(done)) {
                            return false;
                        }
                        state_data = (TCFContextState)this.state.getData();
                        image_name = "icons/thread_not_active";
                        if (state_data != null) {
                            if (!state_data.is_suspended) {
                                image_name = this.addStateName(label, state_data);
                            } else {
                                suspended_by_bp = "Breakpoint".equals(state_data.suspend_reason);
                            }
                        }
                        if (this.resume_pending && this.last_label != null) {
                            result.setImageDescriptor(ImageCache.getImageDescriptor(image_name), 0);
                            result.setLabel(this.last_label, 0);
                            return true;
                        }
                    } else {
                        if (this.resume_pending && this.last_label != null && this.last_image != null) {
                            result.setImageDescriptor(this.last_image, 0);
                            result.setLabel(this.last_label, 0);
                            return true;
                        }
                        if (!this.state.validate(done)) {
                            return false;
                        }
                        state_data = (TCFContextState)this.state.getData();
                        if (this.isNotActive()) {
                            image_name = "icons/thread_not_active";
                            label.append(" (Not active)");
                            if (state_data.suspend_reason != null && !state_data.suspend_reason.equals("Suspended")) {
                                label.append(" - ");
                                label.append(state_data.suspend_reason);
                            }
                        } else {
                            image_name = "icons/thread_not_active";
                            if (state_data != null) {
                                if (!state_data.is_suspended) {
                                    image_name = this.addStateName(label, state_data);
                                } else {
                                    image_name = "icons/full/obj16/threads_obj";
                                    String sig_name = null;
                                    String bp_names = null;
                                    String suspend_reason = this.model.getContextActionResult(this.id);
                                    if (suspend_reason == null) {
                                        suspend_reason = state_data.suspend_reason;
                                    }
                                    if (state_data.suspend_params != null) {
                                        Object ids;
                                        sig_name = (String)state_data.suspend_params.get("SignalDescription");
                                        if (sig_name == null) {
                                            sig_name = (String)state_data.suspend_params.get("SignalName");
                                        }
                                        if ((ids = state_data.suspend_params.get("BPs")) != null) {
                                            Collection bp_ids = (Collection)ids;
                                            TCFBreakpointsModel bp_model = TCFBreakpointsModel.getBreakpointsModel();
                                            for (String bp_id : bp_ids) {
                                                IBreakpoint bp = bp_model.getBreakpoint(bp_id);
                                                if (bp == null) continue;
                                                String bp_name = null;
                                                IMarker m = bp.getMarker();
                                                if (m != null) {
                                                    bp_name = m.getAttribute("org.eclipse.cdt.debug.core.address", null);
                                                    if (bp_name == null) {
                                                        bp_name = m.getAttribute("org.eclipse.cdt.debug.core.function", null);
                                                    }
                                                    if (bp_name == null) {
                                                        bp_name = m.getAttribute("org.eclipse.cdt.debug.core.expression", null);
                                                    }
                                                    if (bp_name == null) {
                                                        String file = m.getAttribute("requestedSourceHandle", null);
                                                        int line = m.getAttribute("requestedLine", 0);
                                                        if (file == null) {
                                                            file = m.getAttribute("org.eclipse.cdt.debug.core.sourceHandle", null);
                                                        }
                                                        if (line == 0) {
                                                            line = m.getAttribute("lineNumber", 0);
                                                        }
                                                        if (file != null && line > 0) {
                                                            bp_name = String.valueOf(new Path(file).lastSegment()) + ":" + line;
                                                        }
                                                    }
                                                }
                                                if (bp_name == null) {
                                                    bp_name = bp_id;
                                                }
                                                bp_names = bp_names == null ? bp_name : String.valueOf(bp_names) + ", " + bp_name;
                                            }
                                        }
                                    }
                                    if (suspend_reason == null) {
                                        suspend_reason = "Suspended";
                                    }
                                    suspended_by_bp = "Breakpoint".equals(suspend_reason) || bp_names != null;
                                    label.append(" (");
                                    label.append(suspend_reason);
                                    if ("Signal".equals(suspend_reason) && sig_name != null) {
                                        label.append(": ");
                                        label.append(sig_name);
                                        sig_name = null;
                                    }
                                    if ("Breakpoint".equals(suspend_reason) && bp_names != null) {
                                        label.append(": ");
                                        label.append(bp_names);
                                        bp_names = null;
                                    }
                                    if (sig_name != null) {
                                        label.append("; ");
                                        label.append("Signal");
                                        label.append(": ");
                                        label.append(sig_name);
                                    }
                                    if (bp_names != null) {
                                        label.append("; ");
                                        label.append("Breakpoint");
                                        label.append(": ");
                                        label.append(bp_names);
                                    }
                                    label.append(")");
                                    if (state_data.suspend_params != null) {
                                        String cpu;
                                        String prs2 = (String)state_data.suspend_params.get("Context");
                                        if (prs2 != null) {
                                            label.append(", ");
                                            label.append(prs2);
                                        }
                                        if ((cpu = (String)state_data.suspend_params.get("CPU")) != null) {
                                            label.append(", ");
                                            label.append(cpu);
                                        }
                                    }
                                }
                            }
                        }
                    }
                } else {
                    children_state_info = new ChildrenStateInfo();
                    if (!this.hasSuspendedChildren(children_state_info, done)) {
                        return false;
                    }
                    image_name = children_state_info.suspended ? "icons/full/obj16/debugts_obj" : "icons/full/obj16/debugt_obj";
                    suspended_by_bp = children_state_info.breakpoint;
                }
            }
        }
        this.last_children_state_info = children_state_info;
        this.last_image = ImageCache.getImageDescriptor(image_name);
        if (suspended_by_bp) {
            this.last_image = ImageCache.addOverlay(this.last_image, "icons/brkp_ovr");
        }
        result.setImageDescriptor(this.last_image, 0);
        this.last_label = label.toString();
        result.setLabel(this.last_label, 0);
        return true;
    }

    @Override
    protected boolean getData(IViewerInputUpdate result, Runnable done) {
        result.setInputElement((Object)this);
        String view_id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.VariableView".equals(view_id)) {
            if (!this.children_stack.validate(done)) {
                return false;
            }
            TCFNodeStackFrame frame = this.children_stack.getTopFrame();
            if (frame != null) {
                result.setInputElement((Object)frame);
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(view_id)) {
            TCFDataCache<TCFNodeExecContext> mem = this.model.searchMemoryContext(this);
            if (mem == null) {
                return true;
            }
            if (!mem.validate(done)) {
                return false;
            }
            if (mem.getData() == null) {
                return true;
            }
            result.setInputElement(mem.getData());
        }
        return true;
    }

    @Override
    public void refresh(IWorkbenchPart part) {
        if (part instanceof IMemoryRenderingSite) {
            this.model.onMemoryChanged(this.id, false, false, false);
        } else {
            this.last_children_list = null;
            this.last_children_state_info = null;
            this.last_stack_trace = null;
            this.last_label = null;
            this.last_image = null;
            super.refresh(part);
        }
    }

    void postAllChangedDelta() {
        this.postContentChangedDelta();
        this.postStateChangedDelta();
    }

    void postContextAddedDelta() {
        if (this.parent instanceof TCFNodeExecContext) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            ChildrenStateInfo info = exe.last_children_state_info;
            if (info != null) {
                if (!this.model.getAutoChildrenListUpdates()) {
                    return;
                }
                if (!info.suspended && !info.not_active && this.model.getDelayChildrenListUpdates()) {
                    exe.delayed_children_list_delta = true;
                    return;
                }
            }
        }
        for (TCFModelProxy p : this.model.getModelProxies()) {
            String view_id = p.getPresentationContext().getId();
            if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
                p.addDelta(this, 16);
                continue;
            }
            if (!"org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) continue;
            p.addDelta(this.parent, 1024);
        }
    }

    private void postContextRemovedDelta() {
        if (this.parent instanceof TCFNodeExecContext) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            ChildrenStateInfo info = exe.last_children_state_info;
            if (info != null) {
                if (!this.model.getAutoChildrenListUpdates()) {
                    return;
                }
                if (!info.suspended && !info.not_active && this.model.getDelayChildrenListUpdates()) {
                    exe.delayed_children_list_delta = true;
                    return;
                }
            }
        }
        for (TCFModelProxy p : this.model.getModelProxies()) {
            String view_id = p.getPresentationContext().getId();
            if ("org.eclipse.debug.ui.DebugView".equals(view_id)) {
                p.addDelta(this, 2);
                continue;
            }
            if (!"org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id)) continue;
            p.addDelta(this.parent, 1024);
        }
        TCFNode n = this.parent;
        while (n instanceof TCFNodeExecContext) {
            TCFNodeExecContext e = (TCFNodeExecContext)n;
            ChildrenStateInfo info = e.last_children_state_info;
            if (info != null && info.suspended) {
                e.postStateChangedDelta();
            }
            n = n.parent;
        }
    }

    private void postContentChangedDelta() {
        this.delayed_children_list_delta = false;
        for (TCFModelProxy p : this.model.getModelProxies()) {
            int flags = 0;
            String view_id = p.getPresentationContext().getId();
            if (!(!"org.eclipse.debug.ui.DebugView".equals(view_id) && !"org.eclipse.tcf.debug.ui.ContextQueryView".equals(view_id) || this.launch.getContextActionsCount(this.id) != 0 && this.model.getDelayStackUpdateUtilLastStep())) {
                flags |= 0x400;
            }
            if (("org.eclipse.debug.ui.RegisterView".equals(view_id) || "org.eclipse.debug.ui.ExpressionView".equals(view_id) || "org.eclipse.tcf.debug.ui.expression_hover".equals(view_id)) && p.getInput() == this) {
                flags |= 0x400;
            }
            if (flags == 0) continue;
            p.addDelta(this, flags);
        }
    }

    private void postAllAndParentsChangedDelta() {
        this.postContentChangedDelta();
        TCFNode n = this;
        while (n instanceof TCFNodeExecContext) {
            TCFNodeExecContext e = n;
            if (e.delayed_children_list_delta) {
                e.postContentChangedDelta();
            }
            e.postStateChangedDelta();
            n = n.parent;
        }
    }

    public void postStateChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.DebugView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 2048);
        }
    }

    private void postModulesChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.ModuleView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 1024);
        }
    }

    private void postStackChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            if (!"org.eclipse.debug.ui.DebugView".equals(p.getPresentationContext().getId())) continue;
            p.addDelta(this, 1024);
        }
    }

    void onContextAdded(IRunControl.RunControlContext context) {
        this.model.setDebugViewSelection(this, "Added");
        this.children_exec.onContextAdded(context);
    }

    void onContextChanged(IRunControl.RunControlContext context) {
        TCFContextState tCFContextState;
        assert (!this.isDisposed());
        this.full_name.reset();
        this.run_context.reset(context);
        this.symbols_node.reset();
        this.memory_node.reset();
        this.signal_mask.reset();
        if (this.state.isValid() && ((tCFContextState = (TCFContextState)this.state.getData()) == null || tCFContextState.is_suspended)) {
            this.state.reset();
        }
        this.children_stack.reset();
        this.children_stack.onSourceMappingChange();
        this.children_regs.reset();
        this.children_exec.onAncestorContextChanged();
        for (TCFNodeSymbol tCFNodeSymbol : this.symbols.values()) {
            tCFNodeSymbol.onMemoryMapChanged();
        }
        this.postAllChangedDelta();
        this.updateTerminal();
    }

    void onAncestorContextChanged() {
        this.full_name.reset();
    }

    void onContextAdded(IMemory.MemoryContext context) {
        this.children_exec.onContextAdded(context);
    }

    void onContextChanged(IMemory.MemoryContext context) {
        assert (!this.isDisposed());
        this.clearLookupCaches();
        this.mem_context.reset(context);
        for (TCFNodeSymbol s : this.symbols.values()) {
            s.onMemoryMapChanged();
        }
        this.postAllChangedDelta();
    }

    void onContextRemoved() {
        assert (!this.isDisposed());
        ++this.resumed_cnt;
        this.resume_pending = false;
        this.resumed_by_action = false;
        this.dispose();
        this.postContextRemovedDelta();
        this.launch.removeContextActions(this.id);
    }

    void onExpressionAddedOrRemoved() {
        this.children_exps.cancel();
        this.children_stack.onExpressionAddedOrRemoved();
    }

    void onContainerSuspended(boolean func_call) {
        IRunControl.RunControlContext ctx;
        assert (!this.isDisposed());
        if (this.run_context.isValid() && (ctx = (IRunControl.RunControlContext)this.run_context.getData()) != null && !ctx.hasState()) {
            return;
        }
        this.onContextSuspended(null, null, null, func_call);
    }

    void onContainerResumed() {
        IRunControl.RunControlContext ctx;
        assert (!this.isDisposed());
        if (this.run_context.isValid() && (ctx = (IRunControl.RunControlContext)this.run_context.getData()) != null && !ctx.hasState()) {
            return;
        }
        this.onContextResumed();
    }

    void onContextSuspended(String pc, String reason, Map<String, Object> params, boolean func_call) {
        assert (!this.isDisposed());
        if (pc != null) {
            TCFContextState tCFContextState = new TCFContextState();
            tCFContextState.is_suspended = true;
            tCFContextState.suspend_pc = pc;
            tCFContextState.suspend_reason = reason;
            tCFContextState.suspend_params = params;
            this.state.reset(tCFContextState);
        } else {
            this.state.reset();
        }
        this.address.reset();
        this.signal_mask.reset();
        this.children_stack.onSuspended(func_call);
        this.children_exps.onSuspended(func_call);
        this.children_hover_exps.onSuspended(func_call);
        this.children_regs.onSuspended(func_call);
        if (!func_call) {
            this.children_log_exps.onSuspended();
        }
        for (TCFNodeSymbol tCFNodeSymbol : this.symbols.values()) {
            tCFNodeSymbol.onExeStateChange();
        }
        if (this.model.getActiveAction(this.id) == null) {
            boolean bl = pc != null || this.resumed_by_action;
            ++this.resumed_cnt;
            this.resume_pending = false;
            this.resumed_by_action = false;
            if (bl) {
                this.children_stack.postAllChangedDelta();
                this.postAllAndParentsChangedDelta();
            } else {
                final int cnt = this.resumed_cnt;
                Protocol.invokeLater((long)500L, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (cnt != TCFNodeExecContext.this.resumed_cnt) {
                            return;
                        }
                        if (TCFNodeExecContext.this.isDisposed()) {
                            return;
                        }
                        TCFNodeExecContext.this.children_stack.postAllChangedDelta();
                        TCFNodeExecContext.this.postAllAndParentsChangedDelta();
                    }
                });
            }
        }
    }

    void onContextResumed() {
        assert (!this.isDisposed());
        this.state.reset();
        if (!this.resume_pending) {
            final int cnt = ++this.resumed_cnt;
            this.resume_pending = true;
            boolean bl = this.resumed_by_action = this.model.getActiveAction(this.id) != null;
            if (this.resumed_by_action) {
                this.postAllChangedDelta();
            }
            Protocol.invokeLater((long)400L, (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (cnt != TCFNodeExecContext.this.resumed_cnt) {
                        return;
                    }
                    if (TCFNodeExecContext.this.isDisposed()) {
                        return;
                    }
                    TCFNodeExecContext.this.resume_pending = false;
                    TCFNodeExecContext.this.postAllAndParentsChangedDelta();
                    TCFNodeExecContext.this.model.onContextRunning();
                }
            });
        }
    }

    void onContextStateChanged() {
        assert (!this.isDisposed());
        this.state.reset();
        this.postStateChangedDelta();
    }

    void onContextActionDone() {
        assert (this.state.isValid());
        if (this.state.getData() == null || ((TCFContextState)this.state.getData()).is_suspended) {
            ++this.resumed_cnt;
            this.resume_pending = false;
            this.resumed_by_action = false;
        }
        this.postAllChangedDelta();
        this.children_stack.postAllChangedDelta();
    }

    void onContextException(String msg) {
    }

    void onMemoryChanged(Number[] addr, long[] size) {
        assert (!this.isDisposed());
        this.children_stack.onMemoryChanged();
        this.children_exps.onMemoryChanged();
        this.children_hover_exps.onMemoryChanged();
        this.children_log_exps.onMemoryChanged();
        this.postContentChangedDelta();
    }

    void onMemoryMapChanged() {
        this.clearLookupCaches();
        this.memory_map.reset();
        this.children_modules.onMemoryMapChanged();
        this.children_stack.onMemoryMapChanged();
        this.children_exps.onMemoryMapChanged();
        this.children_hover_exps.onMemoryMapChanged();
        this.children_log_exps.onMemoryMapChanged();
        this.postContentChangedDelta();
        this.postModulesChangedDelta();
    }

    void onRegistersChanged() {
        this.children_stack.onRegistersChanged();
        this.postContentChangedDelta();
    }

    void onRegisterValueChanged() {
        TCFContextState s;
        if (this.state.isValid() && ((s = (TCFContextState)this.state.getData()) == null || s.is_suspended)) {
            this.state.reset();
        }
        this.address.reset();
        this.children_stack.onRegisterValueChanged();
        this.children_exps.onRegisterValueChanged();
        this.children_hover_exps.onRegisterValueChanged();
        this.children_log_exps.onRegisterValueChanged();
        this.postContentChangedDelta();
    }

    void onPreferencesChanged() {
        if (this.delayed_children_list_delta && !this.model.getDelayChildrenListUpdates() || this.model.getAutoChildrenListUpdates()) {
            this.postContentChangedDelta();
        }
        this.children_stack.onPreferencesChanged();
        this.postStackChangedDelta();
    }

    void riseTraceLimit() {
        this.children_stack.riseTraceLimit();
        this.postStackChangedDelta();
    }

    boolean appendPointedObject(StyledStringBuffer bf, BigInteger addr, Runnable done) {
        TCFDataCache<TCFNodeExecContext> mem_node_cache = this.model.searchMemoryContext(this);
        if (mem_node_cache == null) {
            return true;
        }
        if (!mem_node_cache.validate(done)) {
            return false;
        }
        if (mem_node_cache.getData() == null) {
            return true;
        }
        TCFDataCache<TCFFunctionRef> func_info_cache = ((TCFNodeExecContext)mem_node_cache.getData()).getFuncInfo(addr);
        if (func_info_cache == null) {
            return true;
        }
        if (!func_info_cache.validate(done)) {
            return false;
        }
        TCFFunctionRef func_ref = (TCFFunctionRef)func_info_cache.getData();
        if (func_ref != null && func_ref.symbol_id != null) {
            TCFDataCache<ISymbols.Symbol> sym_cache = this.model.getSymbolInfoCache(func_ref.symbol_id);
            if (!sym_cache.validate(done)) {
                return false;
            }
            ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
            if (sym_data != null && sym_data.getName() != null) {
                BigInteger func_addr;
                bf.append(", ");
                bf.append("At: ", 1);
                bf.append(sym_data.getName());
                if (sym_data.getSymbolClass() == ISymbols.SymbolClass.function) {
                    bf.append("()");
                }
                if ((func_addr = JSON.toBigInteger((Number)sym_data.getAddress())) != null) {
                    BigInteger addr_offs = addr.subtract(func_addr);
                    int cmp = addr_offs.compareTo(BigInteger.ZERO);
                    if (cmp > 0) {
                        bf.append(" + 0x" + addr_offs.toString(16));
                    } else if (cmp < 0) {
                        bf.append(" - 0x" + addr_offs.abs().toString(16));
                    }
                }
            }
        }
        return true;
    }

    public boolean hasSuspendedChildren(ChildrenStateInfo info, Runnable done) {
        if (!this.children_exec.validate(done)) {
            return false;
        }
        Map m = (Map)this.children_exec.getData();
        if (m == null || m.size() == 0) {
            return true;
        }
        for (TCFNode n : m.values()) {
            if (!(n instanceof TCFNodeExecContext)) continue;
            TCFNodeExecContext e = (TCFNodeExecContext)n;
            if (!e.run_context.validate(done)) {
                return false;
            }
            IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)e.run_context.getData();
            if (ctx != null && ctx.hasState()) {
                TCFDataCache<TCFContextState> state_cache = e.getState();
                if (!state_cache.validate(done)) {
                    return false;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data != null) {
                    if (!state_data.is_suspended) {
                        info.running = true;
                    } else if (e.isNotActive()) {
                        info.not_active = true;
                    } else {
                        info.suspended = true;
                        String r = this.model.getContextActionResult(e.id);
                        if (r == null) {
                            r = state_data.suspend_reason;
                        }
                        if ("Breakpoint".equals(r)) {
                            info.breakpoint = true;
                        }
                    }
                }
            } else if (!e.hasSuspendedChildren(info, done)) {
                return false;
            }
            if (info.breakpoint && info.running) break;
        }
        return true;
    }

    @Override
    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeExecContext) {
            TCFNodeExecContext f = (TCFNodeExecContext)n;
            if (this.mem_seq_no < f.mem_seq_no) {
                return -1;
            }
            if (this.mem_seq_no > f.mem_seq_no) {
                return 1;
            }
            if (this.exe_seq_no < f.exe_seq_no) {
                return -1;
            }
            if (this.exe_seq_no > f.exe_seq_no) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }

    public static class ChildrenStateInfo {
        public boolean running;
        public boolean suspended;
        public boolean not_active;
        public boolean breakpoint;
    }

    private class LookupCacheTimer
    implements Runnable {
        LookupCacheTimer() {
            Protocol.invokeLater((long)4000L, (Runnable)this);
        }

        @Override
        public void run() {
            TCFDataCache cache;
            BigInteger addr;
            if (TCFNodeExecContext.this.isDisposed()) {
                return;
            }
            if (TCFNodeExecContext.this.syms_info_lookup_cache != null) {
                addr = (BigInteger)TCFNodeExecContext.this.syms_info_lookup_cache.keySet().iterator().next();
                cache = (TCFDataCache)TCFNodeExecContext.this.syms_info_lookup_cache.get(addr);
                if (!cache.isPending()) {
                    ((TCFDataCache)TCFNodeExecContext.this.syms_info_lookup_cache.remove(addr)).dispose();
                    if (TCFNodeExecContext.this.syms_info_lookup_cache.size() == 0) {
                        TCFNodeExecContext.this.syms_info_lookup_cache = null;
                    }
                }
            }
            if (TCFNodeExecContext.this.line_info_lookup_cache != null) {
                addr = (BigInteger)TCFNodeExecContext.this.line_info_lookup_cache.keySet().iterator().next();
                cache = (TCFDataCache)TCFNodeExecContext.this.line_info_lookup_cache.get(addr);
                if (!cache.isPending()) {
                    ((TCFDataCache)TCFNodeExecContext.this.line_info_lookup_cache.remove(addr)).dispose();
                    if (TCFNodeExecContext.this.line_info_lookup_cache.size() == 0) {
                        TCFNodeExecContext.this.line_info_lookup_cache = null;
                    }
                }
            }
            if (TCFNodeExecContext.this.func_info_lookup_cache != null) {
                addr = (BigInteger)TCFNodeExecContext.this.func_info_lookup_cache.keySet().iterator().next();
                cache = (TCFDataCache)TCFNodeExecContext.this.func_info_lookup_cache.get(addr);
                if (!cache.isPending()) {
                    ((TCFDataCache)TCFNodeExecContext.this.func_info_lookup_cache.remove(addr)).dispose();
                    if (TCFNodeExecContext.this.func_info_lookup_cache.size() == 0) {
                        TCFNodeExecContext.this.func_info_lookup_cache = null;
                    }
                }
            }
            if (TCFNodeExecContext.this.syms_info_lookup_cache == null && TCFNodeExecContext.this.line_info_lookup_cache == null && TCFNodeExecContext.this.func_info_lookup_cache == null) {
                TCFNodeExecContext.this.lookup_cache_timer = null;
            } else {
                Protocol.invokeLater((long)2500L, (Runnable)this);
            }
        }
    }

    public static class MemoryRegion {
        private final BigInteger addr_start;
        private final BigInteger addr_end;
        public final IMemoryMap.MemoryRegion region;

        private MemoryRegion(IMemoryMap.MemoryRegion region) {
            this.region = region;
            Number addr = region.getAddress();
            Number size = region.getSize();
            if (addr == null || size == null) {
                this.addr_start = null;
                this.addr_end = null;
            } else {
                this.addr_start = JSON.toBigInteger((Number)addr);
                this.addr_end = this.addr_start.add(JSON.toBigInteger((Number)size));
            }
        }

        public boolean contains(BigInteger addr) {
            return this.addr_start != null && this.addr_end != null && this.addr_start.compareTo(addr) <= 0 && this.addr_end.compareTo(addr) > 0;
        }

        public String toString() {
            return this.region.getProperties().toString();
        }
    }

    public static class SignalMask {
        protected Map<String, Object> props;
        protected boolean dont_stop;
        protected boolean dont_pass;
        protected boolean pending;

        public Number getIndex() {
            return (Number)this.props.get("Index");
        }

        public Number getCode() {
            return (Number)this.props.get("Code");
        }

        public Map<String, Object> getProperties() {
            return this.props;
        }

        public boolean isDontStop() {
            return this.dont_stop;
        }

        public boolean isDontPass() {
            return this.dont_pass;
        }

        public boolean isPending() {
            return this.pending;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            bf.append("[attrs=");
            bf.append(this.props.toString());
            if (this.dont_stop) {
                bf.append(",don't stop");
            }
            if (this.dont_pass) {
                bf.append(",don't pass");
            }
            if (this.pending) {
                bf.append(",pending");
            }
            bf.append(']');
            return bf.toString();
        }
    }
}

