/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations;

import java.beans.PropertyChangeEvent;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.core.utils.PropertyChangeProvider;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.ui.PlatformUI;

public class FsClipboard
extends PropertyChangeProvider {
    private static final int NONE = -1;
    private static final int CUT = 0;
    private static final int COPY = 1;
    private int operation = -1;
    private List<IFSTreeNode> files;
    private Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());

    public boolean isCutOp() {
        return this.operation == 0;
    }

    public boolean isCopyOp() {
        return this.operation == 1;
    }

    public boolean isEmpty() {
        return this.operation == -1 && (this.files == null || this.files.isEmpty());
    }

    public List<IFSTreeNode> getFiles() {
        return this.files;
    }

    public void cutFiles(List<IFSTreeNode> files) {
        this.operation = 0;
        this.files = files;
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "cut", null, null);
        this.firePropertyChange(event);
        this.clearSystemClipboard();
    }

    public void copyFiles(List<IFSTreeNode> files) {
        this.operation = 1;
        this.files = files;
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "copy", null, null);
        this.firePropertyChange(event);
        this.clearSystemClipboard();
    }

    public void clear() {
        this.operation = -1;
        this.files = null;
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "clear", null, null);
        this.firePropertyChange(event);
        this.clearSystemClipboard();
    }

    void clearSystemClipboard() {
        if (Display.getCurrent() != null) {
            this.clipboard.clearContents();
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    FsClipboard.this.clearSystemClipboard();
                }
            });
        }
    }

    public void dispose() {
        if (Display.getCurrent() != null) {
            if (!this.clipboard.isDisposed()) {
                try {
                    this.clipboard.dispose();
                }
                catch (SWTException sWTException) {}
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    FsClipboard.this.dispose();
                }
            });
        }
    }

    public Clipboard getSystemClipboard() {
        return this.clipboard;
    }
}

