/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.remote.core.Messages;
import org.eclipse.tcf.te.tcf.remote.core.TCFConnection;
import org.eclipse.tcf.te.tcf.remote.core.activator.CoreBundleActivator;

public class TCFConnectionManager
implements IPeerModelListener,
IEventListener {
    public static final TCFConnectionManager INSTANCE = new TCFConnectionManager();
    private final Map<String, TCFConnection> fConnections = Collections.synchronizedMap(new HashMap());
    private IRemoteConnectionType fConnectionType;
    private int fInitialized = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCFConnection mapConnection(IRemoteConnection rc) {
        if (rc == null) {
            return null;
        }
        if (!rc.getConnectionType().getId().equals("org.eclipse.tcf.te.tcf.remote")) {
            return null;
        }
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            String name = rc.getName();
            TCFConnection result = this.fConnections.get(name);
            if (result == null) {
                result = new TCFConnection(rc);
                this.fConnections.put(name, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionType(IRemoteConnectionType connectionType) {
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            this.fConnectionType = connectionType;
            this.initialize();
            this.syncConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            if (this.fInitialized > 0) {
                return;
            }
            this.fInitialized = 1;
            Protocol.invokeLater((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    EventManager.getInstance().addEventListener((IEventListener)TCFConnectionManager.this, ChangeEvent.class);
                    IPeerModel peerModel = ModelManager.getPeerModel();
                    peerModel.addListener((IPeerModelListener)TCFConnectionManager.this);
                    Map map = TCFConnectionManager.this.fConnections;
                    synchronized (map) {
                        IPeerNode[] iPeerNodeArray = peerModel.getPeerNodes();
                        int n = iPeerNodeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPeerNode peerNode = iPeerNodeArray[n2];
                            String name = peerNode.getPeer().getName();
                            TCFConnection connection = (TCFConnection)TCFConnectionManager.this.fConnections.get(name);
                            if (connection == null) {
                                TCFConnectionManager.this.fConnections.put(name, new TCFConnection(peerNode));
                            } else {
                                connection.setPeerNode(peerNode);
                            }
                            ++n2;
                        }
                        TCFConnectionManager.this.fInitialized = 2;
                        TCFConnectionManager.this.syncConnections();
                        TCFConnectionManager.this.fConnections.notifyAll();
                    }
                }
            });
        }
    }

    void syncConnections() {
        if (this.fConnectionType != null && this.fInitialized == 2) {
            for (IRemoteConnection rc : new ArrayList(this.fConnectionType.getConnections())) {
                String name = rc.getName();
                TCFConnection connection = this.fConnections.get(name);
                if (connection != null && connection.getPeerNode() != null) continue;
                try {
                    this.fConnectionType.removeConnection(rc);
                }
                catch (RemoteConnectionException e) {
                    CoreBundleActivator.logError("Cannot remove remote connection.", e);
                }
                this.fConnections.remove(name);
            }
            Iterator<TCFConnection> it = this.fConnections.values().iterator();
            while (it.hasNext()) {
                TCFConnection connection = it.next();
                IPeerNode peerNode = connection.getPeerNode();
                if (peerNode == null) {
                    it.remove();
                    continue;
                }
                this.addRemoteConnection(connection);
            }
        }
    }

    private void addRemoteConnection(TCFConnection connection) {
        if (this.fConnectionType == null) {
            return;
        }
        String name = connection.getName();
        if (this.fConnectionType.getConnection(name) == null) {
            try {
                IRemoteConnectionWorkingCopy wc = this.fConnectionType.newConnection(name);
                IRemoteConnection rc = wc.save();
                connection.setRemoteConnection(rc);
            }
            catch (RemoteConnectionException e) {
                CoreBundleActivator.logError("Cannot add remote connection.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialization(IProgressMonitor monitor) {
        Map<String, TCFConnection> map = this.fConnections;
        synchronized (map) {
            if (this.fInitialized == 2) {
                return;
            }
            if (this.fInitialized == 0) {
                this.initialize();
            }
            while (this.fInitialized != 2) {
                if (monitor.isCanceled()) {
                    return;
                }
                try {
                    this.fConnections.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
        String name = peerNode.getPeer().getName();
        if (added) {
            Map<String, TCFConnection> map = this.fConnections;
            synchronized (map) {
                TCFConnection connection = this.fConnections.get(name);
                if (connection != null) {
                    connection.setPeerNode(peerNode);
                } else {
                    connection = new TCFConnection(peerNode);
                    this.fConnections.put(name, connection);
                }
                this.addRemoteConnection(connection);
            }
        }
        TCFConnection connection = this.fConnections.remove(name);
        if (connection != null) {
            connection.setConnectedTCF(false);
            IRemoteConnection rc = connection.getRemoteConnection();
            if (rc != null) {
                try {
                    rc.getConnectionType().removeConnection(rc);
                }
                catch (RemoteConnectionException e) {
                    CoreBundleActivator.logError("Cannot remove remote connection.", e);
                }
            }
        }
    }

    public void modelDisposed(IPeerModel model) {
        this.fConnections.clear();
    }

    public void eventFired(EventObject event) {
        IPeerNode peerNode;
        TCFConnection connection;
        ChangeEvent changeEvent = (ChangeEvent)event;
        Object source = changeEvent.getSource();
        if (source instanceof IPeerNode && "ConnectState".equals(changeEvent.getEventId()) && (connection = this.fConnections.get((peerNode = (IPeerNode)source).getPeer().getName())) != null) {
            Object val = changeEvent.getNewValue();
            boolean connected = val instanceof Number && ((Number)val).intValue() == 11;
            connection.setConnectedTCF(connected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(IPeerNode peerNode, IProgressMonitor monitor) throws RemoteConnectionException {
        final boolean[] done = new boolean[1];
        Callback callback = new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void internalDone(Object caller, IStatus status) {
                boolean[] blArray = done;
                synchronized (done) {
                    done[0] = true;
                    done.notify();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        boolean[] blArray = done;
        synchronized (done) {
            peerNode.changeConnectState(11, (ICallback)callback, monitor);
            try {
                if (!done[0]) {
                    done.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RemoteConnectionException((Throwable)e);
            }
            if (peerNode.getConnectState() != 11) {
                String msg;
                IStatus status = callback.getStatus();
                if (status != null && !status.isOK() && (msg = status.getMessage()) != null && msg.length() > 0) {
                    throw new RemoteConnectionException(msg, status.getException());
                }
                throw new RemoteConnectionException(Messages.TCFConnectionManager_errorCannotConnect, status != null ? status.getException() : null);
            }
            return;
        }
    }

    void close(IPeerNode peerNode) {
        peerNode.changeConnectState(1, (ICallback)new Callback(), null);
    }
}

