/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.ui.controls.PeerNameControl;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.RegexValidator;
import org.eclipse.tcf.te.ui.controls.validator.Validator;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.wizards.pages.AbstractFormsWizardPage;
import org.eclipse.ui.forms.IManagedForm;

public abstract class AbstractConfigWizardPage
extends AbstractFormsWizardPage
implements IDataExchangeNode {
    private ConfigNameControl configName = null;
    private AbstractSection selectorSection = null;
    private AbstractSection detailsSection = null;
    private AbstractSection[] additionalSections = null;
    final List<String> usedNames = new ArrayList<String>();

    public AbstractConfigWizardPage(String pageName) {
        super(pageName);
    }

    public AbstractConfigWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void dispose() {
        if (this.configName != null) {
            this.configName.dispose();
            this.configName = null;
        }
        if (this.selectorSection != null) {
            this.selectorSection.dispose();
            this.selectorSection = null;
        }
        if (this.detailsSection != null) {
            this.detailsSection.dispose();
            this.detailsSection = null;
        }
        if (this.additionalSections != null) {
            AbstractSection[] abstractSectionArray = this.additionalSections;
            int n = this.additionalSections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection additionalSection = abstractSectionArray[n2];
                additionalSection.dispose();
                ++n2;
            }
            this.additionalSections = null;
        }
        super.dispose();
    }

    protected void doCreateFormContent(Composite parent, CustomFormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        this.configName = new ConfigNameControl((IDialogPage)this);
        this.configName.setupPanel(parent);
        Label label = new Label(parent, 258);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectorSection = this.doCreateSelectorSection(this.getManagedForm(), parent);
        if (this.selectorSection != null) {
            this.selectorSection.getSection().setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.detailsSection = this.doCreateDetailsSection(this.getManagedForm(), parent);
        if (this.detailsSection != null) {
            this.detailsSection.getSection().setLayoutData((Object)new GridData(4, 1, true, false));
        }
        AbstractSection[] abstractSectionArray = this.additionalSections = this.doCreateAdditionalSections(this.getManagedForm(), parent);
        int n = this.additionalSections.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSection additionalSection = abstractSectionArray[n2];
            additionalSection.getSection().setLayoutData((Object)new GridData(4, 1, true, false));
            ++n2;
        }
        this.restoreWidgetValues();
        this.initializeUsedNameList();
    }

    public String getConfigName() {
        if (this.configName != null) {
            return this.configName.getEditFieldControlText();
        }
        return null;
    }

    protected abstract AbstractSection doCreateSelectorSection(IManagedForm var1, Composite var2);

    protected final AbstractSection getSelectorSection() {
        return this.selectorSection;
    }

    protected abstract AbstractSection doCreateDetailsSection(IManagedForm var1, Composite var2);

    protected AbstractSection[] doCreateAdditionalSections(IManagedForm form, Composite parent) {
        return new AbstractSection[0];
    }

    protected final AbstractSection[] getAdditionalSection() {
        return this.additionalSections;
    }

    protected final AbstractSection getDetailsSection() {
        return this.detailsSection;
    }

    protected abstract String getPeerType();

    protected abstract String getConfigNamePattern();

    protected abstract String getNewConfigName();

    protected void initializeUsedNameList() {
        this.usedNames.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerNode[] peers;
                IPeerNode[] iPeerNodeArray = peers = ModelManager.getPeerModel().getPeerNodes();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerNode peerNode = iPeerNodeArray[n2];
                    String name = peerNode.getPeer().getName();
                    Assert.isNotNull((Object)name);
                    if (!"".equals(name) && !AbstractConfigWizardPage.this.usedNames.contains(name)) {
                        AbstractConfigWizardPage.this.usedNames.add(name.trim().toUpperCase());
                    }
                    ++n2;
                }
            }
        };
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        Protocol.invokeAndWait((Runnable)runnable);
    }

    public void autoGenerateConfigurationName(String customID) {
        int index;
        String currentName;
        customID = customID != null ? customID.replaceAll("[^0-9a-zA-Z. _()-]", "_") : "";
        String pattern = this.getConfigNamePattern();
        Assert.isNotNull((Object)pattern);
        String string = currentName = this.configName != null ? this.configName.getEditFieldControlText().trim() : null;
        if (currentName != null && !"".equals(currentName.trim()) && !currentName.matches(pattern)) {
            return;
        }
        String origProposedName = customID;
        String proposedName = origProposedName;
        if (this.usedNames.contains(proposedName.trim().toUpperCase()) && proposedName.matches(".* \\([0-9]*\\)") && (index = proposedName.lastIndexOf(32)) > 0) {
            proposedName = origProposedName = proposedName.substring(0, index);
        }
        if (this.usedNames.contains(proposedName.trim().toUpperCase()) && proposedName.matches(pattern)) {
            proposedName = this.getNewConfigName();
        }
        int count = 0;
        while (this.usedNames.contains(proposedName.trim().toUpperCase())) {
            proposedName = String.valueOf(origProposedName.trim()) + " (" + ++count + ")";
        }
        if (this.configName != null) {
            this.configName.setEditFieldControlText(proposedName.trim());
        }
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = new IValidatingContainer.ValidationResult();
        boolean valid = true;
        if (this.configName != null) {
            valid &= this.configName.isValid();
            result.setResult((IMessageProvider)this.configName);
        }
        if (this.selectorSection != null) {
            valid &= this.selectorSection.isValid();
            result.setResult((IMessageProvider)this.selectorSection);
        }
        if (this.detailsSection != null) {
            valid &= this.detailsSection.isValid();
            result.setResult((IMessageProvider)this.detailsSection);
        }
        if (this.additionalSections != null) {
            AbstractSection[] abstractSectionArray = this.additionalSections;
            int n = this.additionalSections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection additionalSection = abstractSectionArray[n2];
                valid &= additionalSection.isValid();
                result.setResult((IMessageProvider)additionalSection);
                ++n2;
            }
        }
        result.setValid(valid);
        return result;
    }

    protected void updatePeerAttributes(IPropertiesContainer peerAttributes) {
        String value;
        Assert.isNotNull((Object)peerAttributes);
        if (this.getControl() == null) {
            return;
        }
        String string = value = this.configName != null ? this.configName.getEditFieldControlText() : null;
        if (value != null && !"".equals(value)) {
            peerAttributes.setProperty("Name", (Object)value);
        }
        if (this.selectorSection != null) {
            this.updateAttribute(this.selectorSection, peerAttributes);
        }
        if (this.detailsSection != null) {
            this.updateAttribute(this.detailsSection, peerAttributes);
        }
        if (this.additionalSections != null) {
            AbstractSection[] abstractSectionArray = this.additionalSections;
            int n = this.additionalSections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection additionalSection = abstractSectionArray[n2];
                this.updateAttribute(additionalSection, peerAttributes);
                ++n2;
            }
        }
    }

    protected void updateAttribute(AbstractSection section, IPropertiesContainer peerAttributes) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)peerAttributes);
        if (section instanceof IDataExchangeNode) {
            ((IDataExchangeNode)section).extractData(peerAttributes);
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        this.updatePeerAttributes(data);
    }

    public void setupData(IPropertiesContainer data) {
        if (this.selectorSection instanceof IDataExchangeNode) {
            ((IDataExchangeNode)this.selectorSection).setupData(data);
        }
        if (this.detailsSection instanceof IDataExchangeNode) {
            ((IDataExchangeNode)this.detailsSection).setupData(data);
        }
        if (this.additionalSections != null) {
            AbstractSection[] abstractSectionArray = this.additionalSections;
            int n = this.additionalSections.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractSection additionalSection = abstractSectionArray[n2];
                ((IDataExchangeNode)additionalSection).setupData(data);
                ++n2;
            }
        }
        if (data.containsKey("Name")) {
            String name = data.getStringProperty("Name");
            name = name.replaceAll("[^0-9a-zA-Z. _()-]", "_");
            this.autoGenerateConfigurationName(name);
        }
    }

    public void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.selectorSection != null) {
                this.selectorSection.saveWidgetValues(settings);
            }
            if (this.detailsSection != null) {
                this.detailsSection.saveWidgetValues(settings);
            }
            if (this.additionalSections != null) {
                AbstractSection[] abstractSectionArray = this.additionalSections;
                int n = this.additionalSections.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractSection additionalSection = abstractSectionArray[n2];
                    additionalSection.saveWidgetValues(settings);
                    ++n2;
                }
            }
        }
    }

    public void restoreWidgetValues() {
        super.restoreWidgetValues();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.selectorSection != null) {
                this.selectorSection.restoreWidgetValues(settings);
            }
            if (this.detailsSection != null) {
                this.detailsSection.restoreWidgetValues(settings);
            }
            if (this.additionalSections != null) {
                AbstractSection[] abstractSectionArray = this.additionalSections;
                int n = this.additionalSections.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractSection additionalSection = abstractSectionArray[n2];
                    additionalSection.restoreWidgetValues(settings);
                    ++n2;
                }
            }
        }
    }

    protected static class ConfigNameControl
    extends PeerNameControl {
        public ConfigNameControl(IDialogPage parentPage) {
            super(parentPage);
            this.setEditFieldLabel(Messages.AbstractConfigWizardPage_configName_label);
        }

        @Override
        protected Validator doCreateEditFieldValidator() {
            return new RegexValidator(1, "[0-9a-zA-Z. _()-]+");
        }

        @Override
        protected void configureEditFieldValidator(Validator validator) {
            if (validator instanceof RegexValidator) {
                validator.setMessageText("RegexValidator_Information_MissingValue", Messages.AbstractConfigWizardPage_configName_infoMissingValue);
            }
        }

        public boolean isValid() {
            boolean valid = true;
            String name = this.getEditFieldControlTextForValidation();
            if (!"".equals(name) && this.getParentPage() instanceof AbstractConfigWizardPage) {
                boolean bl = valid = !((AbstractConfigWizardPage)this.getParentPage()).usedNames.contains(name.trim().toUpperCase());
                if (!valid) {
                    this.setMessage(Messages.AbstractConfigWizardPage_configName_nameInUse, 3);
                }
            }
            if (!valid && this.getControlDecoration() != null && this.isEnabled()) {
                this.updateControlDecoration(this.getMessage(), this.getMessageType());
            }
            return valid ? super.isValid() : false;
        }
    }
}

