/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.net;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.te.ui.controls.BaseEditBrowseTextControl;
import org.eclipse.tcf.te.ui.controls.activator.UIPlugin;
import org.eclipse.tcf.te.ui.controls.nls.Messages;
import org.eclipse.tcf.te.ui.controls.validator.NameOrIPValidator;
import org.eclipse.tcf.te.ui.controls.validator.NameOrIPVerifyListener;
import org.eclipse.tcf.te.ui.controls.validator.Validator;

public class RemoteHostAddressControl
extends BaseEditBrowseTextControl {
    private VerifyListener verifyListener;

    public RemoteHostAddressControl(IDialogPage parentPage) {
        super(parentPage);
        this.setIsGroup(false);
        this.setHasHistory(false);
        this.setEditFieldLabel(Messages.RemoteHostAddressControl_label);
        this.setButtonLabel(Messages.RemoteHostAddressControl_button_label);
    }

    @Override
    protected void onButtonControlSelected() {
        this.onCheckAddress();
        this.getButtonControl().setEnabled(false);
        if (this.getMessage() != null && this.getMessage().equals(this.getUserInformationTextCheckNameAddress())) {
            this.setMessage(null, 0);
        }
        if (this.getControlDecoration() != null) {
            this.getControlDecoration().hide();
        }
    }

    @Override
    public void modifyText(ModifyEvent e) {
        super.modifyText(e);
        boolean enabled = this.isValid() && (!(this.getEditFieldValidator() instanceof NameOrIPValidator) || ((NameOrIPValidator)this.getEditFieldValidator()).isName());
        this.setButtonControlEnabled(enabled);
        if (enabled && this.getControlDecoration() != null) {
            this.getControlDecoration().hide();
        }
    }

    @Override
    protected void setButtonControlEnabled(boolean enabled) {
        boolean btnEnabled = enabled;
        if (btnEnabled) {
            btnEnabled = this.isValid() && (!(this.getEditFieldValidator() instanceof NameOrIPValidator) || ((NameOrIPValidator)this.getEditFieldValidator()).isName());
        }
        super.setButtonControlEnabled(btnEnabled);
    }

    @Override
    protected Validator doCreateEditFieldValidator() {
        return new NameOrIPValidator(15);
    }

    @Override
    protected void configureEditFieldValidator(Validator validator) {
        if (validator != null && validator instanceof NameOrIPValidator) {
            validator.setMessageText("NameOrIPValidator_Information_MissingNameOrIP", Messages.RemoteHostAddressControl_information_missingTargetNameAddress);
            validator.setMessageText("NameOrIPValidator_Error.InvalidNameOrIP", Messages.RemoteHostAddressControl_error_invalidTargetNameAddress);
            validator.setMessageText("NameOrIPValidator_Error_InvalidName", Messages.RemoteHostAddressControl_error_invalidTargetNameAddress);
            validator.setMessageText("NameOrIPValidator_Error_InvalidIP", Messages.RemoteHostAddressControl_error_invalidTargetIpAddress);
            validator.setMessageText("NameOrIPValidator_Information_CheckName", this.getUserInformationTextCheckNameAddress());
        }
    }

    @Override
    protected VerifyListener doGetEditFieldControlVerifyListener() {
        if (this.verifyListener == null) {
            this.verifyListener = new NameOrIPVerifyListener(3);
        }
        return this.verifyListener;
    }

    protected String getUserInformationTextCheckNameAddress() {
        return Messages.RemoteHostAddressControl_information_checkNameAddressUserInformation;
    }

    protected String getTaskNameCheckNameAddress() {
        return Messages.RemoteHostAddressControl_information_checkNameAddressField;
    }

    protected String getInformationTextCheckNameAddressSuccess() {
        return Messages.RemoteHostAddressControl_information_checkNameAddressFieldOk;
    }

    protected String getErrorTextCheckNameAddressFailed() {
        return Messages.RemoteHostAddressControl_error_targetNameNotResolveable;
    }

    private void onCheckAddress() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getParentControl().getShell());
        try {
            dialog.run(false, false, new IRunnableWithProgress(){
                private final String address;
                private final Control control;
                private final IDialogPage parentPage;
                {
                    this.address = RemoteHostAddressControl.this.getEditFieldControlText();
                    this.control = RemoteHostAddressControl.this.getEditFieldControl();
                    this.parentPage = RemoteHostAddressControl.this.getParentPage();
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block26: {
                        try {
                            try {
                                monitor.setTaskName(RemoteHostAddressControl.this.getTaskNameCheckNameAddress());
                                InetAddress[] addresses = InetAddress.getAllByName(this.address);
                                if (Platform.inDebugMode() && addresses != null) {
                                    StringBuilder message = new StringBuilder();
                                    message.append("RemoteHostAddressControl: Name '");
                                    message.append(this.address);
                                    message.append("' resolves to: ");
                                    boolean firstAddress = true;
                                    InetAddress[] inetAddressArray = addresses;
                                    int n = addresses.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        InetAddress address = inetAddressArray[n2];
                                        if (!firstAddress) {
                                            message.append(", ");
                                        }
                                        message.append(address.getHostAddress());
                                        firstAddress = false;
                                        ++n2;
                                    }
                                    Status status = new Status(2, UIPlugin.getUniqueIdentifier(), message.toString());
                                    UIPlugin.getDefault().getLog().log((IStatus)status);
                                }
                                RemoteHostAddressControl.this.setCheckResultMessage(1, RemoteHostAddressControl.this.getInformationTextCheckNameAddressSuccess());
                            }
                            catch (Exception exception) {
                                RemoteHostAddressControl.this.setCheckResultMessage(2, RemoteHostAddressControl.this.getErrorTextCheckNameAddressFailed());
                                this.control.setFocus();
                                IWizardContainer container = null;
                                try {
                                    if (this.parentPage != null) {
                                        Object result;
                                        Class[] paramTypes = new Class[]{};
                                        Object[] args = new Object[]{};
                                        Method method = this.parentPage.getClass().getMethod("getContainer", paramTypes);
                                        if (!method.isAccessible()) {
                                            AccessController.doPrivileged(new PrivilegedAction<Object>(method){
                                                private final /* synthetic */ Method val$method;
                                                {
                                                    this.val$method = method;
                                                }

                                                @Override
                                                public Object run() {
                                                    this.val$method.setAccessible(true);
                                                    return null;
                                                }
                                            });
                                        }
                                        if ((result = method.invoke((Object)this.parentPage, args)) instanceof IWizardContainer) {
                                            container = (IWizardContainer)result;
                                        }
                                    }
                                }
                                catch (Exception exception2) {
                                    container = null;
                                }
                                if (container != null) {
                                    container.updateButtons();
                                    container.updateMessage();
                                }
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            IWizardContainer container = null;
                            try {
                                if (this.parentPage != null) {
                                    Object result;
                                    Class[] paramTypes = new Class[]{};
                                    Object[] args = new Object[]{};
                                    Method method = this.parentPage.getClass().getMethod("getContainer", paramTypes);
                                    if (!method.isAccessible()) {
                                        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    if ((result = method.invoke((Object)this.parentPage, args)) instanceof IWizardContainer) {
                                        container = (IWizardContainer)result;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                container = null;
                            }
                            if (container != null) {
                                container.updateButtons();
                                container.updateMessage();
                            }
                            throw throwable;
                        }
                        IWizardContainer container = null;
                        try {
                            if (this.parentPage != null) {
                                Object result;
                                Class[] paramTypes = new Class[]{};
                                Object[] args = new Object[]{};
                                Method method = this.parentPage.getClass().getMethod("getContainer", paramTypes);
                                if (!method.isAccessible()) {
                                    AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
                                }
                                if ((result = method.invoke((Object)this.parentPage, args)) instanceof IWizardContainer) {
                                    container = (IWizardContainer)result;
                                }
                            }
                        }
                        catch (Exception exception) {
                            container = null;
                        }
                        if (container != null) {
                            container.updateButtons();
                            container.updateMessage();
                        }
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    protected void setCheckResultMessage(int severity, String message) {
        this.setMessage(message, severity);
        if (this.getParentPage() instanceof DialogPage) {
            ((DialogPage)this.getParentPage()).setMessage(message, severity);
        }
    }
}

