/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal.adapters;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.interfaces.IConnectable;
import org.eclipse.tcf.te.runtime.model.factory.Factory;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistableURIProvider;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.internal.adapters.PeerNodeStepContext;
import org.eclipse.tcf.te.tcf.locator.internal.adapters.PeerPersistableURIProvider;
import org.eclipse.tcf.te.tcf.locator.internal.adapters.PeerStepContext;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;

public class AdapterFactory
implements IAdapterFactory {
    private final IPersistableURIProvider peerModelPersistableURIProvider = new PeerPersistableURIProvider();
    private static final Class<?>[] CLASSES = new Class[]{IPersistableURIProvider.class, IPeerNode.class, IConnectable.class, IPeerModel.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof Map && IPersistableURIProvider.class.equals((Object)adapterType)) {
            Assert.isTrue((boolean)false);
        }
        if (IConnectable.class.isAssignableFrom(adapterType) && adaptableObject instanceof IConnectable) {
            return adaptableObject;
        }
        if (IPeerModel.class.isAssignableFrom(adapterType) && adaptableObject instanceof IPeerNode) {
            return ((IPeerNode)adaptableObject).getModel();
        }
        if (adaptableObject instanceof IPeerNode || adaptableObject instanceof IPeer || adaptableObject instanceof IPeerNodeProvider) {
            if (IPersistableURIProvider.class.equals((Object)adapterType)) {
                return this.peerModelPersistableURIProvider;
            }
            if (IPeerNode.class.equals((Object)adapterType)) {
                if (adaptableObject instanceof IPeer) {
                    final AtomicReference node = new AtomicReference();
                    final IPeer peer = (IPeer)adaptableObject;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            String id = peer.getID();
                            IPeerModel model = ModelManager.getPeerModel();
                            Assert.isNotNull((Object)model);
                            IPeerNode candidate = model.getService(IPeerModelLookupService.class).lkupPeerModelById(id);
                            if (candidate != null) {
                                node.set(candidate);
                            } else {
                                candidate = (IPeerNode)Factory.getInstance().newInstance(IPeerNode.class, new Object[]{model, peer});
                                if (candidate != null) {
                                    node.set(candidate);
                                }
                            }
                        }
                    };
                    if (Protocol.isDispatchThread()) {
                        runnable.run();
                    } else {
                        Protocol.invokeAndWait((Runnable)runnable);
                    }
                    return node.get();
                }
                if (adaptableObject instanceof IPeerNode) {
                    return adaptableObject;
                }
                if (adaptableObject instanceof IPeerNodeProvider) {
                    final AtomicReference node = new AtomicReference();
                    final IPeerNodeProvider provider = (IPeerNodeProvider)adaptableObject;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            node.set(provider.getPeerNode());
                        }
                    };
                    if (Protocol.isDispatchThread()) {
                        runnable.run();
                    } else {
                        Protocol.invokeAndWait((Runnable)runnable);
                    }
                    return node.get();
                }
            }
            if (IStepContext.class.equals((Object)adapterType)) {
                if (adaptableObject instanceof IPeer) {
                    return new PeerStepContext((IPeer)adaptableObject);
                }
                if (adaptableObject instanceof IPeerNode) {
                    return new PeerNodeStepContext((IPeerNode)adaptableObject);
                }
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

