/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.callback;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.nls.Messages;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.utils.ProgressHelper;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;

public class Callback
extends PropertiesContainer
implements ICallback {
    protected static final String PROPERTY_PARENT_CALLBACK = "parentCallback";
    protected static final String PROPERTY_PROGRESS_MONITOR = "progressMonitor";
    protected static final String PROPERTY_PROGRESS_TICKS = "progressTicks";
    protected static final String PROPERTY_IS_DONE = "isDone";
    public static final String PROPERTY_STATUS = "status";
    protected static final String PROPERTY_RESULT = "result";
    private static final String[] PROPERTY_KEYS_NOT_TO_COPY = new String[]{"parentCallback", "progressMonitor", "progressTicks", "isDone", "status"};
    private static final List<String> PROPERTY_KEYS_NOT_TO_COPY_LIST = Arrays.asList(PROPERTY_KEYS_NOT_TO_COPY);

    public Callback() {
        this(null);
    }

    public Callback(ICallback parentCallback) {
        this(null, -1, parentCallback);
    }

    public Callback(IProgressMonitor monitor, int ticksToUse) {
        this(monitor, ticksToUse, null);
    }

    public Callback(IProgressMonitor monitor, int ticksToUse, ICallback parentCallback) {
        this.setProperty(PROPERTY_PARENT_CALLBACK, parentCallback);
        this.setProperty(PROPERTY_PROGRESS_MONITOR, monitor);
        this.setProperty(PROPERTY_PROGRESS_TICKS, ticksToUse);
    }

    public final IConditionTester getDoneConditionTester(IProgressMonitor monitor) {
        return new CallbackDoneConditionTester(this, monitor);
    }

    public final IConditionTester getDoneConditionTester(IProgressMonitor monitor, int cancelTimeout) {
        return new CallbackDoneConditionTester(this, monitor, cancelTimeout);
    }

    @Override
    public final void done(Object caller, IStatus status) {
        Assert.isNotNull((Object)status);
        if (this.isDone()) {
            if (this.getStatus() != null && this.getStatus().getSeverity() != 8) {
                CoreBundleActivator.getTraceHandler().trace("WARNING: callback called twice!!", 1, (Object)this);
            }
            return;
        }
        this.setProperty(PROPERTY_IS_DONE, null);
        this.setProperty(PROPERTY_STATUS, this.checkStatusIntegrity(status));
        this.internalDone(caller, (IStatus)this.getProperty(PROPERTY_STATUS));
        if (this.getProperty(PROPERTY_IS_DONE) == null) {
            this.setProperty(PROPERTY_IS_DONE, true);
        }
        if (this.isDone()) {
            ICallback parentCallback;
            IProgressMonitor progress;
            if (this.getProperty(PROPERTY_PROGRESS_MONITOR) instanceof IProgressMonitor && !ProgressHelper.isCanceled(progress = (IProgressMonitor)this.getProperty(PROPERTY_PROGRESS_MONITOR)) && this.getStatus().getSeverity() != 8) {
                int ticks = this.getIntProperty(PROPERTY_PROGRESS_TICKS);
                if (ticks > 0) {
                    ProgressHelper.worked(progress, ticks);
                } else if (ticks == 0) {
                    ProgressHelper.done(progress);
                }
            }
            if ((parentCallback = (ICallback)this.getProperty(PROPERTY_PARENT_CALLBACK)) != null) {
                if (parentCallback.isDone()) {
                    CoreBundleActivator.getTraceHandler().trace("WARNING: parent callback called twice!!", 1, (Object)this);
                } else {
                    Callback.copyProperties(this, parentCallback);
                    if (!ProgressHelper.isCancelOrError(this, this.getStatus(), (IProgressMonitor)this.getProperty(PROPERTY_PROGRESS_MONITOR), parentCallback)) {
                        parentCallback.done(caller, this.getStatus());
                    }
                }
            }
        }
    }

    public static final void copyProperties(ICallback source, ICallback destination) {
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)destination);
        Assert.isTrue((!destination.isDone() ? 1 : 0) != 0);
        for (String key : source.getProperties().keySet()) {
            if (PROPERTY_KEYS_NOT_TO_COPY_LIST.contains(key)) continue;
            destination.setProperty(key, source.getProperty(key));
        }
        Assert.isTrue((!destination.isDone() ? 1 : 0) != 0);
    }

    private IStatus checkStatusIntegrity(IStatus status) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        if (status.getSeverity() == 8 && status.getException() == null) {
            status = new Status(8, status.getPlugin(), status.getMessage(), (Throwable)new OperationCanceledException(status.getMessage()));
        }
        if (status.getSeverity() == 2 && status.getException() == null) {
            status = new Status(2, status.getPlugin(), status.getMessage(), (Throwable)new Exception(status.getMessage()));
        }
        if (status.getSeverity() == 4 && status.getException() == null) {
            status = new Status(4, status.getPlugin(), status.getMessage(), (Throwable)new Exception(status.getMessage()));
        }
        return status;
    }

    protected final IProgressMonitor getProgressMonitor() {
        return (IProgressMonitor)this.getProperty(PROPERTY_PROGRESS_MONITOR);
    }

    protected void internalDone(Object caller, IStatus status) {
    }

    public final IStatus getStatus() {
        IProgressMonitor monitor;
        IStatus status = (IStatus)this.getProperty(PROPERTY_STATUS);
        if (status == null && this.getProperty(PROPERTY_PROGRESS_MONITOR) instanceof IProgressMonitor && (monitor = (IProgressMonitor)this.getProperty(PROPERTY_PROGRESS_MONITOR)).isCanceled()) {
            return this.checkStatusIntegrity(Status.CANCEL_STATUS);
        }
        return this.checkStatusIntegrity(status);
    }

    @Override
    public final boolean isDone() {
        return this.getBooleanProperty(PROPERTY_IS_DONE);
    }

    @Override
    public void addParentCallback(ICallback callback) {
        if (this.getProperty(PROPERTY_PARENT_CALLBACK) instanceof ICallback) {
            ICallback parentCallback = (ICallback)this.getProperty(PROPERTY_PARENT_CALLBACK);
            parentCallback.addParentCallback(callback);
        } else {
            this.setProperty(PROPERTY_PARENT_CALLBACK, callback);
        }
    }

    @Override
    public void setResult(Object result) {
        this.setProperty(PROPERTY_RESULT, result);
    }

    @Override
    public Object getResult() {
        return this.getProperty(PROPERTY_RESULT);
    }

    public static class CallbackDoneConditionTester
    implements IConditionTester {
        protected final ICallback callback;
        protected final IProgressMonitor monitor;
        protected int cancelTimeout = -1;
        protected long cancelTime = -1L;

        public CallbackDoneConditionTester(ICallback callback, IProgressMonitor monitor) {
            this(callback, monitor, -1);
        }

        public CallbackDoneConditionTester(ICallback callback, IProgressMonitor monitor, int cancelTimeout) {
            Assert.isNotNull((Object)callback);
            this.callback = callback;
            this.monitor = monitor;
            this.cancelTimeout = cancelTimeout;
        }

        @Override
        public boolean isConditionFulfilled() {
            if (this.monitor == null) {
                return this.callback.isDone();
            }
            if (this.cancelTimeout > 0 && !this.callback.isDone() && this.monitor.isCanceled()) {
                if (this.cancelTime == -1L) {
                    this.cancelTime = System.currentTimeMillis();
                    this.monitor.subTask("Cancelling...");
                } else {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - this.cancelTime >= (long)this.cancelTimeout) {
                        this.callback.done(this, StatusHelper.getStatus((Throwable)new OperationCanceledException(Messages.Callback_warning_cancelTimeout)));
                        return true;
                    }
                }
            }
            return this.callback.isDone();
        }

        @Override
        public void cleanup() {
        }
    }
}

