/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.tabs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchSpecification;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.ui.selection.LaunchSelectionManager;

public abstract class AbstractLaunchConfigurationTabGroup
extends org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup {
    private ILaunchConfigurationDialog dialog;
    private String mode;

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.dialog = dialog;
        this.mode = mode;
        ArrayList<ILaunchConfigurationTab> tabs = new ArrayList<ILaunchConfigurationTab>();
        this.createContextSelectorTab(dialog, tabs, mode);
        this.createAdditionalTabs(dialog, tabs, mode);
        this.setTabs(tabs.toArray(new ILaunchConfigurationTab[tabs.size()]));
    }

    public void createContextSelectorTab(ILaunchConfigurationDialog dialog, List<ILaunchConfigurationTab> tabs, String mode) {
        Assert.isNotNull(tabs);
    }

    public void createAdditionalTabs(ILaunchConfigurationDialog dialog, List<ILaunchConfigurationTab> tabs, String mode) {
        Assert.isNotNull(tabs);
    }

    public void dispose() {
        this.dialog = null;
        this.mode = null;
        super.dispose();
    }

    protected final ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.dialog;
    }

    protected final String getLaunchMode() {
        return this.mode;
    }

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (configuration != null && this.getLaunchMode() != null) {
            try {
                ILaunchSpecification launchSpec;
                ILaunchConfigurationType launchConfigType = configuration.getType();
                String launchConfigTypeId = launchConfigType.getIdentifier();
                String launchMode = this.getLaunchConfigurationDialog().getMode();
                ILaunchSelection launchSelection = LaunchSelectionManager.getInstance().getLaunchSelection(launchConfigType, launchMode, null);
                ILaunchManagerDelegate delegate = LaunchManager.getInstance().getLaunchManagerDelegate(launchConfigType, launchMode);
                Assert.isNotNull((Object)delegate);
                if (launchSelection != null && (launchSpec = delegate.getLaunchSpecification(launchConfigTypeId, launchSelection)) != null) {
                    delegate.initLaunchConfigAttributes(configuration, launchSpec);
                }
            }
            catch (CoreException coreException) {}
        }
        super.setDefaults(configuration);
    }

    public final void initializeFrom(ILaunchConfiguration configuration) {
        if (!(configuration instanceof ILaunchConfigurationWorkingCopy)) {
            try {
                configuration = configuration.getWorkingCopy();
            }
            catch (CoreException coreException) {}
        }
        super.initializeFrom(configuration);
    }
}

