/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.shells;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IServiceCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ShellServiceSubSystemConfiguration;
import org.eclipse.tcf.internal.rse.ITCFService;
import org.eclipse.tcf.internal.rse.TCFConnectorService;
import org.eclipse.tcf.internal.rse.TCFConnectorServiceManager;
import org.eclipse.tcf.internal.rse.shells.TCFServiceCommandShell;
import org.eclipse.tcf.internal.rse.terminals.TCFTerminalService;

public class TCFShellSubSystemConfiguration
extends ShellServiceSubSystemConfiguration {
    public ISubSystem createSubSystemInternal(IHost host) {
        TCFConnectorService connectorService = (TCFConnectorService)this.getConnectorService(host);
        ShellServiceSubSystem subsys = new ShellServiceSubSystem(host, (IConnectorService)connectorService, this.createShellService(host));
        return subsys;
    }

    public IConnectorService getConnectorService(IHost host) {
        return TCFConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        TCFConnectorServiceManager.getInstance().setConnectorService(host, this.getServiceImplType(), connectorService);
    }

    public Class<ITCFService> getServiceImplType() {
        return ITCFService.class;
    }

    public IServiceCommandShell createRemoteCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        return new TCFServiceCommandShell(cmdSS, hostShell);
    }

    public IShellService createShellService(IHost host) {
        TCFConnectorService cserv = (TCFConnectorService)this.getConnectorService(host);
        return (IShellService)new TCFTerminalService(cserv).getAdapter(IShellService.class);
    }
}

