/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.local.launcher;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class LocalLauncherHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPath path;
        IEditorInput input;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof IStructuredSelection) && (input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) instanceof IPathEditorInput && (path = ((IPathEditorInput)input).getPath()) != null) {
            if (path.toFile().isFile()) {
                path = path.removeLastSegments(1);
            }
            if (path.toFile().isDirectory() && path.toFile().canRead()) {
                selection = new StructuredSelection((Object)path);
            }
        }
        ILauncherDelegate[] delegates = LauncherDelegateManager.getInstance().getApplicableLauncherDelegates(selection);
        ILauncherDelegate delegate = null;
        ILauncherDelegate[] iLauncherDelegateArray = delegates;
        int n = delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ILauncherDelegate candidate = iLauncherDelegateArray[n2];
            if ("org.eclipse.tcf.te.ui.terminals.local.launcher.local".equals(candidate.getId())) {
                delegate = candidate;
                break;
            }
            ++n2;
        }
        if (delegate != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("delegateId", delegate.getId());
            properties.put("selection", (String)selection);
            delegate.execute(properties, null);
        }
        return null;
    }
}

