/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.serial.controls;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.terminals.serial.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.serial.nls.Messages;
import org.eclipse.ui.PlatformUI;

public class SerialPortAddressDialog
extends TitleAreaDialog
implements IMessageProvider {
    private String contextHelpId = null;
    private String message;
    private int messageType;
    private String errorMessage;
    private String title;
    private String defaultMessage;
    private int defaultMessageType;
    Button ttyControlSelector;
    Combo ttyControl;
    Button tcpControlSelector;
    Combo addressControl;
    Combo portControl;
    Label portLabel;
    List<String> ttyHistory;
    List<String> tcpHistory;
    String data = null;
    static final String IP_CHARACTERS_REGEX = "[0-9][0-9\\.]*";
    static final String IP_FRAGMENT_REGEX = "([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])";
    static final String IP_REGEX = "([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])(\\.([0-1]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){3}[ ]*";
    static final String NAME_CHARACTERS_REGEX = "[a-zA-Z][0-9a-zA-Z\\-_\\.]*";
    static final String NAME_START_REGEX = "[a-zA-Z]";
    static final String NAME_FOLLOW_REGEX = "[a-zA-Z0-9-_]";
    static final String NAME_END_REGEX = "[a-zA-Z0-9]";
    static final String NAME_FRAGMENT_REGEX = "([a-zA-Z]([a-zA-Z0-9-_]*[a-zA-Z0-9])?)";
    static final String NAME_REGEX = "([a-zA-Z]([a-zA-Z0-9-_]*[a-zA-Z0-9])?)(\\.([a-zA-Z]([a-zA-Z0-9-_]*[a-zA-Z0-9])?))*[ ]*";
    private static final Pattern validCharacters = "win32".equals(Platform.getOS()) ? Pattern.compile("[\\w]+") : Pattern.compile("[\\w/]+");

    public SerialPortAddressDialog(Shell parentShell, String selected, List<String> ttyHistory, List<String> tcpHistory) {
        super(parentShell);
        this.ttyHistory = ttyHistory;
        this.tcpHistory = tcpHistory;
        this.data = selected;
        this.contextHelpId = String.valueOf(UIPlugin.getUniqueIdentifier()) + ".SerialPortAddressDialog";
        this.setHelpAvailable(true);
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        if (this.isMessageSet()) {
            if (this.errorMessage != null) {
                super.setErrorMessage(this.errorMessage);
            } else {
                super.setMessage(this.message, this.messageType);
            }
        } else if (this.defaultMessage != null) {
            super.setMessage(this.defaultMessage, this.defaultMessageType);
        }
        if (this.title != null) {
            super.setTitle(this.title);
        }
    }

    protected final Control createDialogArea(Composite parent) {
        Control control;
        if (this.contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextHelpId);
        }
        if ((control = super.createDialogArea(parent)) instanceof Composite) {
            ScrolledComposite sc = new ScrolledComposite((Composite)control, 512);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            sc.setLayout((Layout)layout);
            sc.setLayoutData((Object)new GridData(1808));
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            Composite composite = new Composite((Composite)sc, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createDialogAreaContent(composite);
            sc.setContent((Control)composite);
            sc.setMinSize(composite.computeSize(-1, -1));
            control = sc;
        }
        return control;
    }

    protected void createDialogAreaContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.setDialogTitle(Messages.SerialPortAddressDialog_dialogtitle);
        this.setTitle(Messages.SerialPortAddressDialog_title);
        Composite ttyComp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        ttyComp.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = 250;
        ttyComp.setLayoutData((Object)layoutData);
        Composite panel = new Composite(ttyComp, 0);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        layoutData = new GridData(4, 0x1000000, true, false);
        panel.setLayoutData((Object)layoutData);
        this.ttyControlSelector = new Button(panel, 16);
        this.ttyControlSelector.setText(Messages.SerialLinePanel_hostTTYDevice_label);
        layoutData = new GridData(16384, 0x1000000, false, false);
        this.ttyControlSelector.setLayoutData((Object)layoutData);
        this.ttyControlSelector.setSelection(true);
        this.ttyControlSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = SerialPortAddressDialog.this.ttyControlSelector.getSelection();
                SerialPortAddressDialog.this.setTTYControlEnabled(selected);
                SerialPortAddressDialog.this.setTCPControlEnabled(!selected);
                SerialPortAddressDialog.this.onModify();
            }
        });
        this.ttyControl = new Combo(panel, 4);
        layoutData = new GridData(4, 4, true, true);
        this.ttyControl.setLayoutData((Object)layoutData);
        this.ttyControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SerialPortAddressDialog.this.onModify();
            }
        });
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean enable = SerialPortAddressDialog.this.ttyHistory != null && SerialPortAddressDialog.this.ttyHistory.contains(SerialPortAddressDialog.this.data);
                SerialPortAddressDialog.this.setTTYControlEnabled(enable);
                SerialPortAddressDialog.this.setTCPControlEnabled(!enable);
                SerialPortAddressDialog.this.onModify();
            }
        });
        Composite tcpComp = new Composite(parent, 0);
        layout = new GridLayout(2, true);
        tcpComp.setLayout((Layout)layout);
        layoutData = new GridData(4, 0x1000000, true, false);
        tcpComp.setLayoutData((Object)layoutData);
        Composite tcpAddrComp = new Composite(tcpComp, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tcpAddrComp.setLayout((Layout)layout);
        layoutData = new GridData(4, 0x1000000, true, false);
        tcpAddrComp.setLayoutData((Object)layoutData);
        this.tcpControlSelector = new Button(tcpAddrComp, 16);
        this.tcpControlSelector.setText(Messages.SerialPortAddressDialog_address);
        layoutData = new GridData(16384, 0x1000000, false, false);
        this.tcpControlSelector.setLayoutData((Object)layoutData);
        this.tcpControlSelector.setSelection(false);
        this.tcpControlSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = SerialPortAddressDialog.this.tcpControlSelector.getSelection();
                SerialPortAddressDialog.this.setTTYControlEnabled(!selected);
                SerialPortAddressDialog.this.setTCPControlEnabled(selected);
                SerialPortAddressDialog.this.onModify();
            }
        });
        this.addressControl = new Combo(tcpAddrComp, 4);
        layoutData = new GridData(4, 4, true, true);
        this.addressControl.setLayoutData((Object)layoutData);
        this.addressControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SerialPortAddressDialog.this.onModify();
            }
        });
        Composite tcpPortComp = new Composite(tcpComp, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tcpPortComp.setLayout((Layout)layout);
        layoutData = new GridData(4, 0x1000000, true, false);
        tcpPortComp.setLayoutData((Object)layoutData);
        this.portLabel = new Label(tcpPortComp, 256);
        this.portLabel.setText(Messages.SerialPortAddressDialog_port);
        layoutData = new GridData(16384, 0x1000000, false, false);
        this.portLabel.setLayoutData((Object)layoutData);
        this.portControl = new Combo(tcpPortComp, 4);
        layoutData = new GridData(4, 4, true, true);
        this.portControl.setLayoutData((Object)layoutData);
        this.portControl.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                StringBuilder buffer = new StringBuilder(((Combo)e.widget).getText());
                try {
                    if (e.end > e.start) {
                        buffer.replace(e.start, e.end, e.text);
                    } else if (e.end >= 0) {
                        buffer.insert(e.end, e.text);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                String fulltext = buffer.toString();
                e.doit = fulltext.matches("([0-9]{0,5})|(0((x|X)[0-9a-fA-F]{0,4})?)");
                if (e.doit && fulltext.length() > 0 && !fulltext.equalsIgnoreCase("0x")) {
                    try {
                        int value = Integer.decode(fulltext);
                        if (value < 0 || value > 65535) {
                            e.doit = false;
                        }
                    }
                    catch (Exception exception) {
                        e.doit = false;
                    }
                }
            }
        });
        this.portControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SerialPortAddressDialog.this.onModify();
            }
        });
        parent.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean enable = SerialPortAddressDialog.this.tcpHistory != null && SerialPortAddressDialog.this.tcpHistory.contains(SerialPortAddressDialog.this.data);
                SerialPortAddressDialog.this.setTTYControlEnabled(!enable);
                SerialPortAddressDialog.this.setTCPControlEnabled(enable);
                SerialPortAddressDialog.this.onModify();
            }
        });
        SerialPortAddressDialog.applyDialogFont((Control)ttyComp);
        SerialPortAddressDialog.applyDialogFont((Control)tcpComp);
        this.setupData();
    }

    private void setupData() {
        this.setTTYControlEnabled(true);
        this.setTCPControlEnabled(false);
        if (this.ttyHistory != null && !this.ttyHistory.isEmpty()) {
            for (String tty : this.ttyHistory) {
                if (tty != null && tty.trim().length() > 0 && this.ttyControl.indexOf(tty) == -1) {
                    this.ttyControl.add(tty.trim());
                }
                if (tty == null || !tty.equals(this.data)) continue;
                this.ttyControl.setText(tty.trim());
            }
        }
        if (this.tcpHistory != null && !this.tcpHistory.isEmpty()) {
            for (String tcp : this.tcpHistory) {
                String[] data = tcp.split(":");
                if (data.length > 1 && data[1] != null && data[1].trim().length() > 0 && this.ttyControl.indexOf(data[1]) == -1) {
                    this.addressControl.add(data[1].trim());
                }
                if (data.length > 2 && data[2] != null && data[2].trim().length() > 0 && this.ttyControl.indexOf(data[2]) == -1) {
                    this.addressControl.add(data[2].trim());
                }
                if (!tcp.equals(this.data)) continue;
                this.setTTYControlEnabled(false);
                this.setTCPControlEnabled(true);
                if (data.length > 1) {
                    this.addressControl.setText(data[1]);
                }
                if (data.length <= 2) continue;
                this.portControl.setText(data[2]);
            }
        }
        this.onModify();
    }

    void setTTYControlEnabled(boolean enable) {
        this.ttyControlSelector.setSelection(enable);
        this.ttyControl.setEnabled(enable);
    }

    void setTCPControlEnabled(boolean enable) {
        this.tcpControlSelector.setSelection(enable);
        this.addressControl.setEnabled(enable);
        this.portControl.setEnabled(enable);
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.setButtonEnabled(0, false);
        return control;
    }

    protected void okPressed() {
        this.data = this.ttyControlSelector.getSelection() ? this.ttyControl.getText() : "tcp:" + this.addressControl.getText() + ":" + this.portControl.getText();
        super.okPressed();
    }

    protected void onModify() {
        this.setMessage(null);
        boolean valid = false;
        if (this.ttyControlSelector.getSelection()) {
            valid = this.isTtyControlValid();
        } else {
            valid = this.isAddressControlValid();
            valid &= this.isPortControlValid();
        }
        if (this.getMessage() == null) {
            this.setDefaultMessage(Messages.SerialPortAddressDialog_message, 1);
        }
        this.setButtonEnabled(0, valid);
    }

    protected boolean isTtyControlValid() {
        if (this.ttyControl == null || this.ttyControl.isDisposed()) {
            return false;
        }
        boolean valid = true;
        String m = null;
        int mt = 0;
        String newText = this.ttyControl.getText();
        Assert.isNotNull((Object)newText);
        if (newText.trim().length() > 0) {
            Matcher matcher = validCharacters.matcher(newText);
            if (!matcher.matches()) {
                m = Messages.SerialLinePanel_error_invalidCharactes;
                mt = 3;
            }
        } else {
            m = Messages.SerialLinePanel_error_emptyHostTTYDevice;
            mt = 1;
        }
        boolean bl = valid = mt != 3;
        if (mt > this.getMessageType()) {
            this.setMessage(m, mt);
        }
        return valid;
    }

    protected boolean isAddressControlValid() {
        if (this.addressControl == null || this.addressControl.isDisposed()) {
            return false;
        }
        boolean valid = true;
        String m = null;
        int mt = 0;
        String ipOrHostName = this.addressControl.getText();
        if (ipOrHostName == null || ipOrHostName.trim().length() == 0) {
            m = Messages.SerialPortAddressDialog_Information_MissingTargetNameAddress;
            mt = 1;
        } else if ((ipOrHostName = ipOrHostName.trim()).matches(IP_CHARACTERS_REGEX)) {
            if (!ipOrHostName.matches(IP_REGEX)) {
                m = Messages.SerialPortAddressDialog_Error_InvalidTargetIpAddress;
                mt = 3;
            }
        } else if (ipOrHostName.matches(NAME_CHARACTERS_REGEX)) {
            if (!ipOrHostName.matches(NAME_REGEX)) {
                m = Messages.SerialPortAddressDialog_Error_InvalidTargetNameAddress;
                mt = 3;
            }
        } else {
            m = Messages.SerialPortAddressDialog_Error_InvalidTargetNameAddress;
            mt = 3;
        }
        boolean bl = valid = mt != 3;
        if (mt > this.getMessageType()) {
            this.setMessage(m, mt);
        }
        return valid;
    }

    protected boolean isPortControlValid() {
        if (this.portControl == null || this.portControl.isDisposed()) {
            return false;
        }
        boolean valid = true;
        String m = null;
        int mt = 0;
        String newText = this.portControl.getText();
        Assert.isNotNull((Object)newText);
        if (newText.trim().length() > 0) {
            if (!newText.matches("([0-9]{0,5})|(0((x|X)[0-9a-fA-F]{0,4})?)")) {
                m = Messages.SerialPortAddressDialog_Error_InvalidPort;
                mt = 3;
            } else {
                try {
                    int value = Integer.decode(newText);
                    if (value < 0 || value > 65535) {
                        m = Messages.SerialPortAddressDialog_Error_InvalidPortRange;
                        mt = 3;
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            m = Messages.SerialPortAddressDialog_Information_MissingPort;
            mt = 1;
        }
        boolean bl = valid = mt != 3;
        if (mt > this.getMessageType()) {
            this.setMessage(m, mt);
        }
        return valid;
    }

    public String getData() {
        return this.data;
    }

    protected void dispose() {
        this.message = null;
        this.messageType = 0;
        this.errorMessage = null;
        this.title = null;
        this.defaultMessage = null;
        this.defaultMessageType = 0;
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    public void setButtonEnabled(int buttonId, boolean enabled) {
        Button button = this.getButton(buttonId);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public void setDialogTitle(String title) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().setText(title);
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        super.setTitle(newTitle);
    }

    public void setDefaultMessage(String message, int type) {
        this.defaultMessage = message;
        this.defaultMessageType = type;
        if (!this.isMessageSet() && this.getContents() != null) {
            super.setMessage(this.defaultMessage, this.defaultMessageType);
        }
    }

    public void setMessage(String newMessage, int newType) {
        this.message = newMessage;
        this.messageType = newType;
        if (this.getContents() != null) {
            super.setMessage(this.message != null ? this.message : this.defaultMessage, this.message != null ? this.messageType : this.defaultMessageType);
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        this.errorMessage = newErrorMessage;
        super.setErrorMessage(newErrorMessage);
    }

    public String getMessage() {
        return this.errorMessage != null ? this.errorMessage : this.message;
    }

    public int getMessageType() {
        return this.errorMessage != null ? 3 : this.messageType;
    }

    public boolean isMessageSet() {
        return this.errorMessage != null || this.message != null;
    }
}

