/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.core.terminals.activator.CoreBundleActivator;
import org.eclipse.tcf.te.core.terminals.interfaces.ITerminalService;
import org.eclipse.tcf.te.core.terminals.interfaces.ITerminalTabListener;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.tcf.te.ui.terminals.manager.ConsoleManager;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.ui.PlatformUI;

public class TerminalService
implements ITerminalService {
    private final ListenerList terminalTabListeners = new ListenerList();
    private boolean fRestoringView;
    public static final int TAB_DISPOSED = 1;

    public final void addTerminalTabListener(ITerminalTabListener listener) {
        Assert.isNotNull((Object)listener);
        this.terminalTabListeners.add((Object)listener);
    }

    public final void removeTerminalTabListener(ITerminalTabListener listener) {
        Assert.isNotNull((Object)listener);
        this.terminalTabListeners.remove((Object)listener);
    }

    public final void fireTerminalTabEvent(final int event, final Object source, final Object data) {
        Assert.isNotNull((Object)source);
        if (this.terminalTabListeners.isEmpty()) {
            return;
        }
        Object[] l = this.terminalTabListeners.getListeners();
        int i = 0;
        while (i < l.length) {
            final ITerminalTabListener listener = (ITerminalTabListener)l[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    switch (event) {
                        case 1: {
                            listener.terminalTabDisposed(source, data);
                        }
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    protected final void executeServiceOperation(Map<String, Object> properties, final TerminalServiceRunnable runnable, final ITerminalService.Done done) {
        Assert.isNotNull(properties);
        Assert.isNotNull((Object)runnable);
        String id = (String)properties.get("id");
        String secondaryId = (String)properties.get("secondaryId");
        String title = (String)properties.get("title");
        Object data = properties.get("data");
        id = this.normalizeId(id, data);
        title = this.normalizeTitle(title, data);
        final ITerminalConnector connector = this.createTerminalConnector(properties);
        if (connector == null) {
            if (done != null) {
                IllegalArgumentException e = new IllegalArgumentException(Messages.TerminalService_error_cannotCreateConnector);
                done.done((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e));
            }
            return;
        }
        final String finId = id;
        final String finSecondaryId = secondaryId;
        final String finTitle = title;
        final Object finData = data;
        if (!runnable.isExecuteAsync()) {
            runnable.run(finId, finSecondaryId, finTitle, connector, finData, done);
        } else {
            try {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        runnable.run(finId, finSecondaryId, finTitle, connector, finData, done);
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    protected String normalizeId(String id, Object data) {
        return id != null ? id : "org.eclipse.tcf.te.ui.terminals.TerminalsView";
    }

    protected String normalizeTitle(String title, Object data) {
        if (title != null) {
            return title;
        }
        return Messages.TerminalService_defaultTitle;
    }

    protected ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        ILauncherDelegate delegate;
        Assert.isNotNull(properties);
        ITerminalConnector connector = null;
        String delegateId = (String)properties.get("delegateId");
        if (delegateId != null && (delegate = LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false)) != null) {
            connector = delegate.createTerminalConnector(properties);
        }
        return connector;
    }

    public void openConsole(final Map<String, Object> properties, ITerminalService.Done done) {
        Assert.isNotNull(properties);
        final boolean restoringView = this.fRestoringView;
        this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public void run(final String id, final String secondaryId, final String title, final ITerminalConnector connector, final Object data, final ITerminalService.Done done) {
                if (restoringView) {
                    this.doRun(id, secondaryId, title, connector, data, done);
                } else {
                    TerminalService.this.fRestoringView = true;
                    ConsoleManager.getInstance().showConsoleView(id, secondaryId);
                    TerminalService.this.fRestoringView = false;
                    try {
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                this.doRun(id, secondaryId, title, connector, data, done);
                            }
                        });
                    }
                    catch (Exception exception) {}
                }
            }

            public void doRun(String id, String secondaryId, String title, ITerminalConnector connector, Object data, ITerminalService.Done done) {
                CTabItem item;
                String encoding = (String)properties.get("encoding");
                HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
                flags.put("activate", Boolean.TRUE);
                if (properties.get("terminal.forceNew") instanceof Boolean) {
                    flags.put("terminal.forceNew", (Boolean)properties.get("terminal.forceNew"));
                }
                if ((item = secondaryId != null ? ConsoleManager.getInstance().openConsole(id, secondaryId, title, encoding, connector, data, flags) : ConsoleManager.getInstance().openConsole(id, title, encoding, connector, data, flags)) != null && !item.isDisposed()) {
                    item.setData("properties", (Object)properties);
                }
                if (done != null) {
                    done.done(Status.OK_STATUS);
                }
            }
        }, done);
    }

    public void closeConsole(Map<String, Object> properties, ITerminalService.Done done) {
        Assert.isNotNull(properties);
        this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public void run(String id, String secondaryId, String title, ITerminalConnector connector, Object data, ITerminalService.Done done) {
                ConsoleManager.getInstance().closeConsole(id, title, connector, data);
                if (done != null) {
                    done.done(Status.OK_STATUS);
                }
            }
        }, done);
    }

    public void terminateConsole(Map<String, Object> properties, ITerminalService.Done done) {
        Assert.isNotNull(properties);
        this.executeServiceOperation(properties, new TerminalServiceRunnable(){

            @Override
            public void run(String id, String secondaryId, String title, ITerminalConnector connector, Object data, ITerminalService.Done done) {
                ConsoleManager.getInstance().terminateConsole(id, title, connector, data);
                if (done != null) {
                    done.done(Status.OK_STATUS);
                }
            }
        }, done);
    }

    protected static abstract class TerminalServiceRunnable {
        protected TerminalServiceRunnable() {
        }

        public abstract void run(String var1, String var2, String var3, ITerminalConnector var4, Object var5, ITerminalService.Done var6);

        public boolean isExecuteAsync() {
            return true;
        }
    }
}

