/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.streams;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.core.terminals.TerminalServiceFactory;
import org.eclipse.tcf.te.core.terminals.interfaces.ITerminalService;
import org.eclipse.tcf.te.core.terminals.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanel;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanelContainer;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.launcher.AbstractLauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.streams.StreamsSettings;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;

public class StreamsLauncherDelegate
extends AbstractLauncherDelegate {
    @Override
    public boolean needsUserConfiguration() {
        return false;
    }

    @Override
    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return null;
    }

    @Override
    public void execute(Map<String, Object> properties, ITerminalService.Done done) {
        Assert.isNotNull(properties);
        ITerminalService terminal = TerminalServiceFactory.getService();
        if (terminal != null) {
            terminal.openConsole(properties, done);
        }
    }

    @Override
    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = "org.eclipse.tcf.te.ui.terminals.StreamsConnector";
        }
        OutputStream stdin = (OutputStream)properties.get("streams.stdin");
        InputStream stdout = (InputStream)properties.get("streams.stdout");
        InputStream stderr = (InputStream)properties.get("streams.stderr");
        Object value = properties.get("localEcho");
        boolean localEcho = value instanceof Boolean ? (Boolean)value : false;
        String lineSeparator = (String)properties.get("lineSeparator");
        ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stdoutListeners");
        ITerminalServiceOutputStreamMonitorListener[] stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stderrListeners");
        SettingsStore store = new SettingsStore();
        StreamsSettings streamsSettings = new StreamsSettings();
        streamsSettings.setStdinStream(stdin);
        streamsSettings.setStdoutStream(stdout);
        streamsSettings.setStderrStream(stderr);
        streamsSettings.setLocalEcho(localEcho);
        streamsSettings.setLineSeparator(lineSeparator);
        streamsSettings.setStdOutListeners(stdoutListeners);
        streamsSettings.setStdErrListeners(stderrListeners);
        streamsSettings.save(store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

