/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.local.showin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.te.ui.terminals.local.showin.ExternalExecutablesManager;
import org.eclipse.ui.IStartup;

public class ExternalExecutablesInitializer
implements IStartup {
    public void earlyStartup() {
        if ("win32".equals(Platform.getOS())) {
            String gitPath = null;
            String iconPath = null;
            String path = System.getenv("PATH");
            if (path != null) {
                StringTokenizer tokenizer = new StringTokenizer(path, ";");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    File f = new File(token, "git.exe");
                    if (!f.canRead()) continue;
                    File f2 = new File(f.getParentFile().getParentFile(), "bin/sh.exe");
                    if (f2.canExecute()) {
                        gitPath = f2.getAbsolutePath();
                    }
                    if (!(f2 = new File(f.getParentFile().getParentFile(), "etc/git.ico")).canRead()) break;
                    iconPath = f2.getAbsolutePath();
                    break;
                }
            }
            if (gitPath != null) {
                List<Map<String, String>> l = ExternalExecutablesManager.load();
                if (l == null) {
                    l = new ArrayList<Map<String, String>>();
                }
                Map<Object, Object> m = null;
                for (Map<String, String> candidate : l) {
                    String name = candidate.get("Name");
                    if (!"Git Bash".equals(name)) continue;
                    m = candidate;
                    break;
                }
                if (m == null) {
                    m = new HashMap<String, String>();
                    m.put("Name", "Git Bash");
                    m.put("Path", gitPath);
                    m.put("Args", "--login -i");
                    if (iconPath != null) {
                        m.put("Icon", iconPath);
                    }
                    m.put("Translate", Boolean.TRUE.toString());
                    l.add(m);
                    ExternalExecutablesManager.save(l);
                }
            }
        }
    }
}

