/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.local.showin.preferences;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.ui.terminals.controls.NoteCompositeHelper;
import org.eclipse.tcf.te.ui.terminals.local.activator.UIPlugin;
import org.eclipse.tcf.te.ui.terminals.local.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.local.showin.ExternalExecutablesDialog;
import org.eclipse.tcf.te.ui.terminals.local.showin.ExternalExecutablesManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class PreferencePage
extends org.eclipse.jface.preference.PreferencePage
implements IWorkbenchPreferencePage {
    TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    Combo workingDir;
    private Button browseButton;
    private Button variablesButton;
    private boolean hasVariablesButton = false;
    Text command;
    private Button commandBrowseButton;
    private Text arguments;
    final List<Map<String, String>> executables = new ArrayList<Map<String, String>>();
    final Map<String, Image> images = new HashMap<String, Image>();
    static final Object[] NO_ELEMENTS = new Object[0];

    public void init(IWorkbench workbench) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.debug.ui");
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16) {
            this.hasVariablesButton = true;
        }
    }

    protected Control createContents(final Composite parent) {
        String initialCwd;
        Group group;
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(4, 1, true, false);
        panel.setLayoutData((Object)layoutData);
        Label label = new Label(panel, 256);
        label.setText(Messages.PreferencePage_label);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (!"win32".equals(Platform.getOS())) {
            group = new Group(panel, 0);
            group.setText(Messages.PreferencePage_command_label);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(4, 1, true, false));
            this.command = new Text((Composite)group, 2052);
            this.command.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.command.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    boolean valid = true;
                    String message = null;
                    String text = PreferencePage.this.command.getText();
                    if (text != null && !"".equals(text.trim())) {
                        Path p = new Path(text.trim());
                        boolean bl = valid = p.toFile().isFile() && p.toFile().canRead() && p.toFile().canExecute();
                        if (!valid) {
                            message = Messages.PreferencePage_command_invalid;
                        }
                    }
                    PreferencePage.this.setValid(valid);
                    PreferencePage.this.setErrorMessage(message);
                }
            });
            this.commandBrowseButton = new Button((Composite)group, 8);
            this.commandBrowseButton.setText(Messages.PreferencePage_command_button_browse);
            layoutData = new GridData(4, 0x1000000, false, false);
            layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)14);
            this.commandBrowseButton.setLayoutData((Object)layoutData);
            this.commandBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selected;
                    FileDialog dialog = new FileDialog(parent.getShell(), 4096);
                    String text = PreferencePage.this.command.getText();
                    if (text != null && !"".equals(text.trim())) {
                        Path p = new Path(text);
                        if (p.toFile().isFile() || !p.toFile().exists()) {
                            dialog.setFilterPath(p.removeLastSegments(1).toOSString());
                            dialog.setFileName(p.lastSegment());
                        } else if (p.toFile().isDirectory()) {
                            dialog.setFilterPath(p.toOSString());
                        }
                    }
                    if ((selected = dialog.open()) != null) {
                        Path sp = new Path(selected);
                        PreferencePage.this.command.setText(sp.toOSString());
                    }
                }
            });
            String cmd = UIPlugin.getScopedPreferences().getString("terminals.localTerminalDefaultShellUnix");
            if (cmd != null && !"".equals(cmd)) {
                this.command.setText(new Path(cmd).toOSString());
            }
            Composite argsPanel = new Composite((Composite)group, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            argsPanel.setLayout((Layout)layout);
            layoutData = new GridData(4, 1, true, false);
            layoutData.horizontalSpan = 2;
            argsPanel.setLayoutData((Object)layoutData);
            label = new Label(argsPanel, 0);
            label.setText(Messages.PreferencePage_command_arguments_label);
            this.arguments = new Text(argsPanel, 2052);
            this.arguments.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            String args = UIPlugin.getScopedPreferences().getString("terminals.localTerminalDefaultShellUnixArgs");
            if (args != null && !"".equals(args)) {
                this.arguments.setText(args);
            }
            NoteCompositeHelper.createNoteComposite((Font)group.getFont(), (Composite)group, (String)Messages.PreferencePage_command_note_label, (String)Messages.PreferencePage_command_note_text);
        }
        group = new Group(panel, 0);
        group.setText(Messages.PreferencePage_workingDir_label);
        group.setLayout((Layout)new GridLayout(this.hasVariablesButton ? 3 : 2, false));
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.workingDir = new Combo((Composite)group, 4);
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
        if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16) {
            this.workingDir.setItems(new String[]{Messages.PreferencePage_workingDir_userhome_label, Messages.PreferencePage_workingDir_eclipsehome_label, Messages.PreferencePage_workingDir_eclipsews_label});
        } else {
            this.workingDir.setItems(new String[]{Messages.PreferencePage_workingDir_userhome_label, Messages.PreferencePage_workingDir_eclipsehome_label});
        }
        this.workingDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.workingDir.select(0);
        this.workingDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                String message = null;
                String text = PreferencePage.this.workingDir.getText();
                if (!(text == null || "".equals(text.trim()) || Messages.PreferencePage_workingDir_userhome_label.equals(text) || Messages.PreferencePage_workingDir_eclipsehome_label.equals(text) || Messages.PreferencePage_workingDir_eclipsews_label.equals(text))) {
                    try {
                        IStringVariableManager vm = VariablesPlugin.getDefault().getStringVariableManager();
                        String resolved = vm.performStringSubstitution(text.trim());
                        Path p = new Path(resolved);
                        boolean bl = valid = p.toFile().canRead() && p.toFile().isDirectory();
                        if (!valid) {
                            message = Messages.PreferencePage_workingDir_invalid;
                        }
                    }
                    catch (CoreException ex) {
                        valid = false;
                        message = ex.getLocalizedMessage();
                    }
                }
                PreferencePage.this.setValid(valid);
                PreferencePage.this.setErrorMessage(message);
            }
        });
        this.browseButton = new Button((Composite)group, 8);
        this.browseButton.setText(Messages.PreferencePage_workingDir_button_browse);
        layoutData = new GridData(4, 0x1000000, false, false);
        layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)14);
        this.browseButton.setLayoutData((Object)layoutData);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog;
                IPath ew;
                Path eh;
                Path uh;
                block21: {
                    Bundle bundle;
                    String eclipseHomeLocation;
                    uh = null;
                    eh = null;
                    ew = null;
                    String home = System.getProperty("user.home");
                    if (home != null && !"".equals(home)) {
                        uh = new Path(home);
                    }
                    if ((eclipseHomeLocation = System.getProperty("eclipse.home.location")) != null) {
                        try {
                            URI uri = URIUtil.fromString((String)eclipseHomeLocation);
                            File f = URIUtil.toFile((URI)uri);
                            eh = new Path(f.getAbsolutePath());
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                    if ((bundle = Platform.getBundle((String)"org.eclipse.core.resources")) != null && bundle.getState() != 1 && bundle.getState() != 16 && ResourcesPlugin.getWorkspace() != null && ResourcesPlugin.getWorkspace().getRoot() != null && ResourcesPlugin.getWorkspace().getRoot().getLocation() != null) {
                        ew = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                    }
                    dialog = new DirectoryDialog(parent.getShell(), 4096);
                    String text = PreferencePage.this.workingDir.getText();
                    if (Messages.PreferencePage_workingDir_userhome_label.equals(text)) {
                        dialog.setFilterPath(uh.toOSString());
                    } else if (Messages.PreferencePage_workingDir_eclipsehome_label.equals(text)) {
                        dialog.setFilterPath(eh.toOSString());
                    } else if (Messages.PreferencePage_workingDir_eclipsews_label.equals(text)) {
                        dialog.setFilterPath(ew.toOSString());
                    } else if (text != null && !"".equals(text.trim())) {
                        try {
                            IStringVariableManager vm = VariablesPlugin.getDefault().getStringVariableManager();
                            String resolved = vm.performStringSubstitution(text.trim());
                            dialog.setFilterPath(resolved);
                        }
                        catch (CoreException ex) {
                            if (!Platform.inDebugMode()) break block21;
                            UIPlugin.getDefault().getLog().log(ex.getStatus());
                        }
                    }
                }
                String selected = dialog.open();
                if (selected != null) {
                    Path sp = new Path(selected);
                    if (uh.equals((Object)sp)) {
                        PreferencePage.this.workingDir.select(0);
                    } else if (eh.equals((Object)sp)) {
                        PreferencePage.this.workingDir.select(1);
                    } else if (ew.equals((Object)sp)) {
                        PreferencePage.this.workingDir.select(2);
                    } else {
                        PreferencePage.this.workingDir.setText(sp.toOSString());
                    }
                }
            }
        });
        if (this.hasVariablesButton) {
            this.variablesButton = new Button((Composite)group, 8);
            this.variablesButton.setText(Messages.PreferencePage_workingDir_button_variables);
            layoutData = new GridData(4, 0x1000000, false, false);
            layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)14);
            this.variablesButton.setLayoutData((Object)layoutData);
            this.variablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(PreferencePage.this.getShell());
                    dialog.open();
                    String expression = dialog.getVariableExpression();
                    if (expression != null) {
                        if ("${eclipse_home}".equals(expression)) {
                            PreferencePage.this.workingDir.select(1);
                        } else if ("${workspace_loc}".equals(expression)) {
                            PreferencePage.this.workingDir.select(2);
                        } else {
                            PreferencePage.this.workingDir.setText(expression);
                        }
                    }
                }
            });
        }
        if ((initialCwd = UIPlugin.getScopedPreferences().getString("terminals.localTerminalInitialCwd")) == null || "userhome".equals(initialCwd) || "".equals(initialCwd.trim())) {
            this.workingDir.select(0);
        } else if ("eclipsehome".equals(initialCwd) || "${eclipse_home}".equals(initialCwd)) {
            this.workingDir.select(1);
        } else if ("eclipsews".equals(initialCwd) || "${workspace_loc}".equals(initialCwd)) {
            this.workingDir.select(2);
        } else {
            this.workingDir.setText(new Path(initialCwd).toOSString());
        }
        NoteCompositeHelper.createNoteComposite((Font)group.getFont(), (Composite)group, (String)Messages.PreferencePage_workingDir_note_label, (String)Messages.PreferencePage_workingDir_note_text);
        group = new Group(panel, 0);
        group.setText(Messages.PreferencePage_executables_label);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        this.viewer = new TableViewer((Composite)group, 68354);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.PreferencePage_executables_column_name_label);
        column = new TableColumn(table, 16384);
        column.setText(Messages.PreferencePage_executables_column_path_label);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(35));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(65));
        table.setLayout((Layout)tableLayout);
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)10);
        table.setLayoutData((Object)layoutData);
        Composite buttonsPanel = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonsPanel.setLayout((Layout)layout);
        buttonsPanel.setLayoutData((Object)new GridData(16384, 1, false, false));
        this.addButton = new Button(buttonsPanel, 8);
        this.addButton.setText(Messages.PreferencePage_executables_button_add_label);
        layoutData = new GridData(4, 0x1000000, false, false);
        layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)10);
        this.addButton.setLayoutData((Object)layoutData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Map<String, String> executableData;
                ExternalExecutablesDialog dialog = new ExternalExecutablesDialog(PreferencePage.this.getShell(), false);
                if (dialog.open() == 0 && (executableData = dialog.getExecutableData()) != null && !PreferencePage.this.executables.contains(executableData)) {
                    PreferencePage.this.executables.add(executableData);
                    PreferencePage.this.viewer.refresh();
                }
            }
        });
        this.editButton = new Button(buttonsPanel, 8);
        this.editButton.setText(Messages.PreferencePage_executables_button_edit_label);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)10);
        this.editButton.setLayoutData((Object)layoutData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object element;
                ISelection s = PreferencePage.this.viewer.getSelection();
                if (s instanceof IStructuredSelection && !s.isEmpty() && (element = ((IStructuredSelection)s).getFirstElement()) instanceof Map) {
                    Map<String, String> executableData;
                    Map m = (Map)element;
                    ExternalExecutablesDialog dialog = new ExternalExecutablesDialog(PreferencePage.this.getShell(), true);
                    dialog.setExecutableData(m);
                    if (dialog.open() == 0 && (executableData = dialog.getExecutableData()) != null) {
                        m.clear();
                        m.putAll(executableData);
                        PreferencePage.this.viewer.refresh();
                    }
                }
            }
        });
        this.removeButton = new Button(buttonsPanel, 8);
        this.removeButton.setText(Messages.PreferencePage_executables_button_remove_label);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)10);
        this.removeButton.setLayoutData((Object)layoutData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection s = PreferencePage.this.viewer.getSelection();
                if (s instanceof IStructuredSelection && !s.isEmpty()) {
                    for (Object element : (IStructuredSelection)s) {
                        if (element instanceof Map) {
                            Map m = (Map)element;
                            PreferencePage.this.executables.remove(m);
                        }
                        PreferencePage.this.viewer.refresh();
                    }
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List && !((List)inputElement).isEmpty()) {
                    return ((List)inputElement).toArray();
                }
                return NO_ELEMENTS;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Map) {
                    Map m = (Map)element;
                    switch (columnIndex) {
                        case 0: {
                            return (String)m.get("Name");
                        }
                        case 1: {
                            return (String)m.get("Path");
                        }
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                Image i = null;
                if (element instanceof Map) {
                    switch (columnIndex) {
                        case 0: {
                            ImageData id;
                            Map m = (Map)element;
                            String icon = (String)m.get("Icon");
                            if (icon == null || (i = PreferencePage.this.images.get(icon)) != null || (id = ExternalExecutablesManager.loadImage(icon)) == null) break;
                            ImageDescriptor d = ImageDescriptor.createFromImageData((ImageData)id);
                            if (d != null) {
                                i = d.createImage();
                            }
                            if (i == null) break;
                            PreferencePage.this.images.put(icon, i);
                            break;
                        }
                    }
                }
                return i;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }
        });
        List<Map<String, String>> l = ExternalExecutablesManager.load();
        if (l != null) {
            this.executables.addAll(l);
        }
        this.viewer.setInput(this.executables);
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PreferencePage.this.updateButtons();
            }
        });
        this.updateButtons();
        gc.dispose();
        return panel;
    }

    protected void updateButtons() {
        if (this.viewer != null) {
            this.addButton.setEnabled(true);
            ISelection selection = this.viewer.getSelection();
            boolean hasSelection = selection != null && !selection.isEmpty();
            int count = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).size() : 0;
            this.editButton.setEnabled(hasSelection && count == 1);
            this.removeButton.setEnabled(hasSelection && count > 0);
        } else {
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    protected void performDefaults() {
        String initialCwd;
        if (!"win32".equals(Platform.getOS())) {
            this.command.setText("");
            this.arguments.setText("");
        }
        if ((initialCwd = UIPlugin.getScopedPreferences().getDefaultString("terminals.localTerminalInitialCwd")) == null || "userhome".equals(initialCwd) || "".equals(initialCwd.trim())) {
            this.workingDir.select(0);
        } else if ("eclipsehome".equals(initialCwd) || "${eclipse_home}".equals(initialCwd)) {
            this.workingDir.select(1);
        } else if ("eclipsews".equals(initialCwd) || "${workspace_loc}".equals(initialCwd)) {
            this.workingDir.select(2);
        } else {
            this.workingDir.setText(new Path(initialCwd).toOSString());
        }
        this.executables.clear();
        List<Map<String, String>> l = ExternalExecutablesManager.load();
        if (l != null) {
            this.executables.addAll(l);
        }
        this.viewer.refresh();
        super.performDefaults();
    }

    public boolean performOk() {
        block9: {
            String text;
            if (!"win32".equals(Platform.getOS())) {
                text = this.command.getText();
                Path p = new Path(text.trim());
                UIPlugin.getScopedPreferences().putString("terminals.localTerminalDefaultShellUnix", p.toFile().isFile() && p.toFile().canRead() && p.toFile().canExecute() ? p.toOSString() : null);
                text = this.arguments.getText();
                UIPlugin.getScopedPreferences().putString("terminals.localTerminalDefaultShellUnixArgs", !"".equals(text.trim()) ? text.trim() : null);
            }
            if ((text = this.workingDir.getText()) == null || Messages.PreferencePage_workingDir_userhome_label.equals(text) || "".equals(text.trim())) {
                UIPlugin.getScopedPreferences().putString("terminals.localTerminalInitialCwd", null);
            } else if (Messages.PreferencePage_workingDir_eclipsehome_label.equals(text)) {
                UIPlugin.getScopedPreferences().putString("terminals.localTerminalInitialCwd", "eclipsehome");
            } else if (Messages.PreferencePage_workingDir_eclipsews_label.equals(text)) {
                UIPlugin.getScopedPreferences().putString("terminals.localTerminalInitialCwd", "eclipsews");
            } else {
                try {
                    IStringVariableManager vm = VariablesPlugin.getDefault().getStringVariableManager();
                    String resolved = vm.performStringSubstitution(text.trim());
                    Path p = new Path(resolved);
                    UIPlugin.getScopedPreferences().putString("terminals.localTerminalInitialCwd", p.toFile().canRead() && p.toFile().isDirectory() ? text.trim() : null);
                }
                catch (CoreException e) {
                    if (!Platform.inDebugMode()) break block9;
                    UIPlugin.getDefault().getLog().log(e.getStatus());
                }
            }
        }
        ExternalExecutablesManager.save(this.executables);
        return super.performOk();
    }

    public void dispose() {
        for (Image i : this.images.values()) {
            i.dispose();
        }
        this.images.clear();
        super.dispose();
    }
}

