/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.process;

import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.core.terminals.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;

public class ProcessSettings {
    private String image;
    private String arguments;
    private Process process;
    private PTY pty;
    private boolean localEcho = !PTY.isSupported();
    private String lineSeparator = null;
    private ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = null;
    private ITerminalServiceOutputStreamMonitorListener[] stderrListeners = null;
    private String workingDir;
    private String[] environment;
    private boolean mergeWithNativeEnvironment = true;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setPTY(PTY pty) {
        this.pty = pty;
        if (pty == null) {
            this.setLocalEcho(true);
        }
    }

    public PTY getPTY() {
        return this.pty;
    }

    public void setLocalEcho(boolean value) {
        this.localEcho = value;
    }

    public boolean isLocalEcho() {
        return this.localEcho;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setStdOutListeners(ITerminalServiceOutputStreamMonitorListener[] listeners) {
        this.stdoutListeners = listeners;
    }

    public ITerminalServiceOutputStreamMonitorListener[] getStdOutListeners() {
        return this.stdoutListeners;
    }

    public void setStdErrListeners(ITerminalServiceOutputStreamMonitorListener[] listeners) {
        this.stderrListeners = listeners;
    }

    public ITerminalServiceOutputStreamMonitorListener[] getStdErrListeners() {
        return this.stderrListeners;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public String[] getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String[] environment) {
        this.environment = environment;
    }

    public boolean isMergeWithNativeEnvironment() {
        return this.mergeWithNativeEnvironment;
    }

    public void setMergeWithNativeEnvironment(boolean value) {
        this.mergeWithNativeEnvironment = value;
    }

    public void load(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        this.image = store.get("Path", null);
        this.arguments = store.get("Arguments", null);
        this.localEcho = Boolean.parseBoolean(store.get("LocalEcho", Boolean.FALSE.toString()));
        this.mergeWithNativeEnvironment = Boolean.parseBoolean(store.get("MergeWithNativeEnvironment", Boolean.FALSE.toString()));
        this.lineSeparator = store.get("LineSeparator", null);
        this.workingDir = store.get("WorkingDir", null);
        if (store instanceof SettingsStore) {
            this.process = (Process)((SettingsStore)store).getSettings().get("Process");
            this.pty = (PTY)((SettingsStore)store).getSettings().get("PTY");
            this.stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])((SettingsStore)store).getSettings().get("StdOutListeners");
            this.stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])((SettingsStore)store).getSettings().get("StdErrListeners");
            this.environment = (String[])((SettingsStore)store).getSettings().get("Environment");
        }
    }

    public void save(ISettingsStore store) {
        Assert.isNotNull((Object)store);
        store.put("Path", this.image);
        store.put("Arguments", this.arguments);
        store.put("LocalEcho", Boolean.toString(this.localEcho));
        store.put("MergeWithNativeEnvironment", Boolean.toString(this.mergeWithNativeEnvironment));
        store.put("LineSeparator", this.lineSeparator);
        store.put("WorkingDir", this.workingDir);
        if (store instanceof SettingsStore) {
            ((SettingsStore)store).getSettings().put("Process", this.process);
            ((SettingsStore)store).getSettings().put("PTY", this.pty);
            ((SettingsStore)store).getSettings().put("StdOutListeners", this.stdoutListeners);
            ((SettingsStore)store).getSettings().put("StdErrListeners", this.stderrListeners);
            ((SettingsStore)store).getSettings().put("Environment", this.environment);
        }
    }
}

