/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.rse.internal;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.terminals.interfaces.ILauncherDelegate;
import org.eclipse.tcf.te.ui.terminals.internal.dialogs.LaunchTerminalSettingsDialog;
import org.eclipse.tcf.te.ui.terminals.launcher.LauncherDelegateManager;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchTerminalHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof IRSEModelObject || element instanceof IRemoteFile)) {
            IHost host = null;
            if (element instanceof IHost) {
                host = (IHost)element;
            }
            if (host == null && element instanceof ISubSystem) {
                host = ((ISubSystem)element).getHost();
            }
            if (host == null && element instanceof ISystemFilterReference) {
                host = ((ISystemFilterReference)element).getSubSystem().getHost();
            }
            if (host == null && element instanceof IRemoteFile) {
                host = ((IRemoteFile)element).getHost();
            }
            if (host != null) {
                Map properties;
                LaunchTerminalSettingsDialog dialog = new LaunchTerminalSettingsDialog(shell){

                    protected boolean isFiltered(ISelection selection, ILauncherDelegate delegate) {
                        Assert.isNotNull((Object)delegate);
                        return !"org.eclipse.tcf.te.ui.terminals.ssh.launcher.ssh".equals(delegate.getId());
                    }
                };
                dialog.setSelection((ISelection)new StructuredSelection((Object)host));
                if (dialog.open() == 0 && (properties = dialog.getSettings()) != null) {
                    String delegateId = (String)properties.get("delegateId");
                    Assert.isNotNull((Object)delegateId);
                    ILauncherDelegate delegate = LauncherDelegateManager.getInstance().getLauncherDelegate(delegateId, false);
                    Assert.isNotNull((Object)delegateId);
                    delegate.execute(properties, null);
                }
            }
        }
        return null;
    }
}

