/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.rse.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    private static final String[] VALID_SYSTEM_TYPES = new String[]{"org.eclipse.rse.systemtype.linux", "org.eclipse.rse.systemtype.unix", "org.eclipse.rse.systemtype.aix", "org.eclipse.rse.systemtype.ssh"};
    private static final List<String> VALID_SYSTEM_TYPES_LIST = Arrays.asList(VALID_SYSTEM_TYPES);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IHost host = null;
        if (receiver instanceof IHost) {
            host = (IHost)receiver;
        }
        if (host == null && receiver instanceof ISubSystem) {
            host = ((ISubSystem)receiver).getHost();
        }
        if (host == null && receiver instanceof ISystemFilterReference) {
            host = ((ISystemFilterReference)receiver).getSubSystem().getHost();
        }
        if (host == null && receiver instanceof IRemoteFile) {
            host = ((IRemoteFile)receiver).getHost();
        }
        if (host != null && "isVisible".equals(property) && expectedValue instanceof Boolean) {
            boolean validID;
            String systemTypeID = host.getSystemType().getId();
            boolean bl = validID = systemTypeID != null ? VALID_SYSTEM_TYPES_LIST.contains(systemTypeID) : false;
            return (Boolean)expectedValue == validID;
        }
        return false;
    }
}

