/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.internal.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.terminals.help.IContextHelpIds;
import org.eclipse.tcf.te.ui.terminals.interfaces.IConfigurationPanelContainer;
import org.eclipse.tcf.te.ui.terminals.nls.Messages;
import org.eclipse.tcf.te.ui.terminals.panels.AbstractExtendedConfigurationPanel;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EncodingSelectionDialog
extends TrayDialog {
    private String contextHelpId = IContextHelpIds.ENCODING_SELECTION_DIALOG;
    String encoding = null;
    private EncodingPanel encodingPanel = null;

    public EncodingSelectionDialog(Shell shell) {
        super(shell);
        this.setHelpAvailable(true);
    }

    protected final Control createDialogArea(Composite parent) {
        Control control;
        if (this.contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextHelpId);
        }
        if ((control = super.createDialogArea(parent)) instanceof Composite) {
            ScrolledComposite sc = new ScrolledComposite((Composite)control, 512);
            GridLayout layout = new GridLayout(1, true);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            sc.setLayout((Layout)layout);
            sc.setLayoutData((Object)new GridData(1808));
            sc.setExpandHorizontal(true);
            sc.setExpandVertical(true);
            Composite composite = new Composite((Composite)sc, 0);
            composite.setLayout((Layout)new GridLayout());
            this.createDialogAreaContent(composite);
            sc.setContent((Control)composite);
            sc.setMinSize(composite.computeSize(-1, -1));
            control = sc;
        }
        return control;
    }

    protected void createDialogAreaContent(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.setDialogTitle(Messages.EncodingSelectionDialog_title);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.encodingPanel = new EncodingPanel(null);
        this.encodingPanel.setupPanel(panel, null);
        EncodingSelectionDialog.applyDialogFont((Control)panel);
    }

    public void setDialogTitle(String title) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().setText(title);
        }
    }

    protected void okPressed() {
        if (this.encodingPanel != null) {
            this.encoding = this.encodingPanel.getEncoding();
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.encoding = null;
        super.cancelPressed();
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    protected class EncodingPanel
    extends AbstractExtendedConfigurationPanel {
        public EncodingPanel(IConfigurationPanelContainer container) {
            super(container);
        }

        @Override
        public void setupPanel(Composite parent, FormToolkit toolkit) {
            Composite panel = new Composite(parent, 0);
            panel.setLayout((Layout)new GridLayout());
            GridData data = new GridData(4, 4, true, true);
            panel.setLayoutData((Object)data);
            this.createEncodingUI(panel, false);
            if (EncodingSelectionDialog.this.encoding != null) {
                this.setEncoding(EncodingSelectionDialog.this.encoding);
            }
            this.setControl(panel);
        }

        @Override
        protected void saveSettingsForHost(boolean add) {
        }

        @Override
        protected void fillSettingsForHost(String host) {
        }

        @Override
        protected String getHostFromSettings() {
            return null;
        }

        @Override
        public String getEncoding() {
            return super.getEncoding();
        }

        @Override
        public void setEncoding(String encoding) {
            super.setEncoding(encoding);
        }
    }
}

