/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import org.eclipse.tm.internal.terminal.model.TerminalTextDataStore;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.LineSegment;
import org.eclipse.tm.terminal.model.Style;

public class TerminalTextDataWindow
implements ITerminalTextData {
    final ITerminalTextData fData;
    int fWindowStartLine;
    int fWindowSize;
    int fHeight;
    int fMaxHeight;

    public TerminalTextDataWindow(ITerminalTextData data) {
        this.fData = data;
    }

    public TerminalTextDataWindow() {
        this(new TerminalTextDataStore());
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    boolean isInWindow(int line) {
        return line >= this.fWindowStartLine && line < this.fWindowStartLine + this.fWindowSize;
    }

    public char getChar(int line, int column) {
        if (!this.isInWindow(line)) {
            return '\u0000';
        }
        return this.fData.getChar(line - this.fWindowStartLine, column);
    }

    public char[] getChars(int line) {
        if (!this.isInWindow(line)) {
            return null;
        }
        return this.fData.getChars(line - this.fWindowStartLine);
    }

    public int getHeight() {
        return this.fHeight;
    }

    public LineSegment[] getLineSegments(int line, int startCol, int numberOfCols) {
        if (!this.isInWindow(line)) {
            return new LineSegment[]{new LineSegment(startCol, new String(new char[numberOfCols]), null)};
        }
        return this.fData.getLineSegments(line - this.fWindowStartLine, startCol, numberOfCols);
    }

    public int getMaxHeight() {
        return this.fMaxHeight;
    }

    public Style getStyle(int line, int column) {
        if (!this.isInWindow(line)) {
            return null;
        }
        return this.fData.getStyle(line - this.fWindowStartLine, column);
    }

    public Style[] getStyles(int line) {
        if (!this.isInWindow(line)) {
            return null;
        }
        return this.fData.getStyles(line - this.fWindowStartLine);
    }

    public int getWidth() {
        return this.fData.getWidth();
    }

    public ITerminalTextDataSnapshot makeSnapshot() {
        throw new UnsupportedOperationException();
    }

    public void addLine() {
        if (this.fMaxHeight > 0 && this.getHeight() < this.fMaxHeight) {
            this.setDimensions(this.getHeight() + 1, this.getWidth());
        } else {
            this.scroll(0, this.getHeight(), -1);
        }
    }

    public void copy(ITerminalTextData source) {
        this.setDimensions(source.getHeight(), source.getWidth());
        int n = Math.min(this.fWindowSize, source.getHeight() - this.fWindowStartLine);
        if (n > 0) {
            this.fData.copyRange(source, this.fWindowStartLine, 0, n);
        }
    }

    public void copyRange(ITerminalTextData source, int sourceStartLine, int destStartLine, int length) {
        int n = length;
        int dStart = destStartLine - this.fWindowStartLine;
        int sStart = sourceStartLine;
        if (dStart < 0) {
            n += dStart;
            sStart -= dStart;
            dStart = 0;
        }
        if ((n = Math.min(n, this.fWindowSize)) > 0) {
            this.fData.copyRange(source, sStart, dStart, n);
        }
    }

    public void copyLine(ITerminalTextData source, int sourceLine, int destLine) {
        if (this.isInWindow(destLine)) {
            this.fData.copyLine(source, sourceLine, destLine - this.fWindowStartLine);
        }
    }

    public void scroll(int startLine, int size, int shift) {
        assert (startLine >= 0 && startLine + size <= this.fHeight || this.throwRuntimeException());
        int n = size;
        int start = startLine - this.fWindowStartLine;
        if (start < 0) {
            n += start;
            start = 0;
        }
        if ((n = Math.min(n, this.fWindowSize - start)) > 0) {
            this.fData.scroll(start, n, shift);
        }
    }

    public void setChar(int line, int column, char c, Style style) {
        if (!this.isInWindow(line)) {
            return;
        }
        this.fData.setChar(line - this.fWindowStartLine, column, c, style);
    }

    public void setChars(int line, int column, char[] chars, int start, int len, Style style) {
        if (!this.isInWindow(line)) {
            return;
        }
        this.fData.setChars(line - this.fWindowStartLine, column, chars, start, len, style);
    }

    public void setChars(int line, int column, char[] chars, Style style) {
        if (!this.isInWindow(line)) {
            return;
        }
        this.fData.setChars(line - this.fWindowStartLine, column, chars, style);
    }

    public void setDimensions(int height, int width) {
        assert (height >= 0 || this.throwRuntimeException());
        this.fData.setDimensions(this.fWindowSize, width);
        this.fHeight = height;
    }

    public void setMaxHeight(int height) {
        this.fMaxHeight = height;
    }

    public void setWindow(int startLine, int size) {
        this.fWindowStartLine = startLine;
        this.fWindowSize = size;
        this.fData.setDimensions(this.fWindowSize, this.getWidth());
    }

    public int getWindowStartLine() {
        return this.fWindowStartLine;
    }

    public int getWindowSize() {
        return this.fWindowSize;
    }

    public void setHeight(int height) {
        this.fHeight = height;
    }

    public void cleanLine(int line) {
        if (this.isInWindow(line)) {
            this.fData.cleanLine(line - this.fWindowStartLine);
        }
    }

    public int getCursorColumn() {
        return this.fData.getCursorColumn();
    }

    public int getCursorLine() {
        return this.fData.getCursorLine();
    }

    public void setCursorColumn(int column) {
        this.fData.setCursorColumn(column);
    }

    public void setCursorLine(int line) {
        this.fData.setCursorLine(line);
    }

    public boolean isWrappedLine(int line) {
        if (this.isInWindow(line)) {
            return this.fData.isWrappedLine(line - this.fWindowStartLine);
        }
        return false;
    }

    public void setWrappedLine(int line) {
        if (this.isInWindow(line)) {
            this.fData.setWrappedLine(line - this.fWindowStartLine);
        }
    }
}

