/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.core;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteFileManager;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.internal.core.RemoteServicesDescriptor;
import org.eclipse.remote.internal.core.RemoteServicesImpl;
import org.eclipse.remote.internal.core.preferences.Preferences;

public class RemoteServicesUtils {
    public static IRemoteConnection getConnectionWithProgress(String remoteServicesId, String connectionName, IProgressMonitor monitor) {
        IRemoteConnectionManager remoteConnectionManager;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IRemoteServices remoteServices = RemoteServices.getRemoteServices(remoteServicesId, (IProgressMonitor)progress.newChild(1));
        if (remoteServices != null && (remoteConnectionManager = remoteServices.getConnectionManager()) != null) {
            return remoteConnectionManager.getConnection(connectionName);
        }
        return null;
    }

    public static IFileStore getRemoteFileWithProgress(String remoteServicesId, String connectionName, String path, IProgressMonitor monitor) {
        IRemoteFileManager remoteFileManager;
        IRemoteConnection remoteConnection;
        IRemoteConnectionManager remoteConnectionManager;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IRemoteServices remoteServices = RemoteServices.getRemoteServices(remoteServicesId, (IProgressMonitor)progress.newChild(10));
        if (remoteServices != null && (remoteConnectionManager = remoteServices.getConnectionManager()) != null && (remoteConnection = remoteConnectionManager.getConnection(connectionName)) != null && (remoteFileManager = remoteConnection.getFileManager()) != null) {
            return remoteFileManager.getResource(path);
        }
        return null;
    }

    public static URI toURI(IPath path) {
        if (path.isUNC()) {
            String[] parts = path.segment(0).split(":");
            IRemoteServices services = null;
            String connName = null;
            if (parts.length == 2) {
                services = RemoteServices.getRemoteServices(parts[0]);
                connName = parts[1];
            } else if (parts.length == 1) {
                String id = Preferences.getString("remoteServicesId");
                if (id != null) {
                    services = RemoteServices.getRemoteServices(id);
                }
                connName = parts[0];
            }
            IRemoteConnection conn = null;
            if (services != null) {
                conn = services.getConnectionManager().getConnection(connName);
            } else if (connName != null) {
                for (RemoteServicesDescriptor proxy : RemoteServicesImpl.getRemoteServiceDescriptors()) {
                    IRemoteConnectionManager connMgr;
                    services = proxy.getServices();
                    if (services != null && (connMgr = services.getConnectionManager()) != null && (conn = connMgr.getConnection(connName)) != null) break;
                }
            }
            if (conn != null) {
                String scheme = conn.getRemoteServices().getScheme();
                String filePath = path.removeFirstSegments(1).makeAbsolute().toString();
                try {
                    return new URI(scheme, connName, filePath, null);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        return null;
    }
}

