/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core;

import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.remote.internal.core.RemoteDebugOptions;
import org.eclipse.remote.internal.core.preferences.Preferences;
import org.osgi.framework.BundleContext;

public class RemoteCorePlugin
extends Plugin {
    private static final String PLUGIN_ID = "org.eclipse.remote.core";
    private static RemoteCorePlugin plugin;

    public static RemoteCorePlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (RemoteCorePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return RemoteCorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        RemoteCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        RemoteCorePlugin.log((IStatus)new Status(4, RemoteCorePlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        RemoteCorePlugin.log((IStatus)new Status(4, RemoteCorePlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        RemoteDebugOptions.configure(context);
        ResourcesPlugin.getWorkspace().addSaveParticipant(RemoteCorePlugin.getUniqueIdentifier(), new ISaveParticipant(){

            public void saving(ISaveContext saveContext) throws CoreException {
                Preferences.savePreferences();
            }

            public void rollback(ISaveContext saveContext) {
            }

            public void prepareToSave(ISaveContext saveContext) throws CoreException {
            }

            public void doneSaving(ISaveContext saveContext) {
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        Preferences.savePreferences();
        plugin = null;
        super.stop(context);
    }
}

