/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.SocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.Activator;
import org.eclipse.remote.internal.jsch.core.ArgumentParser;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.JSchProcess;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JSchConnectionProxyFactory {
    public static Proxy createCommandProxy(JSchConnection connection, String command, IProgressMonitor monitor) {
        return new CommandProxy(connection, command, monitor);
    }

    public static Proxy createForwardProxy(JSchConnection proxyConnection, IProgressMonitor monitor) {
        return new SSHForwardProxy(proxyConnection, monitor);
    }

    private static class CommandProxy
    implements Proxy {
        private String command;
        private IRemoteProcess process;
        private JSchConnection connection;
        private IProgressMonitor monitor;
        private boolean connectCalled = false;

        private CommandProxy(JSchConnection connection, String command, IProgressMonitor monitor) {
            if (command == null || monitor == null) {
                throw new IllegalArgumentException();
            }
            this.command = command;
            this.connection = connection;
            this.monitor = monitor;
        }

        public void close() {
            this.process.destroy();
        }

        public void connect(SocketFactory socket_factory, String host, int port, int timeout) throws IOException {
            assert (!this.connectCalled) : "connect should only be called once";
            try {
                boolean bCanceled;
                boolean bTimedOut;
                boolean bProcessComplete;
                boolean bOutputAvailable;
                if (timeout == 0) {
                    timeout = 10000;
                }
                int waitSteps = timeout / 50;
                SubMonitor subMon = SubMonitor.convert((IProgressMonitor)this.monitor, (int)(waitSteps * 2));
                SubMonitor childMon = subMon.newChild(waitSteps);
                try {
                    if (this.connection != null) {
                        this.connection.openMinimal((IProgressMonitor)childMon);
                    }
                }
                catch (RemoteConnectionException e) {
                    throw new IOException(e);
                }
                subMon.setWorkRemaining(waitSteps);
                this.command = this.command.replace("%h", host);
                this.command = this.command.replace("%p", Integer.toString(port));
                if (this.connection != null) {
                    try {
                        ChannelExec exec = this.connection.getExecChannel();
                        exec.setCommand(this.command);
                        exec.connect();
                        this.process = new JSchProcess(exec, false);
                    }
                    catch (JSchException | RemoteConnectionException e) {
                        throw new IOException(e);
                    }
                } else {
                    List<String> cmd = new ArgumentParser(this.command).getTokenList();
                    this.process = RemoteServices.getLocalServices().getConnectionManager().getConnection("Local").getProcessBuilder(cmd).start();
                }
                long endTime = System.currentTimeMillis() + (long)timeout;
                do {
                    try {
                        Thread.sleep(50L);
                        subMon.worked(1);
                    }
                    catch (InterruptedException interruptedException) {}
                    bOutputAvailable = this.getInputStream().available() != 0;
                    bProcessComplete = this.process.isCompleted();
                    bTimedOut = System.currentTimeMillis() > endTime;
                    bCanceled = subMon.isCanceled();
                } while (!bOutputAvailable && !bProcessComplete && !bTimedOut && !bCanceled);
                final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                if (this.getInputStream().available() == 0 || this.process.isCompleted()) {
                    String msg = "";
                    while (bufferedReader.ready()) {
                        msg = String.valueOf(msg) + (char)bufferedReader.read();
                    }
                    msg = msg.trim();
                    if (!this.process.isCompleted()) {
                        this.process.destroy();
                    }
                    String cause = Messages.JSchConnectionProxyFactory_failed;
                    if (bTimedOut) {
                        cause = Messages.JSchConnectionProxyFactory_timedOut;
                    } else if (bCanceled) {
                        cause = Messages.JSchConnectionProxyFactory_wasCanceled;
                    }
                    throw new IOException(MessageFormat.format(Messages.JSchConnectionProxyFactory_ProxyCommandFailed, this.command, cause, msg));
                }
                new Thread(){

                    @Override
                    public void run() {
                        ILog log = Activator.getDefault().getLog();
                        try {
                            String line;
                            while ((line = bufferedReader.readLine()) != null) {
                                log.log((IStatus)new Status(1, Activator.getUniqueIdentifier(), 0, line, null));
                            }
                        }
                        catch (IOException e) {
                            Activator.log(e);
                        }
                    }
                }.start();
            }
            finally {
                this.connectCalled = true;
            }
        }

        public InputStream getInputStream() {
            return this.process.getInputStream();
        }

        public OutputStream getOutputStream() {
            return this.process.getOutputStream();
        }

        public Socket getSocket() {
            return null;
        }
    }

    private static class SSHForwardProxy
    implements Proxy {
        private Channel channel;
        private JSchConnection connection;
        private IProgressMonitor monitor;
        private boolean connectCalled = false;

        private SSHForwardProxy(JSchConnection proxyConnection, IProgressMonitor monitor) {
            if (proxyConnection == null || monitor == null) {
                throw new IllegalArgumentException();
            }
            this.connection = proxyConnection;
            this.monitor = monitor;
        }

        public void close() {
            this.channel.disconnect();
        }

        public void connect(SocketFactory socket_factory, String host, int port, int timeout) throws Exception {
            assert (!this.connectCalled) : "connect should only be called once";
            try {
                if (!this.connection.hasOpenSession()) {
                    try {
                        this.connection.openMinimal(this.monitor);
                    }
                    catch (RemoteConnectionException e) {
                        throw new IOException(e);
                    }
                }
                this.channel = this.connection.getStreamForwarder(host, port);
            }
            finally {
                this.connectCalled = true;
            }
        }

        public InputStream getInputStream() {
            try {
                return this.channel.getInputStream();
            }
            catch (IOException e) {
                Activator.log(e);
                return null;
            }
        }

        public OutputStream getOutputStream() {
            try {
                return this.channel.getOutputStream();
            }
            catch (IOException e) {
                Activator.log(e);
                return null;
            }
        }

        public Socket getSocket() {
            return null;
        }
    }
}

