/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.telnet.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.types.AbstractConnectorType;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.telnet.TelnetSettings;

public class TelnetConnectorType
extends AbstractConnectorType {
    public ITerminalConnector createTerminalConnector(IPropertiesContainer properties) {
        Assert.isNotNull((Object)properties);
        String connectorId = properties.getStringProperty("tm.terminal.connector.id");
        String host = properties.getStringProperty("ip.host");
        String port = properties.getStringProperty("ip.port");
        String timeout = properties.getStringProperty("timeout");
        int portOffset = 0;
        if (properties.getProperty("ip.port.offset") != null && (portOffset = properties.getIntProperty("ip.port.offset")) < 0) {
            portOffset = 0;
        }
        return host != null && port != null ? this.createTelnetConnector(connectorId, new String[]{host, port, timeout}, portOffset) : null;
    }

    protected ITerminalConnector createTelnetConnector(String connectorId, String[] attributes, int portOffset) {
        Assert.isNotNull((Object)attributes);
        Assert.isTrue((attributes.length >= 2 ? 1 : 0) != 0);
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.internal.terminal.telnet.TelnetConnector";
        }
        String serverName = attributes[0];
        String serverPort = Integer.toString(Integer.decode(attributes[1]) + portOffset);
        String timeout = attributes.length >= 3 ? attributes[2] : null;
        SettingsStore store = new SettingsStore();
        TelnetSettings telnetSettings = new TelnetSettings();
        telnetSettings.setHost(serverName);
        telnetSettings.setNetworkPort(serverPort);
        if (timeout != null) {
            telnetSettings.setTimeout(timeout);
        }
        telnetSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

