/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.remote;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionManager;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.remote.Activator;
import org.eclipse.tm.internal.terminal.remote.ArgumentParser;
import org.eclipse.tm.internal.terminal.remote.RemoteConnector;
import org.eclipse.tm.internal.terminal.remote.messages.Messages;
import org.eclipse.tm.terminal.remote.IRemoteTerminalParser;

public class RemoteConnectionManager
extends Job {
    private static final String PARSERS_EXTENSION_POINT = "parsers";
    private static final String PARSER_ELEMENT = "parser";
    private static int fgNo;
    private final ITerminalControl control;
    private final RemoteConnector connector;
    private IRemoteTerminalParser parser;

    protected RemoteConnectionManager(RemoteConnector conn, ITerminalControl control) {
        super("Remote Terminal-" + fgNo++);
        this.control = control;
        this.connector = conn;
        this.setSystem(true);
        this.loadParserExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        IRemoteProcess remoteProcess = null;
        IRemoteConnection remoteConnection = null;
        try {
            IRemoteConnectionManager connMgr;
            String remoteServices = this.connector.getSshSettings().getRemoteServices();
            IRemoteServices services = RemoteServices.getRemoteServices((String)remoteServices);
            if (services != null && (connMgr = services.getConnectionManager()) != null) {
                remoteConnection = connMgr.getConnection(this.connector.getSshSettings().getConnectionName());
            }
            if (remoteConnection == null) {
                throw new RemoteConnectionException(NLS.bind((String)Messages.RemoteConnectionManager_0, (Object)this.connector.getSshSettings().getConnectionName()));
            }
            if (!remoteConnection.isOpen()) {
                remoteConnection.open(monitor);
                if (!remoteConnection.isOpen()) {
                    throw new RemoteConnectionException(NLS.bind((String)Messages.RemoteConnectionManager_1, (Object)this.connector.getSshSettings().getConnectionName()));
                }
            }
            if (this.parser != null) {
                remoteProcess = this.parser.initialize(remoteConnection);
            } else {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(Activator.getUniqueIdentifier());
                String terminalShellCommand = prefs.get("TERMINAL_SHELL_COMMAND", "");
                if (!"".equals(terminalShellCommand) && (remoteConnection.getRemoteServices().getCapabilities() & 0x20) != 0) {
                    remoteProcess = remoteConnection.getCommandShell(1);
                } else {
                    if ("".equals(terminalShellCommand)) {
                        terminalShellCommand = "/bin/bash -l";
                    }
                    IRemoteProcessBuilder processBuilder = remoteConnection.getProcessBuilder(new ArgumentParser(terminalShellCommand).getTokenList());
                    remoteProcess = processBuilder.start(1);
                }
            }
            this.connector.setInputStream(remoteProcess.getInputStream());
            this.control.setState(TerminalState.CONNECTED);
            this.control.setTerminalTitle(remoteConnection.getName());
            this.connector.setOutputStream(remoteProcess.getOutputStream());
            this.readData(this.connector.getInputStream());
        }
        catch (IOException e) {
            Status status = new Status(4, Activator.getUniqueIdentifier(), e.getMessage());
            this.connector.disconnect();
            RemoteConnectionManager remoteConnectionManager = this;
            synchronized (remoteConnectionManager) {
                if (remoteProcess != null && !remoteProcess.isCompleted()) {
                    remoteProcess.destroy();
                }
            }
            return status;
        }
        catch (RemoteConnectionException e) {
            Status status;
            try {
                status = new Status(4, Activator.getUniqueIdentifier(), e.getMessage());
            }
            catch (Throwable throwable) {
                this.connector.disconnect();
                RemoteConnectionManager remoteConnectionManager = this;
                synchronized (remoteConnectionManager) {
                    if (remoteProcess != null && !remoteProcess.isCompleted()) {
                        remoteProcess.destroy();
                    }
                }
                throw throwable;
            }
            this.connector.disconnect();
            RemoteConnectionManager remoteConnectionManager = this;
            synchronized (remoteConnectionManager) {
                if (remoteProcess != null && !remoteProcess.isCompleted()) {
                    remoteProcess.destroy();
                }
            }
            return status;
        }
        this.connector.disconnect();
        RemoteConnectionManager remoteConnectionManager = this;
        synchronized (remoteConnectionManager) {
            if (remoteProcess != null && !remoteProcess.isCompleted()) {
                remoteProcess.destroy();
            }
        }
        return Status.OK_STATUS;
    }

    public void setTerminalSize(int cols, int rows, int width, int height) {
    }

    private void readData(InputStream in) throws IOException {
        byte[] buf = new byte[32768];
        while (this.getState() == 4) {
            int n = in.read(buf, 0, buf.length);
            if (n <= 0) break;
            if (this.parser != null && !this.parser.parse(buf)) continue;
            this.control.getRemoteToTerminalOutputStream().write(buf, 0, n);
        }
    }

    private void loadParserExtension() {
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(Activator.getUniqueIdentifier(), PARSERS_EXTENSION_POINT);
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (PARSER_ELEMENT.equals(element.getName())) {
                        try {
                            this.parser = (IRemoteTerminalParser)element.createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            Activator.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

