/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.remote;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;
import org.eclipse.tm.internal.terminal.remote.Activator;
import org.eclipse.tm.internal.terminal.remote.RemoteConnectionManager;
import org.eclipse.tm.internal.terminal.remote.RemoteSettings;
import org.eclipse.tm.internal.terminal.remote.RemoteSettingsPage;
import org.eclipse.tm.terminal.remote.IRemoteSettings;

public class RemoteConnector
extends TerminalConnectorImpl {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private RemoteConnectionManager fConnection;
    private int fWidth;
    private int fHeight;
    private final RemoteSettings fSettings;

    public RemoteConnector() {
        this(new RemoteSettings());
    }

    public RemoteConnector(RemoteSettings settings) {
        this.fSettings = settings;
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fControl.setState(TerminalState.CONNECTING);
        this.fConnection = new RemoteConnectionManager(this, control);
        this.fConnection.schedule();
    }

    public synchronized void doDisconnect() {
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Activator.log(exception);
            }
        }
        if (this.getTerminalToRemoteStream() != null) {
            try {
                this.getTerminalToRemoteStream().close();
            }
            catch (Exception exception) {
                Activator.log(exception);
            }
        }
        this.fConnection.cancel();
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public IRemoteSettings getSshSettings() {
        return this.fSettings;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    public void initialize() throws Exception {
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public ISettingsPage makeSettingsPage() {
        return new RemoteSettingsPage(this.fSettings);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }

    public void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fConnection != null && (newWidth != this.fWidth || newHeight != this.fHeight)) {
            this.fConnection.setTerminalSize(newWidth, newHeight, 8 * newWidth, 8 * newHeight);
            this.fWidth = newWidth;
            this.fHeight = newHeight;
        }
    }
}

