/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.trace4cps.analysis.resource.impl.ResourceClientHistogram;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IResource;
import org.eclipse.trace4cps.core.ITrace;

public class ResourceAnalysis {
    private ResourceAnalysis() {
    }

    public static Map<IResource, TreeMap<Integer, Double>> compute(ITrace trace, List<IResource> selected, boolean cumulative) {
        return ResourceAnalysis.convertHistos(ResourceAnalysis.getHistos(trace), selected, cumulative);
    }

    private static Map<IResource, ResourceClientHistogram> getHistos(ITrace trace) {
        HashMap<IResource, ResourceClientHistogram> histos = new HashMap<IResource, ResourceClientHistogram>();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (IClaim c : trace.getClaims()) {
            IResource r = c.getResource();
            ResourceClientHistogram h = (ResourceClientHistogram)histos.get(r);
            if (h == null) {
                h = new ResourceClientHistogram();
                histos.put(r, h);
            }
            h.claim(c.getStartTime().doubleValue(), c.getEndTime().doubleValue());
            min = Math.min(min, c.getStartTime().doubleValue());
            max = Math.max(max, c.getEndTime().doubleValue());
        }
        for (ResourceClientHistogram h : histos.values()) {
            h.done(min, max);
        }
        return histos;
    }

    private static Map<IResource, TreeMap<Integer, Double>> convertHistos(Map<IResource, ResourceClientHistogram> histos, List<IResource> selected, boolean cumulative) {
        HashMap<IResource, TreeMap<Integer, Double>> h = new HashMap<IResource, TreeMap<Integer, Double>>();
        for (Map.Entry<IResource, ResourceClientHistogram> e : histos.entrySet()) {
            IResource r = e.getKey();
            if (!selected.contains(r)) continue;
            if (cumulative) {
                h.put(r, e.getValue().getNormalizedCumulativeClientUsage());
                continue;
            }
            h.put(r, e.getValue().getNormalizedClientUsage());
        }
        return h;
    }
}

