/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python;

import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.python.PythonHelper;
import org.eclipse.ease.ui.completion.BasicContext;
import org.eclipse.ease.ui.completion.tokenizer.IVariablesResolver;
import org.eclipse.ease.ui.completion.tokenizer.InputTokenizer;

public class PythonCompletionContext
extends BasicContext {
    public PythonCompletionContext(IScriptEngine scriptEngine, String contents, int position) {
        super(scriptEngine, contents, position);
    }

    public PythonCompletionContext(Object resource, String contents, int position) {
        super(PythonHelper.getScriptType(), resource, contents, position);
    }

    protected InputTokenizer getInputTokenizer() {
        if (this.getScriptEngine() != null) {
            return new PythonInputTokenizer(v -> {
                Object variable = this.getScriptEngine().getVariable(v);
                return variable == null ? null : variable.getClass();
            });
        }
        return new PythonInputTokenizer();
    }

    private final class PythonInputTokenizer
    extends InputTokenizer {
        private PythonInputTokenizer() {
        }

        private PythonInputTokenizer(IVariablesResolver variablesResolver) {
            super(variablesResolver);
        }

        protected boolean isLiteral(char candidate) {
            return '\"' == candidate || '\'' == candidate;
        }
    }
}

