/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ease.ui.help.hovers.HelpHoverImageProvider;
import org.eclipse.ease.ui.help.hovers.IHoverHelp;
import org.eclipse.ui.IMemento;

public class MethodHelp
implements IHoverHelp {
    private final URL fHelpLocation;
    private IMemento fHelpContent;
    private final Method fMethod;

    public MethodHelp(URL helpLocation, IMemento helpContent, Method method) throws Exception {
        this.fHelpLocation = helpLocation;
        this.fMethod = method;
        this.fHelpContent = null;
        IMemento[] iMementoArray = helpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if (this.fMethod.getName().equals(node.getString("data-method")) && String.valueOf(node.getString("class")).equals("command")) {
                IHoverHelp.updateRelativeLinks(node, this.fHelpLocation);
                this.fHelpContent = node;
                break;
            }
            ++n2;
        }
        if (this.fHelpContent == null) {
            throw new Exception("Cannot find method help for " + this.getName());
        }
    }

    @Override
    public String getName() {
        return this.fMethod.getName();
    }

    @Override
    public String getDescription() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento contentNode = iMementoArray[n2];
            if ("description".equals(contentNode.getString("class"))) {
                return IHoverHelp.getNodeContent(contentNode);
            }
            ++n2;
        }
        return null;
    }

    private String getReturnValueDescription() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento contentNode = iMementoArray[n2];
            if ("return".equals(contentNode.getString("class"))) {
                return IHoverHelp.getNodeContent(contentNode);
            }
            ++n2;
        }
        return null;
    }

    private String getDeprecationMessage() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento contentNode = iMementoArray[n2];
            if ("deprecated".equals(contentNode.getString("class"))) {
                String content = IHoverHelp.getNodeContent(contentNode);
                if (content.contains("<span class=\"warning\"></span>")) {
                    content = content.substring(content.indexOf("<span class=\"warning\"></span>") + "<span class=\"warning\"></span>".length());
                }
                return content;
            }
            ++n2;
        }
        return null;
    }

    public List<IHoverHelp> getParameterDescriptions() {
        ArrayList<IHoverHelp> parameters = new ArrayList<IHoverHelp>();
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento contentNode = iMementoArray[n2];
            if ("parameters".equals(contentNode.getString("class"))) {
                IMemento[] iMementoArray2 = contentNode.getChildren();
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento child = iMementoArray2[n4];
                    if ("description".equals(child.getString("class"))) {
                        String key = child.getString("data-parameter");
                        String value = IHoverHelp.getNodeContent(child);
                        parameters.add(new GenericHoverHelp(this, key, value){

                            @Override
                            public String getName() {
                                if (this.isOptional()) {
                                    return "<i>" + super.getName() + "</i>";
                                }
                                return super.getName();
                            }

                            private boolean isOptional() {
                                return this.getDescription().contains("<span class=\"optional\">");
                            }
                        });
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return parameters;
    }

    public List<IHoverHelp> getExceptionDescriptions() {
        ArrayList<IHoverHelp> exceptions = new ArrayList<IHoverHelp>();
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento contentNode = iMementoArray[n2];
            if ("exceptions".equals(contentNode.getString("class"))) {
                String key = null;
                IMemento[] iMementoArray2 = contentNode.getChildren();
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento child = iMementoArray2[n4];
                    if ("description".equals(child.getString("class"))) {
                        String value = IHoverHelp.getNodeContent(child);
                        if (key == null) {
                            key = child.getString("data-exception");
                        }
                        exceptions.add(new GenericHoverHelp(key, value));
                        key = null;
                    } else {
                        key = IHoverHelp.getNodeContent(child);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return exceptions;
    }

    public List<IHoverHelp> getExamples() {
        ArrayList<IHoverHelp> examples = new ArrayList<IHoverHelp>();
        IMemento[] iMementoArray = this.fHelpContent.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento contentNode = iMementoArray[n2];
            if ("examples".equals(contentNode.getString("class"))) {
                String key = null;
                IMemento[] iMementoArray2 = contentNode.getChildren();
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento child = iMementoArray2[n4];
                    if ("description".equals(child.getString("class"))) {
                        String value = IHoverHelp.getNodeContent(child);
                        if (key != null) {
                            examples.add(new GenericHoverHelp(this, key, value){

                                @Override
                                public String getHoverContent() {
                                    StringBuilder help = new StringBuilder();
                                    help.append("<dd><div class=\"code\">");
                                    help.append(this.getName());
                                    help.append("</div><div class=\"description\">");
                                    help.append(this.getDescription());
                                    help.append("</div></dd>");
                                    return help.toString();
                                }
                            });
                        }
                        key = null;
                    } else {
                        key = IHoverHelp.getNodeContent(child);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return examples;
    }

    @Override
    public String getHoverContent() {
        List<IHoverHelp> examples;
        List<IHoverHelp> exceptionDescription;
        String returnValueDescription;
        List<IHoverHelp> parameterDescriptions;
        String description;
        StringBuffer help = new StringBuffer();
        help.append("<h5>");
        help.append(IHoverHelp.getImageAndLabel(HelpHoverImageProvider.getImageLocation("icons/eobj16/function.png"), this.extractSynopsis()));
        help.append("</h5>");
        String deprecationMessage = this.getDeprecationMessage();
        if (deprecationMessage != null) {
            help.append("<p>");
            help.append(deprecationMessage);
            help.append("</p>");
        }
        if ((description = this.getDescription()) != null) {
            help.append("<p>");
            help.append(description);
            help.append("</p>");
        }
        if (!(parameterDescriptions = this.getParameterDescriptions()).isEmpty()) {
            help.append("<dl>");
            help.append("<dt>Parameters:</dt>");
            for (IHoverHelp parameter : parameterDescriptions) {
                help.append(parameter.getHoverContent());
            }
            help.append("</dl>");
        }
        if ((returnValueDescription = this.getReturnValueDescription()) != null) {
            help.append("<dl>");
            help.append("<dt>Returns:</dt>");
            help.append("<dd>");
            help.append(returnValueDescription);
            help.append("</dd>");
            help.append("</dl>");
        }
        if (!(exceptionDescription = this.getExceptionDescriptions()).isEmpty()) {
            help.append("<dl>");
            help.append("<dt>Throws:</dt>");
            for (IHoverHelp exception : exceptionDescription) {
                help.append(exception.getHoverContent());
            }
            help.append("</dl>");
        }
        if (!(examples = this.getExamples()).isEmpty()) {
            help.append("<dl>");
            help.append("<dt>Examples:</dt>");
            for (IHoverHelp example : examples) {
                help.append(example.getHoverContent());
            }
            help.append("</dl>");
        }
        return help.toString();
    }

    private String extractSynopsis() {
        IMemento[] iMementoArray = this.fHelpContent.getChildren("p");
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            if ("synopsis".equals(child.getString("class"))) {
                IMemento[] iMementoArray2 = child.getChildren("a");
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento anchor = iMementoArray2[n4];
                    anchor.putString("class", "header");
                    ++n4;
                }
                return IHoverHelp.getNodeContent(child);
            }
            ++n2;
        }
        return "";
    }

    private class GenericHoverHelp
    implements IHoverHelp {
        private final String fName;
        private final String fDescription;

        public GenericHoverHelp(String name, String description) {
            this.fName = name;
            this.fDescription = description.replaceAll("<a ", "<a class='header' ");
        }

        @Override
        public String getName() {
            return this.fName;
        }

        @Override
        public String getDescription() {
            return this.fDescription;
        }

        @Override
        public String getHoverContent() {
            StringBuilder help = new StringBuilder();
            help.append("<dd>");
            help.append("<b>");
            help.append(this.getName());
            help.append("</b> ");
            help.append(this.getDescription());
            help.append("</dd>");
            return help.toString();
        }
    }
}

