/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.applications;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ScriptResult;
import org.eclipse.ease.service.ScriptService;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IStartup;

public class RunHeadlessScript
implements IApplication {
    private static final String HELP = "-help";
    private static final String ENGINE = "-engine";
    private static final String SCRIPT_ARGUMENTS = "scriptArguments";
    private static final String SCRIPT = "-script";
    private static final String REFRESH_WORKSPACE = "-refreshWorkspace";
    private static final String WORKSPACE = "-workspace";
    private static final Collection<String> EARLY_STARTUP_BLACKLIST = Arrays.asList("org.eclipse.team.svn.ui.startup.SVNCoreStartup", "org.eclipse.egit.ui.internal.clone.GitCloneDropAdapter", "org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateScheduler");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, Object> extractInputParameters(String[] arguments) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(SCRIPT_ARGUMENTS, new ArrayList());
        int index = 0;
        while (index < arguments.length) {
            if (parameters.containsKey(SCRIPT)) {
                ((List)parameters.get(SCRIPT_ARGUMENTS)).add(arguments[index]);
            } else if (SCRIPT.equals(arguments[index])) {
                if (index + 1 >= arguments.length) throw new IllegalArgumentException("script name is missing");
                parameters.put(SCRIPT, arguments[index + 1]);
                ((List)parameters.get(SCRIPT_ARGUMENTS)).add(arguments[index + 1]);
                ++index;
            } else if (WORKSPACE.equals(arguments[index])) {
                if (index + 1 >= arguments.length) throw new IllegalArgumentException("workspace name is missing");
                parameters.put(WORKSPACE, arguments[index + 1]);
                ++index;
            } else if (REFRESH_WORKSPACE.equals(arguments[index])) {
                parameters.put(REFRESH_WORKSPACE, true);
            } else if (ENGINE.equals(arguments[index])) {
                if (index + 1 >= arguments.length) throw new IllegalArgumentException("engine ID is missing");
                parameters.put(ENGINE, arguments[index + 1]);
                ++index;
            } else {
                if (!HELP.equals(arguments[index])) throw new IllegalArgumentException(String.format("invalid argument: %s", arguments[index]));
                return null;
            }
            ++index;
        }
        return parameters;
    }

    private static void printUsage() {
        System.out.println("SYNTAX: [-workspace <workspace location> [-refreshWorkspace]] [-engine <engineID>]-script <script name> <script parameters>");
        System.out.println("");
        System.out.println("\t\t<script name> is a path like 'file://C/myfolder/myscript.js'");
        System.out.println("\t\t<engineID> provides a dedicated script engine ID. Use org.eclipse.ease.listEngines application.");
        System.out.println("\t\t<workspace location> is a file system path like 'C:\\somefolder\\myworkspace'");
        System.out.println("\t\t\tif you provide a workspace you can use workspace:// identifiers in your scripts");
        System.out.println("\t\t\tif you provide a workspace you may ask to refresh it first prior to script execution");
        System.out.println("\t\t<script parameters> will be passed to the script as String[] in the variable 'argv'");
    }

    private static void printError(String message) {
        System.out.println("ERROR: " + message);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext context) throws Exception {
        block13: {
            try {
                Object object = context.getArguments().get("application.args");
                if (!(object instanceof String[])) break block13;
                Map<String, Object> parameters = RunHeadlessScript.extractInputParameters((String[])object);
                if (parameters != null) {
                    Location location = this.loadWorkspace(parameters);
                    this.loadEarlyStartupExtensions();
                    try {
                        if (parameters.containsKey(SCRIPT)) {
                            String scriptLocation = parameters.get(SCRIPT).toString();
                            String engineID = parameters.containsKey(ENGINE) ? parameters.get(ENGINE).toString() : null;
                            String[] arguments = ((List)parameters.get(SCRIPT_ARGUMENTS)).toArray(new String[0]);
                            try {
                                Object result = ScriptService.getInstance().executeScript(scriptLocation, engineID, arguments);
                                Integer n = this.getScriptResult(result);
                                return n;
                            }
                            catch (Throwable throwable) {
                                Integer n;
                                block14: {
                                    n = -1;
                                    if (location == null) break block14;
                                    ResourcesPlugin.getWorkspace().save(true, null);
                                    location.release();
                                }
                                return n;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Parameter '%s' is required", SCRIPT));
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (location != null) {
                            ResourcesPlugin.getWorkspace().save(true, null);
                            location.release();
                        }
                    }
                }
                RunHeadlessScript.printUsage();
            }
            catch (IOException e) {
                RunHeadlessScript.printError(String.format(e.getMessage(), new Object[0]));
                RunHeadlessScript.printUsage();
            }
            catch (IllegalArgumentException e) {
                RunHeadlessScript.printError(String.format("invalid command line argument%n\t%s%n", e.getMessage()));
                RunHeadlessScript.printUsage();
            }
        }
        return -1;
    }

    private int getScriptResult(Object result) {
        if (result != null) {
            if (ScriptResult.VOID.equals(result)) {
                return 0;
            }
            try {
                return Integer.parseInt(result.toString());
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.valueOf(result.toString()).intValue();
                }
                catch (NumberFormatException numberFormatException2) {
                    return Boolean.parseBoolean(result.toString()) ? 0 : -1;
                }
            }
        }
        return 0;
    }

    private Location loadWorkspace(Map<String, Object> parameters) throws MalformedURLException, IOException, CoreException {
        Location location = null;
        if (parameters.containsKey(WORKSPACE)) {
            location = Platform.getInstanceLocation();
            URL workspaceURL = new File(parameters.get(WORKSPACE).toString()).toURL();
            if (!location.isSet()) {
                if (!location.set(workspaceURL, true)) {
                    throw new IOException(String.format("Could not set the workspace to '%s'", location.getURL()));
                }
            } else if (!location.getURL().toString().equals(workspaceURL.toString())) {
                throw new IOException(String.format("Could not set the workspace as it is already set to '%s'", location.getURL()));
            }
            if (parameters.containsKey(REFRESH_WORKSPACE)) {
                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        return location;
    }

    private void loadEarlyStartupExtensions() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.startup");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            if (e.getName().equals("startup") && !EARLY_STARTUP_BLACKLIST.contains(e.getAttribute("class"))) {
                try {
                    Logger.info("org.eclipse.ease", "Loading early startup extension: " + e.getAttribute("class"));
                    Object earlyStartupParticipant = e.createExecutableExtension("class");
                    if (earlyStartupParticipant instanceof IStartup) {
                        try {
                            ((IStartup)earlyStartupParticipant).earlyStartup();
                        }
                        catch (Throwable e1) {
                            RunHeadlessScript.printError(String.format("Failed to execute %s.earlyStartup(): %s", earlyStartupParticipant.getClass().getName(), e1));
                        }
                    }
                }
                catch (CoreException e1) {
                    RunHeadlessScript.printError("Could not create instance for startup code: " + e.getAttribute("class"));
                }
            }
            ++n2;
        }
    }

    public void stop() {
    }
}

