/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct;

import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypedefParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct.StructDeclarationParser;

public final class StructBodyParser
extends AbstractScopedCommonTreeParser {
    public static final StructBodyParser INSTANCE = new StructBodyParser();

    private StructBodyParser() {
    }

    @Override
    public StructDeclaration parse(CommonTree structBody, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        String structName = ((Param)param).fName;
        DeclarationScope scope = new DeclarationScope(((Param)param).fDeclarationScope, structName == null ? "struct" : structName);
        StructDeclaration structDeclaration = ((Param)param).fStructDeclaration;
        List<CommonTree> structDeclarations = structBody.getChildren();
        if (structDeclarations == null) {
            structDeclarations = Collections.emptyList();
        }
        CTFTrace trace = ((Param)param).fTrace;
        for (CommonTree declarationNode : structDeclarations) {
            switch (declarationNode.getType()) {
                case 111: {
                    TypeAliasParser.INSTANCE.parse(declarationNode, new TypeAliasParser.Param(trace, scope));
                    break;
                }
                case 114: {
                    TypedefParser.INSTANCE.parse(declarationNode, new TypedefParser.Param(trace, scope));
                    StructDeclarationParser.INSTANCE.parse(declarationNode, new StructDeclarationParser.Param(structDeclaration, trace, scope));
                    break;
                }
                case 109: {
                    StructDeclarationParser.INSTANCE.parse(declarationNode, new StructDeclarationParser.Param(structDeclaration, trace, scope));
                    break;
                }
                default: {
                    throw TsdlUtils.childTypeError(declarationNode);
                }
            }
        }
        return structDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final @Nullable String fName;
        private final StructDeclaration fStructDeclaration;
        private final CTFTrace fTrace;

        public Param(StructDeclaration structDeclaration, CTFTrace trace, @Nullable String name, DeclarationScope scope) {
            this.fStructDeclaration = structDeclaration;
            this.fTrace = trace;
            this.fDeclarationScope = scope;
            this.fName = name;
        }
    }
}

