/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.callgraph.statistics;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.statistics.AbstractSegmentsStatisticsViewer;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;

public class CallGraphStatisticsViewer
extends AbstractSegmentsStatisticsViewer {
    public CallGraphStatisticsViewer(Composite parent) {
        super(Objects.requireNonNull(parent), "org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.callgraphanalysis.statistics");
        this.setLabelProvider((IBaseLabelProvider)new AbstractSegmentsStatisticsViewer.SegmentStoreStatisticsLabelProvider(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            public @NonNull String getColumnText(@Nullable Object element, int columnIndex) {
                if (columnIndex == 0 && element instanceof TmfGenericTreeEntry) {
                    @NonNull TmfGenericTreeEntry entry = (TmfGenericTreeEntry)element;
                    SymbolFormatter fe = new SymbolFormatter(CallGraphStatisticsViewer.this.getTrace());
                    return String.valueOf(fe.apply((TmfGenericTreeEntry<SegmentStoreStatisticsModel>)entry));
                }
                return super.getColumnText(element, columnIndex);
            }
        });
    }

    private static final class SymbolFormatter
    implements Function<TmfGenericTreeEntry<SegmentStoreStatisticsModel>, String> {
        private final @NonNull Collection<@NonNull ISymbolProvider> fSymbolProviders;

        public SymbolFormatter(@Nullable ITmfTrace trace) {
            this.fSymbolProviders = trace != null ? SymbolProviderManager.getInstance().getSymbolProviders(trace) : Collections.emptySet();
        }

        @Override
        public String apply(@NonNull TmfGenericTreeEntry<@NonNull SegmentStoreStatisticsModel> stat) {
            String original = stat.getName();
            try {
                Long address = Long.decode(original);
                return SymbolProviderUtils.getSymbolText(this.fSymbolProviders, (long)address);
            }
            catch (NumberFormatException numberFormatException) {
                return original;
            }
        }
    }
}

