/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.axisconverter;

import org.eclipse.swtchart.extensions.core.AbstractAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IChartDataCoordinates;

public class PercentageConverter
extends AbstractAxisScaleConverter
implements IAxisScaleConverter {
    private static final double REFERENCE = 100.0;
    private int orientation;
    private boolean isZeroBased;

    public PercentageConverter(int orientation, boolean isZeroBased) {
        this.orientation = orientation;
        this.isZeroBased = isZeroBased;
    }

    @Override
    public double convertToSecondaryUnit(double primaryValue) {
        double deltaRange;
        IChartDataCoordinates chartDataCoordinates = this.getChartDataCoordinates();
        double convertedValue = 0.0;
        if (chartDataCoordinates != null && (deltaRange = this.calculateDeltaRange(chartDataCoordinates)) != 0.0) {
            convertedValue = 100.0 / deltaRange * primaryValue;
        }
        return convertedValue;
    }

    @Override
    public double convertToPrimaryUnit(double secondaryValue) {
        IChartDataCoordinates chartDataCoordinates = this.getChartDataCoordinates();
        double convertedValue = 0.0;
        if (chartDataCoordinates != null) {
            double deltaRange = this.calculateDeltaRange(chartDataCoordinates);
            convertedValue = deltaRange * (secondaryValue / 100.0);
        }
        return convertedValue;
    }

    private double calculateDeltaRange(IChartDataCoordinates chartDataCoordinates) {
        double max;
        double min;
        if (this.orientation == 512) {
            min = this.isZeroBased ? 0.0 : chartDataCoordinates.getMinY();
            max = chartDataCoordinates.getMaxY();
        } else {
            min = this.isZeroBased ? 0.0 : chartDataCoordinates.getMinX();
            max = chartDataCoordinates.getMaxX();
        }
        return max - min;
    }
}

