/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.remote.internal.core.RemoteCorePlugin;
import org.osgi.service.prefs.BackingStoreException;

public final class Preferences {
    private static final IScopeContext[] contexts = new IScopeContext[]{DefaultScope.INSTANCE, InstanceScope.INSTANCE};
    private static final int DEFAULT_CONTEXT = 0;
    private static final int INSTANCE_CONTEXT = 1;
    private static final String fQualifier = RemoteCorePlugin.getUniqueIdentifier();

    public static void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        contexts[0].getNode(fQualifier).addPreferenceChangeListener(listener);
        contexts[1].getNode(fQualifier).addPreferenceChangeListener(listener);
    }

    public static boolean contains(String name) {
        return contexts[1].getNode(fQualifier).get(name, null) != null || contexts[0].getNode(fQualifier).get(name, null) != null;
    }

    public static boolean getBoolean(String key) {
        return Platform.getPreferencesService().getBoolean(fQualifier, key, false, null);
    }

    public static byte[] getByteArray(String key) {
        return Platform.getPreferencesService().getByteArray(fQualifier, key, null, null);
    }

    public static synchronized boolean getDefaultBoolean(String key, boolean defaultvalue) {
        return contexts[0].getNode(fQualifier).getBoolean(key, defaultvalue);
    }

    public static synchronized byte[] getDefaultByteArray(String key, byte[] defaultvalue) {
        return contexts[0].getNode(fQualifier).getByteArray(key, defaultvalue);
    }

    public static synchronized double getDefaultDouble(String key, double defaultvalue) {
        return contexts[0].getNode(fQualifier).getDouble(key, defaultvalue);
    }

    public static synchronized float getDefaultFloat(String key, float defaultvalue) {
        return contexts[0].getNode(fQualifier).getFloat(key, defaultvalue);
    }

    public static synchronized int getDefaultInt(String key, int defaultvalue) {
        return contexts[0].getNode(fQualifier).getInt(key, defaultvalue);
    }

    public static synchronized long getDefaultLong(String key, long defaultvalue) {
        return contexts[0].getNode(fQualifier).getLong(key, defaultvalue);
    }

    public static synchronized String getDefaultString(String key, String defaultvalue) {
        return contexts[0].getNode(fQualifier).get(key, defaultvalue);
    }

    public static double getDouble(String key) {
        return Platform.getPreferencesService().getDouble(fQualifier, key, 0.0, null);
    }

    public static float getFloat(String key) {
        return Platform.getPreferencesService().getFloat(fQualifier, key, 0.0f, null);
    }

    public static int getInt(String key) {
        return Platform.getPreferencesService().getInt(fQualifier, key, 0, null);
    }

    public static long getLong(String key) {
        return Platform.getPreferencesService().getLong(fQualifier, key, 0L, null);
    }

    public static String getString(String key) {
        return Platform.getPreferencesService().getString(fQualifier, key, null, null);
    }

    public static boolean isDefault(String name) {
        String defVal = contexts[0].getNode(fQualifier).get(name, null);
        if (defVal != null) {
            String val = contexts[1].getNode(fQualifier).get(name, null);
            return val != null && val.equals(defVal);
        }
        return false;
    }

    public static void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        contexts[0].getNode(fQualifier).removePreferenceChangeListener(listener);
        contexts[1].getNode(fQualifier).removePreferenceChangeListener(listener);
    }

    public static synchronized void savePreferences() {
        try {
            contexts[0].getNode(fQualifier).flush();
            contexts[1].getNode(fQualifier).flush();
        }
        catch (BackingStoreException bse) {
            RemoteCorePlugin.log(bse);
        }
    }

    public static synchronized void setBoolean(String key, boolean value) {
        contexts[1].getNode(fQualifier).putBoolean(key, value);
    }

    public static synchronized void setByteArray(String key, byte[] value) {
        contexts[1].getNode(fQualifier).putByteArray(key, value);
    }

    public static synchronized void setDefaultBoolean(String key, boolean value) {
        contexts[0].getNode(fQualifier).putBoolean(key, value);
    }

    public static synchronized void setDefaultByteArray(String key, byte[] value) {
        contexts[0].getNode(fQualifier).putByteArray(key, value);
    }

    public static synchronized void setDefaultDouble(String key, double value) {
        contexts[0].getNode(fQualifier).putDouble(key, value);
    }

    public static synchronized void setDefaultFloat(String key, float value) {
        contexts[0].getNode(fQualifier).putFloat(key, value);
    }

    public static synchronized void setDefaultInt(String key, int value) {
        contexts[0].getNode(fQualifier).putInt(key, value);
    }

    public static synchronized void setDefaultLong(String key, long value) {
        contexts[0].getNode(fQualifier).putLong(key, value);
    }

    public static synchronized void setDefaultString(String key, String value) {
        contexts[0].getNode(fQualifier).put(key, value);
    }

    public static synchronized void setDouble(String key, double value) {
        contexts[1].getNode(fQualifier).putDouble(key, value);
    }

    public static synchronized void setFloat(String key, float value) {
        contexts[1].getNode(fQualifier).putFloat(key, value);
    }

    public static synchronized void setInt(String key, int value) {
        contexts[1].getNode(fQualifier).putInt(key, value);
    }

    public static synchronized void setLong(String key, long value) {
        contexts[1].getNode(fQualifier).putLong(key, value);
    }

    public static synchronized void setString(String key, String value) {
        contexts[1].getNode(fQualifier).put(key, value);
    }

    public static synchronized void setToDefault(String key) {
        if (key != null) {
            contexts[1].getNode(fQualifier).remove(key);
        }
    }

    private Preferences() {
    }
}

