/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ConstantChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class InlineConstantRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_REMOVE = "remove";
    private int fSelectionStart;
    private int fSelectionLength;
    private IJavaScriptUnit fSelectionCu;
    private CompilationUnitRewrite fSelectionCuRewrite;
    private Name fSelectedConstantName;
    private IField fField;
    private CompilationUnitRewrite fDeclarationCuRewrite;
    private VariableDeclarationFragment fDeclaration;
    private boolean fDeclarationSelected;
    private boolean fDeclarationSelectedChecked = false;
    private boolean fInitializerAllStaticFinal;
    private boolean fInitializerChecked = false;
    private boolean fRemoveDeclaration = false;
    private boolean fReplaceAllReferences = true;
    private CompilationUnitChange[] fChanges;

    private static SimpleName getLeftmost(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        return InlineConstantRefactoring.getLeftmost(((QualifiedName)name).getQualifier());
    }

    public InlineConstantRefactoring(IField field) {
        Assert.isNotNull((Object)field);
        Assert.isTrue((!field.isBinary() ? 1 : 0) != 0);
        this.fField = field;
    }

    public InlineConstantRefactoring(IJavaScriptUnit unit, JavaScriptUnit node, int selectionStart, int selectionLength) {
        Assert.isTrue((selectionStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((selectionLength >= 0 ? 1 : 0) != 0);
        this.fSelectionCu = unit;
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        if (unit != null) {
            this.initialize(unit, node);
        }
    }

    private void initialize(IJavaScriptUnit cu, JavaScriptUnit node) {
        this.fSelectionCuRewrite = new CompilationUnitRewrite(cu, node);
        this.fSelectedConstantName = this.findConstantNameNode();
    }

    private Name findConstantNameNode() {
        ASTNode node = NodeFinder.perform((ASTNode)this.fSelectionCuRewrite.getRoot(), this.fSelectionStart, this.fSelectionLength);
        if (node == null) {
            return null;
        }
        if (node instanceof FieldAccess) {
            node = ((FieldAccess)node).getName();
        }
        if (!(node instanceof Name)) {
            return null;
        }
        Name name = (Name)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return null;
        }
        int modifiers = binding.getModifiers();
        if (!Modifier.isStatic((int)modifiers) || !Modifier.isFinal((int)modifiers)) {
            return null;
        }
        return name;
    }

    public RefactoringStatus checkStaticFinalConstantNameSelected() {
        if (this.fSelectedConstantName == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_static_final_field, null, (String)Corext.getPluginId(), (int)128, null);
        }
        return new RefactoringStatus();
    }

    public String getName() {
        return RefactoringCoreMessages.InlineConstantRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask("", 3);
            if (!this.fSelectionCu.isStructureKnown()) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_syntax_errors, null, (String)Corext.getPluginId(), (int)129, null);
                return refactoringStatus;
            }
            RefactoringStatus result = this.checkStaticFinalConstantNameSelected();
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            result.merge(this.findField());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.findDeclaration());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            result.merge(this.checkInitializer());
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus findField() throws JavaScriptModelException {
        this.fField = (IField)((IVariableBinding)this.fSelectedConstantName.resolveBinding()).getJavaElement();
        if (this.fField != null && !this.fField.exists()) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_local_anonymous_unsupported, null, (String)Corext.getPluginId(), (int)132, null);
        }
        return null;
    }

    private RefactoringStatus findDeclaration() throws JavaScriptModelException {
        VariableDeclarationFragment parentDeclaration;
        this.fDeclarationSelectedChecked = true;
        this.fDeclarationSelected = false;
        ASTNode parent = this.fSelectedConstantName.getParent();
        if (parent instanceof VariableDeclarationFragment && (parentDeclaration = (VariableDeclarationFragment)parent).getName() == this.fSelectedConstantName) {
            this.fDeclarationSelected = true;
            this.fDeclarationCuRewrite = this.fSelectionCuRewrite;
            this.fDeclaration = (VariableDeclarationFragment)this.fSelectedConstantName.getParent();
            return null;
        }
        VariableDeclarationFragment declaration = (VariableDeclarationFragment)this.fSelectionCuRewrite.getRoot().findDeclaringNode(this.fSelectedConstantName.resolveBinding());
        if (declaration != null) {
            this.fDeclarationCuRewrite = this.fSelectionCuRewrite;
            this.fDeclaration = declaration;
            return null;
        }
        if (this.fField.getJavaScriptUnit() == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_binary_file, null, (String)Corext.getPluginId(), (int)130, null);
        }
        this.fDeclarationCuRewrite = new CompilationUnitRewrite(this.fField.getJavaScriptUnit());
        this.fDeclaration = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(this.fField, this.fDeclarationCuRewrite.getRoot());
        return null;
    }

    private RefactoringStatus checkInitializer() {
        Expression initializer = this.getInitializer();
        if (initializer == null) {
            return RefactoringStatus.createStatus((int)4, (String)RefactoringCoreMessages.InlineConstantRefactoring_blank_finals, null, (String)Corext.getPluginId(), (int)131, null);
        }
        this.fInitializerAllStaticFinal = ConstantChecks.isStaticFinalConstant((IExpressionFragment)ASTFragmentFactory.createFragmentForFullSubtree((ASTNode)initializer));
        this.fInitializerChecked = true;
        return new RefactoringStatus();
    }

    private VariableDeclarationFragment getDeclaration() throws JavaScriptModelException {
        return this.fDeclaration;
    }

    private Expression getInitializer() {
        return this.fDeclaration.getInitializer();
    }

    private IJavaScriptUnit getDeclaringCompilationUnit() throws JavaScriptModelException {
        return this.fField.getJavaScriptUnit();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask("", 3);
        try {
            CompilationUnitChange change2;
            ArrayList<CompilationUnitChange> changes = new ArrayList<CompilationUnitChange>();
            HashSet staticImportsInInitializer = new HashSet();
            ImportReferencesCollector importReferencesCollector = new ImportReferencesCollector(this.fField.getJavaScriptProject(), null, new ArrayList(), staticImportsInInitializer);
            this.getInitializer().accept((ASTVisitor)importReferencesCollector);
            if (this.getReplaceAllReferences()) {
                SearchResultGroup[] searchResultGroups = this.findReferences(pm, result);
                int i = 0;
                while (i < searchResultGroups.length) {
                    if (pm.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    SearchResultGroup group = searchResultGroups[i];
                    IJavaScriptUnit cu = group.getCompilationUnit();
                    CompilationUnitRewrite cuRewrite = this.getCuRewrite(cu);
                    Name[] references = this.extractReferenceNodes(group.getSearchResults(), cuRewrite.getRoot());
                    InlineTargetCompilationUnit targetCompilationUnit = new InlineTargetCompilationUnit(cuRewrite, references, this, staticImportsInInitializer);
                    changes.add(targetCompilationUnit.getChange());
                    ++i;
                }
            } else {
                Assert.isTrue((!this.isDeclarationSelected() ? 1 : 0) != 0);
                InlineTargetCompilationUnit targetForOnlySelectedReference = new InlineTargetCompilationUnit(this.fSelectionCuRewrite, new Name[]{this.fSelectedConstantName}, this, staticImportsInInitializer);
                changes.add(targetForOnlySelectedReference.getChange());
            }
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (this.getRemoveDeclaration() && this.getReplaceAllReferences()) {
                InlineTargetCompilationUnit targetForDeclaration;
                boolean declarationRemoved = false;
                for (CompilationUnitChange change2 : changes) {
                    if (!change2.getCompilationUnit().equals(this.fDeclarationCuRewrite.getCu())) continue;
                    declarationRemoved = true;
                    break;
                }
                if (!declarationRemoved && (change2 = (targetForDeclaration = new InlineTargetCompilationUnit(this.fDeclarationCuRewrite, new Name[0], this, staticImportsInInitializer)).getChange()) != null) {
                    changes.add(change2);
                }
            }
            IJavaScriptUnit[] cus = new IJavaScriptUnit[changes.size()];
            int i = 0;
            while (i < changes.size()) {
                change2 = (CompilationUnitChange)((Object)changes.get(i));
                cus[i] = change2.getCompilationUnit();
                ++i;
            }
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(cus), this.getValidationContext()));
            pm.worked(1);
            this.fChanges = changes.toArray(new CompilationUnitChange[changes.size()]);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            this.fSelectionCuRewrite = null;
            this.fSelectedConstantName = null;
            this.fDeclarationCuRewrite = null;
            this.fDeclaration = null;
            pm.done();
        }
    }

    private Name[] extractReferenceNodes(SearchMatch[] searchResults, JavaScriptUnit cuNode) {
        Name[] references = new Name[searchResults.length];
        int i = 0;
        while (i < searchResults.length) {
            references[i] = (Name)NodeFinder.perform((ASTNode)cuNode, searchResults[i].getOffset(), searchResults[i].getLength());
            ++i;
        }
        return references;
    }

    private CompilationUnitRewrite getCuRewrite(IJavaScriptUnit cu) {
        CompilationUnitRewrite cuRewrite = cu.equals(this.fSelectionCu) ? this.fSelectionCuRewrite : (cu.equals(this.fField.getJavaScriptUnit()) ? this.fDeclarationCuRewrite : new CompilationUnitRewrite(cu));
        return cuRewrite;
    }

    private SearchResultGroup[] findReferences(IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaScriptElement)this.fField, (int)2));
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaScriptElement)this.fField));
        engine.setStatus(status);
        engine.setRequestor(new IRefactoringSearchRequestor(){

            @Override
            public SearchMatch acceptSearchMatch(SearchMatch match) {
                return match.isInsideDocComment() ? null : match;
            }
        });
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        return (SearchResultGroup[])engine.getResults();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.InlineConstantRefactoring_preview, 2);
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            IJavaScriptProject javaProject = this.fSelectionCu.getJavaScriptProject();
            if (javaProject != null) {
                project = javaProject.getElementName();
            }
            int flags = 786434;
            try {
                if (!Flags.isPrivate((int)this.fField.getFlags())) {
                    flags |= 4;
                }
            }
            catch (JavaScriptModelException exception) {
                JavaScriptPlugin.log(exception);
            }
            String description = Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_descriptor_description_short, this.fField.getElementName());
            String header = Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fField, 2235681801344L), JavaScriptElementLabels.getElementLabel(this.fField.getParent(), 2235681801344L)});
            JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
            comment.addSetting(Messages.format(RefactoringCoreMessages.InlineConstantRefactoring_original_pattern, JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fField, 2235681801344L)));
            if (this.fRemoveDeclaration) {
                comment.addSetting(RefactoringCoreMessages.InlineConstantRefactoring_remove_declaration);
            }
            if (this.fReplaceAllReferences) {
                comment.addSetting(RefactoringCoreMessages.InlineConstantRefactoring_replace_references);
            }
            JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.inline.constant", project, description, comment.asString(), arguments, flags);
            arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fSelectionCu));
            arguments.put("selection", String.valueOf(Integer.valueOf(this.fSelectionStart).toString()) + " " + Integer.valueOf(this.fSelectionLength).toString());
            arguments.put(ATTRIBUTE_REMOVE, Boolean.valueOf(this.fRemoveDeclaration).toString());
            arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceAllReferences).toString());
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.InlineConstantRefactoring_inline, (Change[])this.fChanges);
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
            this.fChanges = null;
        }
    }

    private void checkInvariant() {
        if (this.isDeclarationSelected()) {
            Assert.isTrue((boolean)this.fReplaceAllReferences);
        }
    }

    public boolean getRemoveDeclaration() {
        return this.fRemoveDeclaration;
    }

    public boolean getReplaceAllReferences() {
        this.checkInvariant();
        return this.fReplaceAllReferences;
    }

    public boolean isDeclarationSelected() {
        Assert.isTrue((boolean)this.fDeclarationSelectedChecked);
        return this.fDeclarationSelected;
    }

    public boolean isInitializerAllStaticFinal() {
        Assert.isTrue((boolean)this.fInitializerChecked);
        return this.fInitializerAllStaticFinal;
    }

    public void setRemoveDeclaration(boolean removeDeclaration) {
        this.fRemoveDeclaration = removeDeclaration;
    }

    public void setReplaceAllReferences(boolean replaceAllReferences) {
        this.fReplaceAllReferences = replaceAllReferences;
        this.checkInvariant();
    }

    @Override
    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String remove;
        if (arguments instanceof JavaRefactoringArguments) {
            String handle;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String selection = extended.getAttribute("selection");
            if (selection != null) {
                int offset = -1;
                int length = -1;
                StringTokenizer tokenizer = new StringTokenizer(selection);
                if (tokenizer.hasMoreTokens()) {
                    offset = Integer.valueOf(tokenizer.nextToken());
                }
                if (tokenizer.hasMoreTokens()) {
                    length = Integer.valueOf(tokenizer.nextToken());
                }
                if (offset >= 0 && length >= 0) {
                    this.fSelectionStart = offset;
                    this.fSelectionLength = length;
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
                }
            }
            if ((handle = extended.getAttribute("input")) != null) {
                IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists()) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.inline.constant");
                }
                if (element instanceof IJavaScriptUnit) {
                    this.fSelectionCu = (IJavaScriptUnit)element;
                    if (selection == null) {
                        return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
                    }
                } else if (element instanceof IField) {
                    IField field = (IField)element;
                    try {
                        ISourceRange range = field.getNameRange();
                        if (range == null) {
                            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "org.eclipse.wst.jsdt.ui.inline.constant"));
                        }
                        this.fSelectionStart = range.getOffset();
                        this.fSelectionLength = range.getLength();
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.inline.constant");
                    }
                    this.fSelectionCu = field.getJavaScriptUnit();
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{handle, "input"}));
                }
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setResolveBindings(true);
                parser.setSource(this.fSelectionCu);
                JavaScriptUnit unit = (JavaScriptUnit)parser.createAST(null);
                this.initialize(this.fSelectionCu, unit);
                if (this.checkStaticFinalConstantNameSelected().hasFatalError()) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.inline.constant");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            String replace = extended.getAttribute(ATTRIBUTE_REPLACE);
            if (replace == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
            }
            this.fReplaceAllReferences = Boolean.valueOf(replace);
            remove = extended.getAttribute(ATTRIBUTE_REMOVE);
            if (remove == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REMOVE));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fRemoveDeclaration = Boolean.valueOf(remove);
        return new RefactoringStatus();
    }

    private static class InlineTargetCompilationUnit {
        private final Expression fInitializer;
        private final IJavaScriptUnit fInitializerUnit;
        private final VariableDeclarationFragment fOriginalDeclaration;
        private final Expression[] fReferences;
        private final VariableDeclarationFragment fDeclarationToRemove;
        private final CompilationUnitRewrite fCuRewrite;
        private final TightSourceRangeComputer fSourceRangeComputer;
        private final HashSet fStaticImportsInInitializer;
        private final boolean fIs15;

        private InlineTargetCompilationUnit(CompilationUnitRewrite cuRewrite, Name[] references, InlineConstantRefactoring refactoring, HashSet staticImportsInInitializer) throws JavaScriptModelException {
            this.fInitializer = refactoring.getInitializer();
            this.fInitializerUnit = refactoring.getDeclaringCompilationUnit();
            this.fCuRewrite = cuRewrite;
            this.fSourceRangeComputer = new TightSourceRangeComputer();
            this.fCuRewrite.getASTRewrite().setTargetSourceRangeComputer((TargetSourceRangeComputer)this.fSourceRangeComputer);
            this.fDeclarationToRemove = refactoring.getRemoveDeclaration() && refactoring.getReplaceAllReferences() && cuRewrite.getCu().equals(this.fInitializerUnit) ? refactoring.getDeclaration() : null;
            this.fOriginalDeclaration = refactoring.getDeclaration();
            this.fReferences = new Expression[references.length];
            int i = 0;
            while (i < references.length) {
                this.fReferences[i] = InlineTargetCompilationUnit.getQualifiedReference(references[i]);
                ++i;
            }
            this.fIs15 = JavaModelUtil.is50OrHigher(cuRewrite.getCu().getJavaScriptProject());
            this.fStaticImportsInInitializer = this.fIs15 ? staticImportsInInitializer : new HashSet(0);
        }

        private static Expression getQualifiedReference(Name fieldName) {
            if (InlineTargetCompilationUnit.doesParentQualify(fieldName)) {
                return (Expression)fieldName.getParent();
            }
            return fieldName;
        }

        private static boolean doesParentQualify(Name fieldName) {
            ASTNode parent = fieldName.getParent();
            Assert.isNotNull((Object)parent);
            if (parent instanceof FieldAccess && ((FieldAccess)parent).getName() == fieldName) {
                return true;
            }
            if (parent instanceof QualifiedName && ((QualifiedName)parent).getName() == fieldName) {
                return true;
            }
            return parent instanceof FunctionInvocation && ((FunctionInvocation)parent).getName() == fieldName;
        }

        public CompilationUnitChange getChange() throws CoreException {
            int i = 0;
            while (i < this.fReferences.length) {
                this.inlineReference(this.fReferences[i]);
                ++i;
            }
            this.removeConstantDeclarationIfNecessary();
            return this.fCuRewrite.createChange();
        }

        private void inlineReference(Expression reference) throws CoreException {
            ASTNode importDecl = ASTNodes.getParent((ASTNode)reference, ImportDeclaration.class);
            if (importDecl != null) {
                return;
            }
            String modifiedInitializer = this.prepareInitializerForLocation(reference);
            if (modifiedInitializer == null) {
                return;
            }
            TextEditGroup msg = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.InlineConstantRefactoring_Inline);
            Expression newReference = (Expression)this.fCuRewrite.getASTRewrite().createStringPlaceholder(modifiedInitializer, reference.getNodeType());
            if (this.fInitializer instanceof ArrayInitializer) {
                ArrayCreation arrayCreation = this.fCuRewrite.getAST().newArrayCreation();
                ArrayType arrayType = (ArrayType)ASTNodeFactory.newType(this.fCuRewrite.getAST(), (VariableDeclaration)this.fOriginalDeclaration);
                arrayCreation.setType(arrayType);
                ArrayInitializer newArrayInitializer = (ArrayInitializer)this.fCuRewrite.getASTRewrite().createStringPlaceholder(modifiedInitializer, 4);
                arrayCreation.setInitializer(newArrayInitializer);
                newReference = arrayCreation;
                ITypeBinding typeToAddToImport = ASTNodes.getType((VariableDeclaration)this.fOriginalDeclaration).resolveBinding();
                this.fCuRewrite.getImportRewrite().addImport(typeToAddToImport);
                this.fCuRewrite.getImportRemover().registerAddedImport(typeToAddToImport.getName());
            }
            if (InlineTargetCompilationUnit.shouldParenthesizeSubstitute(this.fInitializer, reference)) {
                ParenthesizedExpression parenthesized = this.fCuRewrite.getAST().newParenthesizedExpression();
                parenthesized.setExpression(newReference);
                newReference = parenthesized;
            }
            this.fCuRewrite.getASTRewrite().replace((ASTNode)reference, (ASTNode)newReference, msg);
            this.fSourceRangeComputer.addTightSourceNode((ASTNode)reference);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)reference);
        }

        private String prepareInitializerForLocation(Expression location) throws CoreException {
            HashSet staticImportsInReference = new HashSet();
            IJavaScriptProject project = this.fCuRewrite.getCu().getJavaScriptProject();
            if (this.fIs15) {
                location.accept((ASTVisitor)new ImportReferencesCollector(project, null, new ArrayList(), staticImportsInReference));
            }
            InitializerTraversal traversal = new InitializerTraversal(this.fInitializer, this.fStaticImportsInInitializer, location, staticImportsInReference, this.fCuRewrite);
            ASTRewrite initializerRewrite = traversal.getInitializerRewrite();
            Document document = new Document(this.fInitializerUnit.getBuffer().getContents());
            RangeMarker marker = new RangeMarker(this.fInitializer.getStartPosition(), this.fInitializer.getLength());
            TextEdit[] rewriteEdits = initializerRewrite.rewriteAST((IDocument)document, this.fInitializerUnit.getJavaScriptProject().getOptions(true)).removeChildren();
            marker.addChildren(rewriteEdits);
            try {
                marker.apply((IDocument)document, 2);
                String rewrittenInitializer = document.get(marker.getOffset(), marker.getLength());
                IRegion region = document.getLineInformation(document.getLineOfOffset(marker.getOffset()));
                int oldIndent = Strings.computeIndentUnits(document.get(region.getOffset(), region.getLength()), project);
                return Strings.changeIndent(rewrittenInitializer, oldIndent, project, "", TextUtilities.getDefaultLineDelimiter((IDocument)document));
            }
            catch (MalformedTreeException e) {
                JavaScriptPlugin.log(e);
            }
            catch (BadLocationException e) {
                JavaScriptPlugin.log(e);
            }
            return this.fInitializerUnit.getBuffer().getText(this.fInitializer.getStartPosition(), this.fInitializer.getLength());
        }

        private static boolean shouldParenthesizeSubstitute(Expression substitute, Expression location) {
            if (substitute instanceof Assignment) {
                return true;
            }
            return ASTNodes.substituteMustBeParenthesized(substitute, location);
        }

        private void removeConstantDeclarationIfNecessary() throws CoreException {
            if (this.fDeclarationToRemove == null) {
                return;
            }
            FieldDeclaration parentDeclaration = (FieldDeclaration)this.fDeclarationToRemove.getParent();
            Object toRemove = parentDeclaration.fragments().size() == 1 ? parentDeclaration : this.fDeclarationToRemove;
            TextEditGroup msg = this.fCuRewrite.createGroupDescription(RefactoringCoreMessages.InlineConstantRefactoring_remove_declaration);
            this.fCuRewrite.getASTRewrite().remove((ASTNode)toRemove, msg);
            this.fCuRewrite.getImportRemover().registerRemovedNode((ASTNode)toRemove);
        }

        private static class InitializerTraversal
        extends HierarchicalASTVisitor {
            private final Expression fInitializer;
            private ASTRewrite fInitializerRewrite;
            private final HashSet fStaticImportsInInitializer2;
            private Set fNamesDeclaredLocallyAtNewLocation;
            private final Expression fNewLocation;
            private final HashSet fStaticImportsInReference;
            private final CompilationUnitRewrite fNewLocationCuRewrite;

            private static boolean areInSameType(ASTNode one, ASTNode other) {
                ASTNode onesContainer = InitializerTraversal.getContainingTypeDeclaration(one);
                ASTNode othersContainer = InitializerTraversal.getContainingTypeDeclaration(other);
                if (onesContainer == null || othersContainer == null) {
                    return false;
                }
                ITypeBinding onesContainerBinding = InitializerTraversal.getTypeBindingForTypeDeclaration(onesContainer);
                ITypeBinding othersContainerBinding = InitializerTraversal.getTypeBindingForTypeDeclaration(othersContainer);
                Assert.isNotNull((Object)onesContainerBinding);
                Assert.isNotNull((Object)othersContainerBinding);
                String onesKey = onesContainerBinding.getKey();
                String othersKey = othersContainerBinding.getKey();
                if (onesKey == null || othersKey == null) {
                    return false;
                }
                return onesKey.equals(othersKey);
            }

            private static boolean isStaticAccess(SimpleName memberName) {
                IBinding binding = memberName.resolveBinding();
                Assert.isTrue((binding instanceof IVariableBinding || binding instanceof IFunctionBinding || binding instanceof ITypeBinding ? 1 : 0) != 0);
                if (binding instanceof ITypeBinding) {
                    return true;
                }
                if (binding instanceof IVariableBinding) {
                    return ((IVariableBinding)binding).isField();
                }
                int modifiers = binding.getModifiers();
                return Modifier.isStatic((int)modifiers);
            }

            private static ASTNode getContainingTypeDeclaration(ASTNode node) {
                while (node != null && !(node instanceof AbstractTypeDeclaration) && !(node instanceof AnonymousClassDeclaration)) {
                    node = node.getParent();
                }
                return node;
            }

            private static ITypeBinding getTypeBindingForTypeDeclaration(ASTNode declaration) {
                if (declaration instanceof AnonymousClassDeclaration) {
                    return ((AnonymousClassDeclaration)declaration).resolveBinding();
                }
                if (declaration instanceof AbstractTypeDeclaration) {
                    return ((AbstractTypeDeclaration)declaration).resolveBinding();
                }
                Assert.isTrue((boolean)false);
                return null;
            }

            public InitializerTraversal(Expression initializer, HashSet staticImportsInInitializer, Expression newLocation, HashSet staticImportsInReference, CompilationUnitRewrite newLocationCuRewrite) {
                this.fInitializer = initializer;
                this.fInitializerRewrite = ASTRewrite.create((AST)initializer.getAST());
                this.fStaticImportsInInitializer2 = staticImportsInInitializer;
                this.fNewLocation = newLocation;
                this.fStaticImportsInReference = staticImportsInReference;
                this.fNewLocationCuRewrite = newLocationCuRewrite;
                this.perform(initializer);
            }

            private Set getLocallyDeclaredNames(BodyDeclaration scope) {
                Assert.isTrue((!(scope instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
                final HashSet result = new HashSet();
                if (scope instanceof FieldDeclaration) {
                    return result;
                }
                scope.accept((ASTVisitor)new HierarchicalASTVisitor(){

                    @Override
                    public boolean visit(AbstractTypeDeclaration node) {
                        Assert.isTrue((boolean)(node.getParent() instanceof TypeDeclarationStatement));
                        result.add(node.getName().getIdentifier());
                        return false;
                    }

                    @Override
                    public boolean visit(AnonymousClassDeclaration anonDecl) {
                        return false;
                    }

                    @Override
                    public boolean visit(VariableDeclaration varDecl) {
                        result.add(varDecl.getName().getIdentifier());
                        return false;
                    }
                });
                return result;
            }

            public ASTRewrite getInitializerRewrite() {
                return this.fInitializerRewrite;
            }

            private void perform(Expression initializer) {
                initializer.accept((ASTVisitor)this);
                if (initializer instanceof FunctionInvocation || initializer instanceof SuperMethodInvocation) {
                    this.addExplicitTypeArgumentsIfNecessary(initializer);
                }
            }

            private void addExplicitTypeArgumentsIfNecessary(Expression invocation) {
                ASTNode referenceContext;
                if (Invocations.isResolvedTypeInferredFromExpectedType(invocation) && !((referenceContext = this.fNewLocation.getParent()) instanceof VariableDeclarationFragment) && !(referenceContext instanceof SingleVariableDeclaration) && !(referenceContext instanceof Assignment)) {
                    Invocations.resolveBinding((ASTNode)invocation);
                }
            }

            @Override
            public boolean visit(FieldAccess fieldAccess) {
                fieldAccess.getExpression().accept((ASTVisitor)this);
                return false;
            }

            @Override
            public boolean visit(FunctionInvocation invocation) {
                if (invocation.getExpression() == null) {
                    this.qualifyUnqualifiedMemberNameIfNecessary(invocation.getName());
                } else {
                    invocation.getExpression().accept((ASTVisitor)this);
                }
                Iterator it = invocation.arguments().iterator();
                while (it.hasNext()) {
                    ((Expression)it.next()).accept((ASTVisitor)this);
                }
                return false;
            }

            @Override
            public boolean visit(Name name) {
                SimpleName leftmost = InlineConstantRefactoring.getLeftmost(name);
                IBinding leftmostBinding = leftmost.resolveBinding();
                if (leftmostBinding instanceof IVariableBinding || leftmostBinding instanceof IFunctionBinding || leftmostBinding instanceof ITypeBinding) {
                    if (this.shouldUnqualify(leftmost)) {
                        this.unqualifyMemberName(leftmost);
                    } else {
                        this.qualifyUnqualifiedMemberNameIfNecessary(leftmost);
                    }
                }
                if (leftmostBinding instanceof ITypeBinding) {
                    String addedImport = this.fNewLocationCuRewrite.getImportRewrite().addImport((ITypeBinding)leftmostBinding);
                    this.fNewLocationCuRewrite.getImportRemover().registerAddedImport(addedImport);
                }
                return false;
            }

            private void qualifyUnqualifiedMemberNameIfNecessary(SimpleName memberName) {
                if (this.shouldQualify(memberName)) {
                    this.qualifyMemberName(memberName);
                }
            }

            private boolean shouldUnqualify(SimpleName memberName) {
                if (InitializerTraversal.areInSameType((ASTNode)memberName, (ASTNode)this.fNewLocation)) {
                    return !this.mayBeShadowedByLocalDeclaration(memberName);
                }
                return false;
            }

            private void unqualifyMemberName(SimpleName memberName) {
                if (InlineTargetCompilationUnit.doesParentQualify((Name)memberName)) {
                    this.fInitializerRewrite.replace(memberName.getParent(), (ASTNode)memberName, null);
                }
            }

            private boolean shouldQualify(SimpleName memberName) {
                if (!InitializerTraversal.areInSameType((ASTNode)this.fInitializer, (ASTNode)this.fNewLocation)) {
                    return true;
                }
                return this.mayBeShadowedByLocalDeclaration(memberName);
            }

            private boolean mayBeShadowedByLocalDeclaration(SimpleName memberName) {
                return this.getNamesDeclaredLocallyAtNewLocation().contains(memberName.getIdentifier());
            }

            private Set getNamesDeclaredLocallyAtNewLocation() {
                if (this.fNamesDeclaredLocallyAtNewLocation != null) {
                    return this.fNamesDeclaredLocallyAtNewLocation;
                }
                BodyDeclaration enclosingBodyDecl = (BodyDeclaration)ASTNodes.getParent((ASTNode)this.fNewLocation, BodyDeclaration.class);
                Assert.isTrue((!(enclosingBodyDecl instanceof AbstractTypeDeclaration) ? 1 : 0) != 0);
                this.fNamesDeclaredLocallyAtNewLocation = this.getLocallyDeclaredNames(enclosingBodyDecl);
                return this.fNamesDeclaredLocallyAtNewLocation;
            }

            private void qualifyMemberName(SimpleName memberName) {
                if (InitializerTraversal.isStaticAccess(memberName)) {
                    IBinding memberBinding = memberName.resolveBinding();
                    if (memberBinding instanceof IVariableBinding || memberBinding instanceof IFunctionBinding) {
                        if (this.fStaticImportsInReference.contains(this.fNewLocation)) {
                            this.importStatically(memberName, memberBinding);
                            return;
                        }
                        if (this.fStaticImportsInInitializer2.contains(memberName)) {
                            this.importStatically(memberName, memberBinding);
                            return;
                        }
                    }
                    this.qualifyToTopLevelClass(memberName);
                }
            }

            private void importStatically(SimpleName toImport, IBinding binding) {
                String newName = this.fNewLocationCuRewrite.getImportRewrite().addStaticImport(binding);
                this.fNewLocationCuRewrite.getImportRemover().registerAddedStaticImport(binding);
                Name newReference = ASTNodeFactory.newName(this.fInitializerRewrite.getAST(), newName);
                this.fInitializerRewrite.replace((ASTNode)toImport, (ASTNode)newReference, null);
            }

            private void qualifyToTopLevelClass(SimpleName toQualify) {
                ITypeBinding declaringClass = InitializerTraversal.getDeclaringClassBinding(toQualify);
                if (declaringClass == null) {
                    return;
                }
                Type newQualification = this.fNewLocationCuRewrite.getImportRewrite().addImport(declaringClass, this.fInitializerRewrite.getAST());
                this.fNewLocationCuRewrite.getImportRemover().registerAddedImports(newQualification);
                SimpleName newToQualify = (SimpleName)this.fInitializerRewrite.createMoveTarget((ASTNode)toQualify);
                QualifiedType newType = this.fInitializerRewrite.getAST().newQualifiedType(newQualification, newToQualify);
                this.fInitializerRewrite.replace((ASTNode)toQualify, (ASTNode)newType, null);
            }

            private static ITypeBinding getDeclaringClassBinding(SimpleName memberName) {
                IBinding binding = memberName.resolveBinding();
                if (binding instanceof IFunctionBinding) {
                    return ((IFunctionBinding)binding).getDeclaringClass();
                }
                if (binding instanceof IVariableBinding) {
                    return ((IVariableBinding)binding).getDeclaringClass();
                }
                if (binding instanceof ITypeBinding) {
                    return ((ITypeBinding)binding).getDeclaringClass();
                }
                Assert.isTrue((boolean)false);
                return null;
            }
        }
    }
}

