/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.connections.RosConnectionsStateProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.ConnectionEndpoint;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.IRosConnectionsModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.RosConnection;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.RosConnectionEndpoint;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class RosConnectionsModel
implements IRosConnectionsModel {
    private static final String TYPE_PUB_LINK = "TransportPublisherLink";
    private static final String TYPE_SUB_LINK = "TransportSubscriberLink";
    private List<RosConnection> fConnections = null;
    private final @NonNull ITmfStateSystem fSs;
    private final @NonNull IProgressMonitor fMon;

    public RosConnectionsModel(@NonNull ITmfStateSystem stateSystem, @NonNull IProgressMonitor monitor) {
        this.fSs = stateSystem;
        this.fMon = monitor;
    }

    @Override
    public void generateModel() {
        try {
            ArrayList<RosConnectionEndpoint> connectionsInfoPub = new ArrayList<RosConnectionEndpoint>();
            HashMap<Pair<ConnectionEndpoint, String>, RosConnectionEndpoint> connectionsInfoSub = new HashMap<Pair<ConnectionEndpoint, String>, RosConnectionEndpoint>();
            if (this.fMon.isCanceled()) {
                return;
            }
            RosConnectionsModel.gatherConnectionInfo(this.fSs, connectionsInfoPub, connectionsInfoSub);
            if (this.fMon.isCanceled()) {
                return;
            }
            this.fConnections = RosConnectionsModel.linkConnectionInfo(connectionsInfoPub, connectionsInfoSub);
            if (connectionsInfoPub.size() != connectionsInfoSub.size()) {
                Activator.getInstance().logWarning("Number of publisher connection info and subscriber connection info do not match!");
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {}
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void gatherConnectionInfo(ITmfStateSystem ss, List<RosConnectionEndpoint> connectionsInfoPub, Map<Pair<ConnectionEndpoint, String>, RosConnectionEndpoint> connectionsInfoSub) throws IndexOutOfBoundsException, TimeRangeException, StateSystemDisposedException {
        @NonNull List nodeQuarks = ss.getSubAttributes(-1, false);
        for (Integer nodeQuark : nodeQuarks) {
            String nodeName = ss.getAttributeName(nodeQuark.intValue());
            @NonNull List typeQuarks = ss.getSubAttributes(nodeQuark.intValue(), false);
            for (Integer typeQuark : typeQuarks) {
                String type = ss.getAttributeName(typeQuark.intValue());
                if (!type.equals(TYPE_PUB_LINK) && !type.equals(TYPE_SUB_LINK)) continue;
                boolean isPubSide = type.equals(TYPE_SUB_LINK);
                @NonNull List topicQuarks = ss.getSubAttributes(typeQuark.intValue(), false);
                for (Integer topicQuark : topicQuarks) {
                    String topicName = ss.getAttributeName(topicQuark.intValue());
                    @NonNull List connectionQuarks = ss.getSubAttributes(topicQuark.intValue(), false);
                    for (Integer connectionQuark : connectionQuarks) {
                        @NonNull Iterable connectionIntervalsIter = ss.query2D(Collections.singleton(connectionQuark), ss.getStartTime(), ss.getCurrentEndTime());
                        @NonNull ArrayList connectionIntervals = Lists.newArrayList((Iterable)connectionIntervalsIter);
                        if (connectionIntervals.size() < 1) continue;
                        ITmfStateInterval connectionInterval = (ITmfStateInterval)connectionIntervals.get(1);
                        String hostsPorts = connectionInterval.getValueString();
                        @NonNull String[] localRemote = hostsPorts.split(RosConnectionsStateProvider.CONNECTION_HOST_SEPARATOR);
                        String localHostPort = localRemote[0];
                        ConnectionEndpoint localEndpoint = ConnectionEndpoint.fromStringFormat(localHostPort);
                        RosConnectionEndpoint local = new RosConnectionEndpoint(topicName, nodeName, localEndpoint, connectionInterval.getStartTime());
                        if (isPubSide) {
                            connectionsInfoPub.add(local);
                            continue;
                        }
                        String remoteHostPort = localRemote[1];
                        ConnectionEndpoint remoteEndpoint = ConnectionEndpoint.fromStringFormat(remoteHostPort);
                        connectionsInfoSub.put((Pair<ConnectionEndpoint, String>)new Pair((Object)remoteEndpoint, (Object)topicName), local);
                    }
                }
            }
        }
    }

    private static List<RosConnection> linkConnectionInfo(List<RosConnectionEndpoint> connectionsInfoPub, Map<Pair<ConnectionEndpoint, String>, RosConnectionEndpoint> connectionsInfoSub) {
        ArrayList<RosConnection> connections = new ArrayList<RosConnection>();
        for (RosConnectionEndpoint pubInfo : connectionsInfoPub) {
            RosConnectionEndpoint subInfo = connectionsInfoSub.get(new Pair((Object)pubInfo.getEndpoint(), (Object)pubInfo.getTopicName()));
            if (subInfo == null) {
                Activator.getInstance().logError("No connection info match!");
                continue;
            }
            connections.add(new RosConnection(pubInfo, subInfo));
        }
        return connections;
    }

    @Override
    public @Nullable Collection<RosConnection> getConnections() {
        return Collections.unmodifiableCollection(this.fConnections);
    }

    @Override
    public List<RosConnection> getNodeConnections(String nodeName) {
        return this.fConnections.stream().filter(c -> c.getPub().getNodeName().equals(nodeName) || c.getSub().getNodeName().equals(nodeName)).collect(Collectors.toList());
    }

    @Override
    public @Nullable RosConnection getConnection(ConnectionEndpoint endpoint, String topicName) {
        List connections = this.fConnections.stream().filter(c -> (c.getPub().getEndpoint().equals(endpoint) || c.getSub().getEndpoint().equals(endpoint)) && c.getPub().getTopicName().equals(topicName)).collect(Collectors.toList());
        if (connections.size() > 1) {
            Activator.getInstance().logError("Got more than 1 connection matching a host:port and topic name pair!");
        }
        return !connections.isEmpty() ? (RosConnection)connections.get(0) : null;
    }

    @Override
    public @Nullable RosConnection getConnectionFromNodePublishingOnTopic(String pubNodeName, String topicName) {
        List pubConnections = this.fConnections.stream().filter(c -> c.getPub().getNodeName().equals(pubNodeName) && c.getPub().getTopicName().equals(topicName)).collect(Collectors.toList());
        if (pubConnections.size() > 1) {
            Activator.getInstance().logError("Got more than 1 connection matching a node and published topic name pair!");
        }
        return !pubConnections.isEmpty() ? (RosConnection)pubConnections.get(0) : null;
    }

    @Override
    public @Nullable RosConnection getConnectionBetweenEndpoints(ConnectionEndpoint source, ConnectionEndpoint destination) {
        List connections = this.fConnections.stream().filter(c -> c.getPub().getEndpoint().equals(source) && c.getSub().getEndpoint().equals(destination)).collect(Collectors.toList());
        if (connections.size() > 1) {
            Activator.getInstance().logError("Got more than 1 connection matching a source+destination endpoints pair!");
        }
        return !connections.isEmpty() ? (RosConnection)connections.get(0) : null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RosConnectionsModel");
        b.append("\n");
        for (RosConnection connection : this.fConnections) {
            b.append("\t" + connection.toString());
        }
        return b.toString();
    }
}

