/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.core.data.provider;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class ScriptingDataProviderManager {
    public static final String PROVIDER_ID = "org.eclipse.tracecompass.incubator.scripting.dataprovider";
    private static @Nullable ScriptingDataProviderManager INSTANCE;
    private final Multimap<ITmfTrace, ITmfTreeDataProvider<? extends ITmfTreeDataModel>> fInstances = HashMultimap.create();

    public static synchronized ScriptingDataProviderManager getInstance() {
        ScriptingDataProviderManager instance = INSTANCE;
        if (instance == null) {
            INSTANCE = instance = new ScriptingDataProviderManager();
        }
        return instance;
    }

    public static synchronized void dispose() {
        ScriptingDataProviderManager manager = INSTANCE;
        if (manager != null) {
            TmfSignalManager.deregister((Object)manager);
            manager.fInstances.clear();
            INSTANCE = null;
        }
    }

    public ScriptingDataProviderManager() {
        TmfSignalManager.register((Object)this);
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> getProvider(ITmfTrace trace, String id) {
        Collection dps = this.fInstances.get((Object)trace);
        for (ITmfTreeDataProvider dataProvider : dps) {
            if (!dataProvider.getId().equals("org.eclipse.tracecompass.incubator.scripting.dataprovider:" + id)) continue;
            return dataProvider;
        }
        return null;
    }

    public void registerDataProvider(ITmfTrace trace, ITmfTreeDataProvider<? extends ITmfTreeDataModel> provider) {
        Collection dataProviders = this.fInstances.get((Object)trace);
        ITmfTreeDataProvider previous = null;
        for (ITmfTreeDataProvider dataProvider : dataProviders) {
            if (!provider.getId().equals(dataProvider.getId())) continue;
            previous = dataProvider;
            break;
        }
        if (previous != null) {
            this.fInstances.remove((Object)trace, previous);
            DataProviderManager.getInstance().removeDataProvider(trace, previous);
        }
        this.fInstances.put((Object)trace, provider);
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        new Thread(() -> {
            ScriptingDataProviderManager scriptingDataProviderManager = this;
            synchronized (scriptingDataProviderManager) {
                for (ITmfTrace trace : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)signal.getTrace())) {
                    this.fInstances.removeAll((Object)trace).forEach(ITmfTreeDataProvider::dispose);
                }
            }
        }).start();
    }

    public static String createProviderId(String providerName) {
        return "org.eclipse.tracecompass.incubator.scripting.dataprovider:" + providerName;
    }

    public static @Nullable String extractProviderName(String providerId) {
        int index = providerId.indexOf(":");
        if (index > 0 && index < providerId.length() - 1) {
            return providerId.substring(index + 1);
        }
        return null;
    }
}

