/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.event.matching;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.matching.IEventMatchingKey;
import org.eclipse.tracecompass.tmf.core.event.matching.ITmfMatchEventDefinition;
import org.eclipse.tracecompass.tmf.core.event.matching.TmfEventMatching;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;

public class TwoWayVmEventMatching
implements ITmfMatchEventDefinition {
    private static final String COUNTER_PAYLOAD = "cnt";
    private static final String VM_UID_PAYLOAD = "vm_uid";

    public @Nullable IEventMatchingKey getEventKey(@Nullable ITmfEvent event) {
        if (event == null) {
            return null;
        }
        String evname = event.getType().getName();
        QemuPacketKey key = null;
        if (evname.equals("vmsync_gh_host") || evname.equals("vmsync_hg_host")) {
            TmfEventField field = (TmfEventField)event.getContent();
            ITmfEventField data = field.getField(new String[]{VM_UID_PAYLOAD});
            if (data == null) {
                return null;
            }
            long vmUid = (Long)data.getValue();
            data = field.getField(new String[]{COUNTER_PAYLOAD});
            if (data == null) {
                return null;
            }
            long seqno = (Long)data.getValue();
            key = new QemuPacketKey(vmUid, seqno);
        } else if (evname.equals("vmsync_gh_guest") || evname.equals("vmsync_hg_guest")) {
            TmfEventField field = (TmfEventField)event.getContent();
            ITmfEventField data = field.getField(new String[]{VM_UID_PAYLOAD});
            if (data == null) {
                return null;
            }
            long vmUid = (Long)data.getValue();
            data = field.getField(new String[]{COUNTER_PAYLOAD});
            if (data == null) {
                return null;
            }
            long seqno = (Long)data.getValue();
            key = new QemuPacketKey(vmUid, seqno);
        }
        return key;
    }

    public boolean canMatchTrace(@Nullable ITmfTrace trace) {
        if (trace instanceof ITmfTraceWithPreDefinedEvents) {
            ImmutableSet events = ImmutableSet.of((Object)"vmsync_gh_host", (Object)"vmsync_gh_guest", (Object)"vmsync_hg_host", (Object)"vmsync_hg_guest");
            Set traceEvents = TmfEventTypeCollectionHelper.getEventNames((Iterable)((ITmfTraceWithPreDefinedEvents)trace).getContainedEventTypes());
            traceEvents.retainAll((Collection<?>)events);
            return !traceEvents.isEmpty();
        }
        return true;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TmfEventMatching.Direction getDirection(@Nullable ITmfEvent event) {
        if (event == null) {
            return null;
        }
        String evname = event.getType().getName();
        if ((evname.equals("vmsync_gh_host") || evname.equals("vmsync_hg_guest")) && TwoWayVmEventMatching.canMatchEvent(event)) {
            return TmfEventMatching.Direction.EFFECT;
        }
        if ((evname.equals("vmsync_gh_guest") || evname.equals("vmsync_hg_host")) && TwoWayVmEventMatching.canMatchEvent(event)) {
            return TmfEventMatching.Direction.CAUSE;
        }
        return null;
    }

    private static boolean canMatchEvent(ITmfEvent event) {
        ITmfEventField content;
        String evname = event.getType().getName();
        return (evname.equals("vmsync_gh_guest") || evname.equals("vmsync_gh_host") || evname.equals("vmsync_hg_guest") || evname.equals("vmsync_hg_host")) && (content = event.getContent()).getField(new String[]{VM_UID_PAYLOAD}) != null && content.getField(new String[]{COUNTER_PAYLOAD}) != null;
    }

    private static class QemuPacketKey
    implements IEventMatchingKey {
        private static HashFunction hf = Hashing.goodFastHash((int)32);
        private long vmUid;
        private long seq;

        public QemuPacketKey(long uid, long s) {
            this.vmUid = uid;
            this.seq = s;
        }

        public int hashCode() {
            return hf.newHasher(32).putLong(this.vmUid).putLong(this.seq).hash().asInt();
        }

        public boolean equals(@Nullable Object o) {
            if (o instanceof QemuPacketKey) {
                QemuPacketKey key = (QemuPacketKey)o;
                if (key.seq == this.seq && key.vmUid == this.vmUid) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "QemuPacketKey: " + this.vmUid + ':' + this.seq;
        }
    }
}

