/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;

public final class VirtualCPU {
    private static final Table<VirtualMachine, Long, @Nullable VirtualCPU> VIRTUAL_CPU_TABLE = HashBasedTable.create();
    private final VirtualMachine fVm;
    private final Long fCpuId;
    private Integer fCurrentState;
    private Integer fCurrentThread;
    private Integer fStateBeforeIRQ;
    private @Nullable VirtualCPU fNextLayerVCPU;

    public static synchronized VirtualCPU getVirtualCPU(VirtualMachine vm, Long cpu) {
        VirtualCPU ht = (VirtualCPU)VIRTUAL_CPU_TABLE.get((Object)vm, (Object)cpu);
        if (ht == null) {
            ht = new VirtualCPU(vm, cpu);
            VIRTUAL_CPU_TABLE.put((Object)vm, (Object)cpu, (Object)ht);
        }
        return ht;
    }

    public static synchronized @Nullable Map<Long, @Nullable VirtualCPU> getVirtualCPUs(VirtualMachine machine) {
        return VIRTUAL_CPU_TABLE.row((Object)machine);
    }

    private VirtualCPU(VirtualMachine vm, Long cpu) {
        this.fVm = vm;
        this.fCpuId = cpu;
        this.fCurrentState = 0;
        this.fCurrentThread = -1;
        this.fStateBeforeIRQ = 0;
        this.fNextLayerVCPU = null;
    }

    public Long getCpuId() {
        return this.fCpuId;
    }

    public VirtualMachine getVm() {
        return this.fVm;
    }

    public String toString() {
        return "VirtualCPU: [" + this.fVm + ',' + this.fCpuId + ']';
    }

    public Integer getCurrentState() {
        return this.fCurrentState;
    }

    public void setCurrentState(Integer currentState) {
        this.fCurrentState = currentState;
    }

    public Integer getCurrentThread() {
        return this.fCurrentThread;
    }

    public void setCurrentThread(Integer currentThread) {
        this.fCurrentThread = currentThread;
    }

    public Integer getStateBeforeIRQ() {
        return this.fStateBeforeIRQ;
    }

    public void setStateBeforeIRQ(Integer state) {
        this.fStateBeforeIRQ = state;
    }

    public void setNextLayerVCPU(VirtualCPU vcpu) {
        this.fNextLayerVCPU = vcpu;
    }

    public @Nullable VirtualCPU getNextLayerVCPU() {
        return this.fNextLayerVCPU;
    }
}

