/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import java.util.List;
import java.util.Objects;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SchedSwitchHandler
extends VMKernelEventHandler {
    public SchedSwitchHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        FusedVirtualMachineStateProvider sp = this.getStateProvider();
        VirtualMachine host = sp.getCurrentMachine(event);
        VirtualCPU cpuObject = VirtualCPU.getVirtualCPU(host, cpu.longValue());
        if (host != null && host.isGuest()) {
            Integer physicalCPU = sp.getPhysicalCPU(host, cpu);
            if (physicalCPU != null) {
                cpu = physicalCPU;
            } else {
                return;
            }
        }
        ITmfEventField content = event.getContent();
        Integer prevTid = ((Long)content.getField(new String[]{this.getLayout().fieldPrevTid()}).getValue()).intValue();
        Long prevState = Objects.requireNonNull((Long)content.getField(new String[]{this.getLayout().fieldPrevState()}).getValue());
        String nextProcessName = Objects.requireNonNull((String)content.getField(new String[]{this.getLayout().fieldNextComm()}).getValue());
        Integer nextTid = ((Long)content.getField(new String[]{this.getLayout().fieldNextTid()}).getValue()).intValue();
        Integer nextPrio = ((Long)content.getField(new String[]{this.getLayout().fieldNextPrio()}).getValue()).intValue();
        String machineHost = event.getTrace().getHostId();
        String formerThreadAttributeName = FusedVMEventHandlerUtils.buildThreadAttributeName(prevTid, cpu);
        String currenThreadAttributeName = FusedVMEventHandlerUtils.buildThreadAttributeName(nextTid, cpu);
        int nodeThreads = FusedVMEventHandlerUtils.getNodeThreads(ss);
        int formerThreadNode = ss.getQuarkRelativeAndAdd(nodeThreads, new String[]{machineHost, formerThreadAttributeName});
        int newCurrentThreadNode = ss.getQuarkRelativeAndAdd(nodeThreads, new String[]{machineHost, currenThreadAttributeName});
        int currentMachineQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Hosts", machineHost});
        int machineContainerQuark = ss.getQuarkRelativeAndAdd(currentMachineQuark, new String[]{"Containers"});
        long timestamp = FusedVMEventHandlerUtils.getTimestamp(event);
        SchedSwitchHandler.setOldProcessStatus(ss, prevState, formerThreadNode, timestamp);
        FusedVMEventHandlerUtils.setProcessToRunning(timestamp, newCurrentThreadNode, ss);
        SchedSwitchHandler.setNewProcessExecName(ss, nextProcessName, newCurrentThreadNode, timestamp);
        SchedSwitchHandler.setNewProcessPio(ss, nextPrio, newCurrentThreadNode, timestamp);
        ss.getQuarkRelativeAndAdd(newCurrentThreadNode, new String[]{"System_call"});
        ss.getQuarkRelativeAndAdd(newCurrentThreadNode, new String[]{"PPID"});
        int currentCPUNode = FusedVMEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        boolean modify = true;
        int machineNameQuark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Machine_name"});
        try {
            modify = ss.querySingleState(timestamp, machineNameQuark).getStateValue().unboxStr().equals(machineHost);
        }
        catch (StateSystemDisposedException e) {
            e.printStackTrace();
        }
        SchedSwitchHandler.setCpuProcess(ss, nextTid, timestamp, currentCPUNode, modify);
        int stateCpu = SchedSwitchHandler.setCpuStatus(ss, nextTid, newCurrentThreadNode, timestamp, currentCPUNode, modify);
        if (nextTid != 0) {
            List<Long> namespaces = FusedVMEventHandlerUtils.getProcessNSIDs(ss, newCurrentThreadNode);
            for (Long namespace : namespaces) {
                ss.getQuarkRelativeAndAdd(machineContainerQuark, new String[]{namespace.toString(), "pCPUs", cpu.toString()});
            }
        }
        cpuObject.setCurrentState(stateCpu);
        cpuObject.setCurrentThread(nextTid);
    }

    private static void setOldProcessStatus(ITmfStateSystemBuilder ss, Long prevState, Integer formerThreadNode, long timestamp) {
        int state = (int)(prevState & 0x3FFL);
        Object status = SchedSwitchHandler.isRunning(state) ? Integer.valueOf(5) : (SchedSwitchHandler.isWaiting(state) ? Integer.valueOf(1) : (SchedSwitchHandler.isDead(state) ? null : Integer.valueOf(6)));
        int quark = ss.getQuarkRelativeAndAdd(formerThreadNode.intValue(), new String[]{"Status"});
        ss.modifyAttribute(timestamp, status, quark);
    }

    private static boolean isDead(int state) {
        return (state & 0x40) != 0;
    }

    private static boolean isWaiting(int state) {
        return (state & 3) != 0;
    }

    private static boolean isRunning(int state) {
        return state == 0;
    }

    private static int setCpuStatus(ITmfStateSystemBuilder ss, Integer nextTid, Integer newCurrentThreadNode, long timestamp, int currentCPUNode, boolean modify) {
        int status;
        if (nextTid > 0) {
            int quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"});
            Object syscall = ss.queryOngoing(quark);
            status = syscall == null ? 2 : 4;
            if (modify) {
                quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
                ss.modifyAttribute(timestamp, (Object)status, quark);
            }
        } else {
            status = 0;
            if (modify) {
                int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Status"});
                ss.modifyAttribute(timestamp, (Object)status, quark);
            }
        }
        return status;
    }

    private static void setCpuProcess(ITmfStateSystemBuilder ss, Integer nextTid, long timestamp, int currentCPUNode, boolean modify) {
        int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
        if (modify) {
            ss.modifyAttribute(timestamp, (Object)nextTid, quark);
        }
    }

    private static void setNewProcessPio(ITmfStateSystemBuilder ss, Integer nextPrio, Integer newCurrentThreadNode, long timestamp) {
        int quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"Prio"});
        ss.modifyAttribute(timestamp, (Object)nextPrio, quark);
    }

    private static void setNewProcessExecName(ITmfStateSystemBuilder ss, String nextProcessName, Integer newCurrentThreadNode, long timestamp) {
        int quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"Exec_name"});
        ss.modifyAttribute(timestamp, (Object)nextProcessName, quark);
    }
}

