/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.DefaultEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ProcessStatusInterval;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.IVirtualMachineEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead.handlers.QemuKvmEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead.handlers.SchedSwitchEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class VmOverheadStateProvider
extends AbstractTmfStateProvider {
    public static final String TRACES = "Traces";
    public static final String THREADS = "Threads";
    public static final String LEVEL_1 = "1";
    public static final String LEVEL_2 = "2";
    public static final String LEVEL_3 = "3";
    public static final String STATUS_VCPU_PREEMPTED = "VCPU Preempted";
    public static final String STATUS_VMM_MODE = "VMM";
    public static final String STATUS_RUNNING = "Running";
    private static final int VERSION = 4;
    private final Multimap<String, IVirtualMachineEventHandler> fEventNames = HashMultimap.create();
    private final Collection<IVirtualMachineEventHandler> fHandlers;
    private final Map<ITmfTrace, IKernelAnalysisEventLayout> fLayouts;
    private final IVirtualEnvironmentModel fModel;
    private final Map<HostThread, GuestKernelThreadStatuses> fGuestThreads = new HashMap<HostThread, GuestKernelThreadStatuses>();

    public VmOverheadStateProvider(TmfExperiment experiment, IVirtualEnvironmentModel model) {
        super((ITmfTrace)experiment, "Vm Overhead State Provider");
        this.fModel = model;
        this.fHandlers = ImmutableSet.of((Object)new SchedSwitchEventHandler(this), (Object)new QemuKvmEventHandler(this));
        this.fLayouts = new HashMap<ITmfTrace, IKernelAnalysisEventLayout>();
    }

    private void buildEventNames(ITmfTrace trace) {
        Object layout = trace instanceof IKernelTrace ? ((IKernelTrace)trace).getKernelEventLayout() : DefaultEventLayout.getInstance();
        this.fLayouts.put(trace, (IKernelAnalysisEventLayout)layout);
        this.fHandlers.forEach(arg_0 -> this.lambda$0((IKernelAnalysisEventLayout)layout, arg_0));
    }

    public int getVersion() {
        return 4;
    }

    public TmfExperiment getTrace() {
        ITmfTrace trace = super.getTrace();
        if (trace instanceof TmfExperiment) {
            return (TmfExperiment)trace;
        }
        throw new IllegalStateException("VirtualMachineStateProvider: The associated trace should be an experiment");
    }

    public ITmfStateProvider getNewInstance() {
        TmfExperiment trace = this.getTrace();
        return new VmOverheadStateProvider(trace, this.fModel);
    }

    protected void eventHandle(ITmfEvent event) {
        HashSet toRemove = new HashSet();
        this.fGuestThreads.entrySet().forEach(t -> {
            if (!((GuestKernelThreadStatuses)t.getValue()).update(event.getTimestamp().toNanos())) {
                toRemove.add((HostThread)t.getKey());
            }
        });
        toRemove.forEach(ht -> {
            GuestKernelThreadStatuses guestKernelThreadStatuses = this.fGuestThreads.remove(ht);
        });
        String eventName = event.getName();
        @Nullable IKernelAnalysisEventLayout eventLayout = this.fLayouts.get(event.getTrace());
        if (eventLayout == null) {
            this.buildEventNames(event.getTrace());
            eventLayout = this.fLayouts.get(event.getTrace());
            if (eventLayout == null) {
                return;
            }
        }
        ITmfStateSystemBuilder ss = Objects.requireNonNull(this.getStateSystemBuilder());
        Collection handlers = this.fEventNames.get((Object)eventName);
        if (handlers.isEmpty()) {
            return;
        }
        IVirtualEnvironmentModel virtEnv = this.fModel;
        for (IVirtualMachineEventHandler handler : handlers) {
            handler.handleEvent(ss, event, virtEnv, eventLayout);
        }
    }

    public void createGuestThreadStatus(ITmfStateSystemBuilder ss, HostThread ht, long start, int tidQuark) {
        IHostModel model = ModelManager.getModelFor((String)ht.getHost());
        Iterable statuses = model.getThreadStatusIntervals(ht.getTid().intValue(), start, Long.MAX_VALUE, 1L);
        Iterator<ProcessStatusInterval> iterator = statuses.iterator();
        if (iterator.hasNext()) {
            GuestKernelThreadStatuses threadStatus = new GuestKernelThreadStatuses(ss, start, iterator, tidQuark);
            this.fGuestThreads.put(ht, threadStatus);
        }
    }

    public void removeGuestThreadStatus(HostThread ht) {
        this.fGuestThreads.remove(ht);
    }

    public static String buildThreadAttributeName(int threadId, int cpuId) {
        if (threadId == 0) {
            if (cpuId < 0) {
                return String.valueOf(threadId);
            }
            return String.valueOf(String.valueOf(threadId)) + '_' + String.valueOf(cpuId);
        }
        return String.valueOf(threadId);
    }

    private /* synthetic */ void lambda$0(IKernelAnalysisEventLayout iKernelAnalysisEventLayout, IVirtualMachineEventHandler handler) {
        handler.getRequiredEvents(iKernelAnalysisEventLayout).forEach(event -> this.fEventNames.put(event, (Object)handler));
    }

    private class GuestKernelThreadStatuses {
        private final ITmfStateSystemBuilder fSs;
        private final int fQuark;
        private final Iterator<ProcessStatusInterval> fStatuses;
        private ProcessStatusInterval fCurrentStatus;

        public GuestKernelThreadStatuses(ITmfStateSystemBuilder ss, long start, Iterator<ProcessStatusInterval> statuses, int quark) {
            this.fSs = ss;
            this.fQuark = quark;
            this.fStatuses = statuses;
            this.fCurrentStatus = statuses.next();
            this.fSs.modifyAttribute(start, (Object)this.fCurrentStatus.getProcessStatus().name(), quark);
        }

        public boolean update(long start) {
            if (start <= this.fCurrentStatus.getEnd()) {
                return true;
            }
            if (this.fStatuses.hasNext()) {
                this.fCurrentStatus = this.fStatuses.next();
                this.fSs.modifyAttribute(this.fCurrentStatus.getStart(), (Object)this.fCurrentStatus.getProcessStatus().name(), this.fQuark);
                return true;
            }
            this.fSs.removeAttribute(this.fCurrentStatus.getEnd(), this.fQuark);
            return false;
        }
    }
}

