/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ICallStackSymbol;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.ProcessStatusInterval;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IDataPalette;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.CallGraph;
import org.eclipse.tracecompass.incubator.callstack.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.incubator.callstack.core.flamechart.CallStack;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackSeries;
import org.eclipse.tracecompass.incubator.callstack.core.symbol.CallStackSymbolFactory;
import org.eclipse.tracecompass.incubator.internal.callstack.core.Activator;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.callgraph.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.core.palette.FlameWithKernelPalette;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallGraphAnalysis
extends TmfAbstractAnalysisModule
implements ICallGraphProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.callstack.callgraph";
    static final int SELF_TIME_METRIC_INDEX = 0;
    static final int CPU_TIME_METRIC_INDEX = 1;
    private static final String SELF_TIME_TITLE = Objects.requireNonNull(Messages.CallGraphStats_SelfTime);
    private static final String CPU_TIME_TITLE = Objects.requireNonNull(Messages.CallGraphStats_CpuTime);
    private static final String NB_CALLS_TITLE = Objects.requireNonNull(Messages.CallGraphStats_NbCalls);
    private static final IWeightedTreeProvider.MetricType DURATION_METRIC = new IWeightedTreeProvider.MetricType(Objects.requireNonNull(Messages.CallGraphStats_Duration), IWeightedTreeProvider.DataType.NANOSECONDS, null, true);
    private static final List<IWeightedTreeProvider.MetricType> METRICS = ImmutableList.of((Object)new IWeightedTreeProvider.MetricType(SELF_TIME_TITLE, IWeightedTreeProvider.DataType.NANOSECONDS, null, true), (Object)new IWeightedTreeProvider.MetricType(CPU_TIME_TITLE, IWeightedTreeProvider.DataType.NANOSECONDS, null, true), (Object)new IWeightedTreeProvider.MetricType(NB_CALLS_TITLE, IWeightedTreeProvider.DataType.NUMBER, null, false));
    private final IFlameChartProvider fCsProvider;
    private final CallGraph fCallGraph = new CallGraph();
    private @Nullable Collection<ISymbolProvider> fSymbolProviders = null;
    private boolean fHasKernelStatuses = false;
    private final LoadingCache<TmfTimeRange, CallGraph> fRangeCallgraphs = Objects.requireNonNull(CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<TmfTimeRange, CallGraph>(){

        public CallGraph load(TmfTimeRange range) {
            CallGraph cg = new CallGraph();
            CallGraphAnalysis.this.executeForRange(cg, range, (IProgressMonitor)new NullProgressMonitor());
            return cg;
        }
    }));

    public CallGraphAnalysis(IFlameChartProvider csProvider) {
        this.fCsProvider = csProvider;
        this.setName(NLS.bind((String)Messages.CallGraphAnalysis_NamePrefix, (Object)csProvider.getName()));
    }

    public @NonNull String getHelpText() {
        String msg = Messages.CallGraphAnalysis_Description;
        return msg != null ? msg : super.getHelpText();
    }

    public void setName(String name) {
        super.setName(NLS.bind((String)Messages.CallGraphAnalysis_NamePrefix, (Object)name));
    }

    public @NonNull String getHelpText(@NonNull ITmfTrace trace) {
        return this.getHelpText();
    }

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        return Collections.singleton(this.fCsProvider);
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        return this.executeForRange(this.fCallGraph, TmfTimeRange.ETERNITY, monitor);
    }

    private boolean executeForRange(CallGraph callgraph, TmfTimeRange range, @Nullable IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (monitor == null || trace == null) {
            return false;
        }
        Iterable<IAnalysisModule> dependentAnalyses = this.getDependentAnalyses();
        for (IAnalysisModule module : dependentAnalyses) {
            if (!(module instanceof IFlameChartProvider)) {
                return false;
            }
            module.schedule();
        }
        dependentAnalyses.forEach(t -> {
            boolean bl = t.waitForCompletion(monitor);
        });
        for (IAnalysisModule module : dependentAnalyses) {
            long end;
            long time1;
            long time0;
            long start;
            IFlameChartProvider callstackModule = (IFlameChartProvider)module;
            IHostModel model = ModelManager.getModelFor((String)callstackModule.getHostId());
            CallStackSeries callstack = callstackModule.getCallStackSeries();
            if (callstack == null || this.iterateOverCallstackSerie(callstack, model, callgraph, start = Math.min(time0 = range.getStartTime().toNanos(), time1 = range.getEndTime().toNanos()), end = Math.max(time0, time1), monitor)) continue;
            return false;
        }
        monitor.worked(1);
        monitor.done();
        return true;
    }

    @VisibleForTesting
    protected boolean iterateOverCallstackSerie(CallStackSeries callstackSerie, IHostModel model, CallGraph callgraph, long start, long end, IProgressMonitor monitor) {
        Collection<ICallStackElement> rootElements = callstackSerie.getRootElements();
        for (ICallStackElement element : rootElements) {
            if (monitor.isCanceled()) {
                return false;
            }
            this.iterateOverElement(element, model, callgraph, start, end, monitor);
        }
        return true;
    }

    private void iterateOverElement(ICallStackElement element, IHostModel model, CallGraph callgraph, long start, long end, IProgressMonitor monitor) {
        if (element.isLeaf()) {
            this.iterateOverLeafElement(element, model, callgraph, start, end, monitor);
            return;
        }
        for (ICallStackElement child : element.getChildrenElements()) {
            this.iterateOverElement(child, model, callgraph, start, end, monitor);
        }
    }

    private void iterateOverLeafElement(ICallStackElement element, IHostModel model, CallGraph callgraph, long start, long end, IProgressMonitor monitor) {
        if (!(element instanceof InstrumentedCallStackElement)) {
            throw new IllegalStateException("Call Graph Analysis: The element does not have the right type");
        }
        InstrumentedCallStackElement insElement = (InstrumentedCallStackElement)element;
        CallStack callStack = insElement.getCallStack();
        if (callStack.getMaxDepth() == 0) {
            return;
        }
        this.fHasKernelStatuses |= callStack.hasKernelStatuses();
        AbstractCalledFunction nextFunction = (AbstractCalledFunction)callStack.getNextFunction(callStack.getStartTime(), 1, null, model, start, end);
        while (nextFunction != null) {
            AggregatedCalledFunction aggregatedChild = this.createCallSite(CallStackSymbolFactory.createSymbol(nextFunction.getSymbol(), element, nextFunction.getStart()));
            this.iterateOverCallstack(element, callStack, nextFunction, 2, aggregatedChild, model, start, end, monitor);
            aggregatedChild.addFunctionCall(nextFunction);
            Iterable<ProcessStatusInterval> kernelStatuses = callStack.getKernelStatuses(nextFunction, Collections.emptyList());
            for (ProcessStatusInterval status : kernelStatuses) {
                aggregatedChild.addKernelStatus(status);
            }
            callgraph.addAggregatedCallSite(element, aggregatedChild);
            nextFunction = (AbstractCalledFunction)callStack.getNextFunction(nextFunction.getEnd(), 1, null, model, start, end);
        }
    }

    private void iterateOverCallstack(ICallStackElement element, CallStack callstack, ICalledFunction function, int nextLevel, AggregatedCalledFunction aggregatedCall, IHostModel model, long start, long end, IProgressMonitor monitor) {
        Collection samplingData;
        if (nextLevel > callstack.getMaxDepth()) {
            return;
        }
        int threadId = function.getThreadId();
        long lastSampleEnd = start;
        AbstractCalledFunction nextFunction = (AbstractCalledFunction)callstack.getNextFunction(function.getStart(), nextLevel, function, model, Math.max(function.getStart(), start), Math.min(function.getEnd(), end));
        while (nextFunction != null) {
            if (threadId > 0) {
                samplingData = model.getSamplingData(threadId, lastSampleEnd, nextFunction.getStart());
                samplingData.forEach(arg_0 -> ((AggregatedCalledFunction)aggregatedCall).addChild(arg_0));
                lastSampleEnd = nextFunction.getEnd();
            }
            AggregatedCalledFunction aggregatedChild = this.createCallSite(CallStackSymbolFactory.createSymbol(nextFunction.getSymbol(), element, nextFunction.getStart()));
            this.iterateOverCallstack(element, callstack, nextFunction, nextLevel + 1, aggregatedChild, model, start, end, monitor);
            aggregatedCall.addChild(nextFunction, aggregatedChild);
            nextFunction = (AbstractCalledFunction)callstack.getNextFunction(nextFunction.getEnd(), nextLevel, function, model, Math.max(function.getStart(), start), Math.min(function.getEnd(), end));
        }
        if (threadId > 0) {
            samplingData = model.getSamplingData(threadId, lastSampleEnd, function.getEnd() - lastSampleEnd);
            samplingData.forEach(arg_0 -> ((AggregatedCalledFunction)aggregatedCall).addChild(arg_0));
        }
    }

    public @Nullable CallStackSeries getSeries() {
        CallStackSeries series = null;
        for (IAnalysisModule dependent : this.getDependentAnalyses()) {
            if (!(dependent instanceof IFlameChartProvider)) continue;
            IFlameChartProvider csProvider = (IFlameChartProvider)dependent;
            series = csProvider.getCallStackSeries();
        }
        return series;
    }

    protected void canceling() {
    }

    @Override
    public CallGraph getCallGraph(ITmfTimestamp start, ITmfTimestamp end) {
        return (CallGraph)this.fRangeCallgraphs.getUnchecked((Object)new TmfTimeRange(start, end));
    }

    @Override
    public CallGraph getCallGraph() {
        return this.fCallGraph;
    }

    @Override
    public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
        ArrayList<IWeightedTreeGroupDescriptor> descriptors = new ArrayList<IWeightedTreeGroupDescriptor>();
        for (IAnalysisModule module : this.getDependentAnalyses()) {
            CallStackSeries serie;
            if (!(module instanceof IFlameChartProvider) || (serie = ((IFlameChartProvider)module).getCallStackSeries()) == null) continue;
            descriptors.add(serie.getRootGroup());
        }
        return descriptors;
    }

    @Override
    public AggregatedCalledFunction createCallSite(Object symbol) {
        return new AggregatedCalledFunction((ICallStackSymbol)symbol);
    }

    public List<String> getExtraDataSets() {
        if (this.fHasKernelStatuses) {
            return Collections.singletonList(String.valueOf(org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.Messages.FlameChartDataProvider_KernelStatusTitle));
        }
        return ICallGraphProvider.super.getExtraDataSets();
    }

    public IWeightedTreeProvider.MetricType getWeightType() {
        return DURATION_METRIC;
    }

    public List<IWeightedTreeProvider.MetricType> getAdditionalMetrics() {
        return METRICS;
    }

    public String toDisplayString(AggregatedCallSite callsite) {
        Collection symbolProviders = this.fSymbolProviders;
        if (symbolProviders == null) {
            ITmfTrace trace = this.getTrace();
            if (trace == null) {
                return String.valueOf(callsite.getObject());
            }
            this.fSymbolProviders = symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(trace);
        }
        return ((ICallStackSymbol)callsite.getObject()).resolve(symbolProviders);
    }

    public Object getAdditionalMetric(AggregatedCallSite object, int metricIndex) {
        if (object instanceof AggregatedCalledFunction) {
            switch (metricIndex) {
                case 0: {
                    return ((AggregatedCalledFunction)object).getSelfTime();
                }
                case 1: {
                    long cpuTime = ((AggregatedCalledFunction)object).getCpuTime();
                    return cpuTime >= 0L ? Long.valueOf(cpuTime) : "";
                }
                case 2: {
                    return ((AggregatedCalledFunction)object).getNbCalls();
                }
            }
            Activator.getInstance().logError("Unknown metric at position " + metricIndex);
        }
        return "";
    }

    public String getTitle() {
        return Objects.requireNonNull(Messages.CallGraphAnalysis_Title);
    }

    @Override
    public @NonNull IDataPalette getPalette() {
        return FlameWithKernelPalette.getInstance();
    }
}

