/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.resources.IResource;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.ExperimentManagerService;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.Trace;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services.TraceManagerService;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public final class Experiment
implements Serializable {
    private static final long serialVersionUID = -3626414315455912960L;
    private final String fName;
    private final UUID fUUID;
    private final long fNbEvents;
    private final long fStart;
    private final long fEnd;
    private final String fIndexingStatus;
    private final Set<Trace> fTraces;

    @JsonCreator
    public Experiment(@JsonProperty(value="name") String name, @JsonProperty(value="UUID") UUID uuid, @JsonProperty(value="nbEvents") long nbEvents, @JsonProperty(value="start") long start, @JsonProperty(value="end") long end, @JsonProperty(value="indexingStatus") String indexingStatus, @JsonProperty(value="traces") Set<Trace> traces) {
        this.fName = name;
        this.fUUID = uuid;
        this.fNbEvents = nbEvents;
        this.fStart = start;
        this.fEnd = end;
        this.fIndexingStatus = indexingStatus;
        this.fTraces = traces;
    }

    public static Experiment from(TmfExperiment experiment, UUID expUUID) {
        Iterator<UUID> iter = ExperimentManagerService.getTraceUUIDs(expUUID).iterator();
        LinkedHashSet traces = Sets.newLinkedHashSet((Iterable)Lists.transform((List)experiment.getTraces(), t -> Trace.from(t, (UUID)iter.next())));
        return new Experiment(experiment.getName(), expUUID, experiment.getNbEvents(), experiment.getStartTime().toNanos(), experiment.getEndTime().toNanos(), experiment.isIndexing() ? "RUNNING" : "COMPLETED", traces);
    }

    public static Experiment from(IResource experimentResource, UUID expUUID) {
        List<UUID> traceUUIDs = ExperimentManagerService.getTraceUUIDs(expUUID);
        LinkedHashSet<Trace> traces = new LinkedHashSet<Trace>(Lists.transform(traceUUIDs, uuid -> Trace.from(TraceManagerService.getTraceResource(uuid), uuid)));
        return new Experiment(experimentResource.getName(), expUUID, 0L, 0L, 0L, "CLOSED", traces);
    }

    public String getName() {
        return this.fName;
    }

    public UUID getUUID() {
        return this.fUUID;
    }

    public long getNbEvents() {
        return this.fNbEvents;
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public String getIndexingStatus() {
        return this.fIndexingStatus;
    }

    public Set<Trace> getTraces() {
        return this.fTraces;
    }

    public String toString() {
        return "Experiment [fName=" + this.fName + ", fUUID=" + this.fUUID + ", fNbEvents=" + this.fNbEvents + ", fStart=" + this.fStart + ", fEnd=" + this.fEnd + ", fIndexingStatus=" + this.fIndexingStatus + ", fTraces=" + this.fTraces + "]";
    }
}

