/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

abstract class CompilationUnitReorgChange
extends JDTChange {
    private String fCuHandle;
    private String fOldPackageHandle;
    private String fNewPackageHandle;
    private INewNameQuery fNewNameQuery;

    CompilationUnitReorgChange(IJavaScriptUnit cu, IPackageFragment dest, INewNameQuery newNameQuery) {
        this.fCuHandle = cu.getHandleIdentifier();
        this.fNewPackageHandle = dest.getHandleIdentifier();
        this.fNewNameQuery = newNameQuery;
        this.fOldPackageHandle = cu.getParent().getHandleIdentifier();
    }

    CompilationUnitReorgChange(IJavaScriptUnit cu, IPackageFragment dest) {
        this(cu, dest, null);
    }

    CompilationUnitReorgChange(String oldPackageHandle, String newPackageHandle, String cuHandle) {
        this.fOldPackageHandle = oldPackageHandle;
        this.fNewPackageHandle = newPackageHandle;
        this.fCuHandle = cuHandle;
    }

    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.beginTask(this.getName(), 1);
        try {
            IJavaScriptUnit unit = this.getCu();
            ResourceMapping mapping = JavaElementResourceMapping.create(unit);
            Change result = this.doPerformReorg((IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(unit, mapping);
            Change change = result;
            return change;
        }
        finally {
            pm.done();
        }
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws CoreException, OperationCanceledException;

    public Object getModifiedElement() {
        return this.getCu();
    }

    IJavaScriptUnit getCu() {
        return (IJavaScriptUnit)JavaScriptCore.create((String)this.fCuHandle);
    }

    IPackageFragment getOldPackage() {
        return (IPackageFragment)JavaScriptCore.create((String)this.fOldPackageHandle);
    }

    IPackageFragment getDestinationPackage() {
        return (IPackageFragment)JavaScriptCore.create((String)this.fNewPackageHandle);
    }

    String getNewName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return null;
        }
        return this.fNewNameQuery.getNewName();
    }

    static String getPackageName(IPackageFragment pack) {
        if (pack.isDefaultPackage()) {
            return RefactoringCoreMessages.MoveCompilationUnitChange_default_package;
        }
        return pack.getElementName();
    }

    private void markAsExecuted(IJavaScriptUnit unit, ResourceMapping mapping) {
        ReorgExecutionLog log = (ReorgExecutionLog)this.getAdapter(ReorgExecutionLog.class);
        if (log != null) {
            log.markAsProcessed((Object)unit);
            log.markAsProcessed((Object)mapping);
        }
    }
}

