/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.Addr32Factory;
import org.eclipse.cdt.utils.BinaryObjectAdapter;
import org.eclipse.cdt.utils.Symbol;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.core.runtime.IPath;

public class ElfBinaryObject
extends BinaryObjectAdapter {
    private BinaryObjectAdapter.BinaryObjectInfo info;
    private IBinaryParser.ISymbol[] symbols;
    private final AR.ARHeader header;
    private IAddressFactory addressFactory;
    private volatile Elf.Attribute fElfAttributes;

    public ElfBinaryObject(IBinaryParser parser, IPath p, AR.ARHeader h) {
        super(parser, p, 1);
        this.header = h;
    }

    public ElfBinaryObject(IBinaryParser parser, IPath p, int type) {
        super(parser, p, type);
        this.header = null;
    }

    void setElfAttributes(Elf.Attribute elfAttributes) {
        this.fElfAttributes = elfAttributes;
    }

    @Override
    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return super.getName();
    }

    @Override
    public InputStream getContents() throws IOException {
        if (this.getPath() != null && this.header != null) {
            return new ByteArrayInputStream(this.header.getObjectData());
        }
        return super.getContents();
    }

    @Override
    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            try {
                this.loadAll();
            }
            catch (IOException e) {
                this.symbols = NO_SYMBOLS;
            }
        }
        return this.symbols;
    }

    @Override
    protected BinaryObjectAdapter.BinaryObjectInfo getBinaryObjectInfo() {
        if (this.hasChanged() || this.info == null) {
            try {
                this.loadInfo();
            }
            catch (IOException e) {
                this.info = new BinaryObjectAdapter.BinaryObjectInfo(this);
            }
        }
        return this.info;
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.header != null) {
            return new ElfHelper(this.header.getArchiveName(), this.header.getObjectDataOffset());
        }
        return new ElfHelper(this.getPath().toOSString());
    }

    protected void loadAll() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ElfHelper helper = this.getElfHelper();){
            this.loadInfo(helper);
            this.loadSymbols(helper);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void loadInfo() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ElfHelper helper = this.getElfHelper();){
            this.loadInfo(helper);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void loadInfo(ElfHelper helper) throws IOException {
        this.info = new BinaryObjectAdapter.BinaryObjectInfo(this);
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.info.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.info.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        ElfHelper.Sizes sizes = helper.getSizes();
        this.info.bss = sizes.bss;
        this.info.data = sizes.data;
        this.info.text = sizes.text;
        this.info.soname = helper.getSoname();
        Elf.Attribute attribute = helper.getElf().getAttributes();
        this.info.isLittleEndian = attribute.isLittleEndian();
        this.info.hasDebug = attribute.hasDebug();
        this.info.cpu = attribute.getCPU();
        this.addressFactory = attribute.getAddressFactory();
        this.fElfAttributes = null;
    }

    protected void loadSymbols(ElfHelper helper) throws IOException {
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        this.addSymbols(helper.getLocalFunctions(), 1, list);
        this.addSymbols(helper.getLocalObjects(), 2, list);
        list.trimToSize();
        this.symbols = list.toArray(NO_SYMBOLS);
        Arrays.sort(this.symbols);
        list.clear();
    }

    protected void addSymbols(Elf.Symbol[] array, int type, List<Symbol> list) {
        Elf.Symbol[] symbolArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Elf.Symbol element = symbolArray[n2];
            boolean duplicateAddressFound = false;
            if (type == 1 && element.st_size == 0L) {
                for (Symbol s : list) {
                    if (!s.getAddress().equals(element.st_value)) continue;
                    duplicateAddressFound = true;
                    break;
                }
            }
            if (!duplicateAddressFound) {
                list.add(new Symbol(this, element.toString(), type, element.st_value, element.st_size));
            }
            ++n2;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        Elf elf;
        if (adapter.equals(Elf.class)) {
            try {
                return (T)new Elf(this.getPath().toOSString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (adapter.equals(ISymbolReader.class) && (elf = this.getAdapter(Elf.class)) != null) {
            return (T)elf.getSymbolReader();
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public IAddressFactory getAddressFactory() {
        if (this.addressFactory == null) {
            if (this.fElfAttributes != null) {
                this.addressFactory = this.fElfAttributes.getAddressFactory();
            }
            if (this.addressFactory == null) {
                try {
                    this.loadInfo();
                }
                catch (IOException e) {
                    return new Addr32Factory();
                }
            }
        }
        return this.addressFactory;
    }

    @Override
    public boolean isLittleEndian() {
        if (this.fElfAttributes != null) {
            return this.fElfAttributes.isLittleEndian();
        }
        return super.isLittleEndian();
    }

    @Override
    public String getCPU() {
        if (this.fElfAttributes != null) {
            return this.fElfAttributes.getCPU();
        }
        return super.getCPU();
    }
}

